/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.numismaticoverhaul;

import blue.endless.jankson.Comment;
import io.wispforest.owo.config.Option;
import io.wispforest.owo.config.annotation.Config;
import io.wispforest.owo.config.annotation.Modmenu;
import io.wispforest.owo.config.annotation.Nest;
import io.wispforest.owo.config.annotation.RestartRequired;
import io.wispforest.owo.config.annotation.Sync;
import java.util.Map;
import net.minecraft.class_2960;

@Modmenu(modId="numismatic-overhaul")
@Config(name="numismatic-overhaul", wrapperName="NumismaticOverhaulConfig")
public class NumismaticOverhaulConfigModel {
    @RestartRequired
    @Comment(value="Whether villagers should use Numismatic currency for trading")
    public boolean enableVillagerTrading = true;
    @RestartRequired
    @Comment(value="Whether Numismatic currency should be injected into the loot tables of loot chests")
    public boolean generateCurrencyInChests = true;
    @Comment(value="Where the notification for adding/removing money from the purse should be (requires rejoining to apply)")
    @Sync(value=Option.SyncMode.INFORM_SERVER)
    public MoneyMessageLocation moneyMessageLocation = MoneyMessageLocation.ACTIONBAR;
    @Nest
    public PurseOffsets purseOffsets = new PurseOffsets();
    @Nest
    public LootOptions lootOptions = new LootOptions();
    @Comment(value="Sets the base value of money dropped for an entity. This value is multiplied by the moneyMobDropVariancePercentage gamerule.\nExample of having pillagers drop around 80 Bronze Coins:\n\"mobsToBaseValues\": {\n    \"minecraft:pillager\": 80,\n}\nRequires a restart to reload correctly!\n")
    @RestartRequired
    public Map<class_2960, Integer> mobsToBaseValues = Map.of();
    @Comment(value="Scales the money dropped based on the mobs max health. Money dropped is multiplied by '(mob max health) / (20 * healthScaleReduction)'")
    public boolean scaleOnHealth = false;
    @Comment(value="Reduces the impact that health scaling has on money dropped from mobs.\nRequires a restart to reload correctly!\n")
    public float healthScaleReduction = 1.0f;

    public static enum MoneyMessageLocation {
        ACTIONBAR,
        CHAT,
        DISABLED;

    }

    public static class PurseOffsets {
        public int survivalX = 0;
        public int survivalY = 0;
        public int creativeX = 0;
        public int creativeY = 0;
        public int merchantX = 0;
        public int merchantY = 0;
    }

    public static class LootOptions {
        @Comment(value="Affects money gained from Desert Temple chests")
        public int desertMinLoot = 300;
        @Comment(value="Affects money gained from Desert Temple chests")
        public int desertMaxLoot = 1200;
        @Comment(value="Affects money gained from Dungeon and Mineshaft chests")
        public int dungeonMinLoot = 500;
        @Comment(value="Affects money gained from Dungeon and Mineshaft chests")
        public int dungeonMaxLoot = 2000;
        @Comment(value="Affects money gained from Bastion, Stronghold, Outpost and Buried Treasure chests")
        public int structureMinLoot = 1500;
        public int structureMaxLoot = 4000;
        public int strongholdLibraryMinLoot = 2000;
        public int strongholdLibraryMaxLoot = 6000;
    }
}

