/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;

public class EntityLookUtil {
    public static Vec3 getDirectionTo(Entity entity, BlockPos targetPos) {
        Vec3 origin = entity.m_146892_();
        Vec3 target = new Vec3((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.5, (double)targetPos.m_123343_() + 0.5);
        return target.m_82546_(origin).m_82541_();
    }

    public static BlockPos getBlockPosAhead(Entity entity, Vec3 direction, double distance) {
        Vec3 start = entity.m_20182_();
        Vec3 end = start.m_82549_(direction.m_82490_(distance));
        return BlockPos.m_274561_((double)end.f_82479_, (double)end.f_82480_, (double)end.f_82481_);
    }

    public static float getYawFromDirection(Vec3 dir) {
        return (float)Math.toDegrees(Math.atan2(-dir.f_82479_, dir.f_82481_));
    }

    public static float getPitchFromDirection(Vec3 dir) {
        double horiz = Math.sqrt(dir.f_82479_ * dir.f_82479_ + dir.f_82481_ * dir.f_82481_);
        return (float)(-Math.toDegrees(Math.atan2(dir.f_82480_, horiz)));
    }

    public static BlockPos getBlockAhead(Entity entity, int blocksOut) {
        double yawRad = Math.toRadians(entity.m_146908_());
        double dx = -Math.sin(yawRad);
        double dz = Math.cos(yawRad);
        double x = entity.m_20185_() + dx * (double)blocksOut;
        double y = entity.m_20186_();
        double z = entity.m_20189_() + dz * (double)blocksOut;
        return BlockPos.m_274561_((double)x, (double)y, (double)z);
    }

    public static void addParticleToCorners(AABB box, Level world) {
        double minX = box.m_82340_(Direction.Axis.X);
        double maxX = box.m_82374_(Direction.Axis.X);
        double minY = box.m_82340_(Direction.Axis.Y);
        double maxY = box.m_82374_(Direction.Axis.Y);
        double minZ = box.m_82340_(Direction.Axis.Z);
        double maxZ = box.m_82374_(Direction.Axis.Z);
        System.out.println("Box corners:");
        for (int xi = 0; xi < 2; ++xi) {
            for (int yi = 0; yi < 2; ++yi) {
                for (int zi = 0; zi < 2; ++zi) {
                    double x = xi == 0 ? minX : maxX;
                    double y = yi == 0 ? minY : maxY;
                    double z = zi == 0 ? minZ : maxZ;
                    Vec3 corner = new Vec3(x, y, z);
                    System.out.println(corner);
                    ParticleHandler.particleOutburstMap(world, 10, corner.m_7096_(), corner.m_7098_(), corner.m_7094_(), ParticleEvents.SOUL_FLAME_SMALL_OUTBURST_MAP, 0.01f);
                }
            }
        }
    }
}

