/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.registry;

import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class FluidTypeRegistry {
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"soulsweapons");
    public static final RegistryObject<FluidType> PURIFIED_BLOOD_FLUID_TYPE = FLUID_TYPES.register("purified_blood", () -> new FluidType(FluidType.Properties.create().lightLevel(10).canDrown(false)){

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return new ResourceLocation("soulsweapons", "block/purified_blood_still");
                }

                public ResourceLocation getFlowingTexture() {
                    return new ResourceLocation("soulsweapons", "block/purified_blood_flow");
                }
            });
        }
    });

    public static void register(IEventBus bus) {
        FLUID_TYPES.register(bus);
    }
}

