/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.registry;

import com.google.common.collect.Lists;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.soulsweaponry.datagen.loot_tables.BossLootTables;
import net.soulsweaponry.entity.AreaEffectSphere;
import net.soulsweaponry.entity.ai.goal.NightProwlerGoal;
import net.soulsweaponry.entity.mobs.AccursedLordBoss;
import net.soulsweaponry.entity.mobs.BigChungus;
import net.soulsweaponry.entity.mobs.ChaosMonarch;
import net.soulsweaponry.entity.mobs.DarkSorcerer;
import net.soulsweaponry.entity.mobs.DayStalker;
import net.soulsweaponry.entity.mobs.DraugrBoss;
import net.soulsweaponry.entity.mobs.EvilForlorn;
import net.soulsweaponry.entity.mobs.Forlorn;
import net.soulsweaponry.entity.mobs.FreyrSwordEntity;
import net.soulsweaponry.entity.mobs.FrostGiant;
import net.soulsweaponry.entity.mobs.Moonknight;
import net.soulsweaponry.entity.mobs.NightProwler;
import net.soulsweaponry.entity.mobs.NightShade;
import net.soulsweaponry.entity.mobs.Remnant;
import net.soulsweaponry.entity.mobs.ReturningKnight;
import net.soulsweaponry.entity.mobs.RimeSpectre;
import net.soulsweaponry.entity.mobs.SoulReaperGhost;
import net.soulsweaponry.entity.mobs.Soulmass;
import net.soulsweaponry.entity.mobs.WarmthEntity;
import net.soulsweaponry.entity.mobs.WitheredDemon;
import net.soulsweaponry.entity.projectile.Cannonball;
import net.soulsweaponry.entity.projectile.ChaosOrbEntity;
import net.soulsweaponry.entity.projectile.ChaosSkull;
import net.soulsweaponry.entity.projectile.CometSpearEntity;
import net.soulsweaponry.entity.projectile.DragonStaffProjectile;
import net.soulsweaponry.entity.projectile.DragonslayerSwordspearEntity;
import net.soulsweaponry.entity.projectile.DraupnirSpearEntity;
import net.soulsweaponry.entity.projectile.GrowingFireball;
import net.soulsweaponry.entity.projectile.LeviathanAxeEntity;
import net.soulsweaponry.entity.projectile.MjolnirProjectile;
import net.soulsweaponry.entity.projectile.MoonlightProjectile;
import net.soulsweaponry.entity.projectile.NightSkull;
import net.soulsweaponry.entity.projectile.NightsEdge;
import net.soulsweaponry.entity.projectile.NoDragWitherSkull;
import net.soulsweaponry.entity.projectile.ShadowOrb;
import net.soulsweaponry.entity.projectile.SilverBulletEntity;
import net.soulsweaponry.entity.projectile.WitheredWabbajackProjectile;
import net.soulsweaponry.entity.projectile.arrow.ChargedArrow;
import net.soulsweaponry.entity.projectile.arrow.MoonlightArrow;
import net.soulsweaponry.entity.projectile.arrow.SilverArrow;
import net.soulsweaponry.entity.projectile.arrow.TrueDamageArrow;
import net.soulsweaponry.entity.projectile.noclip.AbsorbedProjectilesOrb;
import net.soulsweaponry.entity.projectile.noclip.AirCombustion;
import net.soulsweaponry.entity.projectile.noclip.ArrowStormEntity;
import net.soulsweaponry.entity.projectile.noclip.BlackflameExplosionEntity;
import net.soulsweaponry.entity.projectile.noclip.BlackflameSnakeEntity;
import net.soulsweaponry.entity.projectile.noclip.FlamePillar;
import net.soulsweaponry.entity.projectile.noclip.FogEntity;
import net.soulsweaponry.entity.projectile.noclip.FrozenLightning;
import net.soulsweaponry.entity.projectile.noclip.GhostGlaiveEntity;
import net.soulsweaponry.entity.projectile.noclip.HolyMoonlightPillar;
import net.soulsweaponry.entity.projectile.noclip.MoltenMetal;
import net.soulsweaponry.entity.projectile.noclip.MoonveilWave;
import net.soulsweaponry.entity.projectile.noclip.NightWaveEntity;
import net.soulsweaponry.entity.projectile.noclip.WarmupLightningEntity;
import net.soulsweaponry.registry.ArmorRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.WeaponRegistry;

public class EntityRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"soulsweapons");
    public static final RegistryObject<EntityType<WitheredDemon>> WITHERED_DEMON = EntityRegistry.registerWithSpawnEgg("withered_demon", () -> EntityType.Builder.m_20704_(WitheredDemon::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.0f, 2.0f).m_20712_("withered_demon"), 0x990000, 0);
    public static final RegistryObject<EntityType<AccursedLordBoss>> ACCURSED_LORD_BOSS = EntityRegistry.registerWithSpawnEgg("accursed_lord_boss", () -> EntityType.Builder.m_20704_(AccursedLordBoss::new, (MobCategory)MobCategory.MONSTER).m_20699_(3.0f, 6.0f).m_20712_("accursed_lord_boss"), 0, 0x990000);
    public static final RegistryObject<EntityType<DraugrBoss>> DRAUGR_BOSS = EntityRegistry.registerWithSpawnEgg("draugr_boss", () -> EntityType.Builder.m_20704_(DraugrBoss::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.5f, 3.0f).m_20712_("draugr_boss"), 0x9C9C9C, 7694143);
    public static final RegistryObject<EntityType<NightShade>> NIGHT_SHADE = EntityRegistry.registerWithSpawnEgg("night_shade", () -> EntityType.Builder.m_20704_(NightShade::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.5f, 3.5f).m_20712_("night_shade"), 398638, 16576575);
    public static final RegistryObject<EntityType<ReturningKnight>> RETURNING_KNIGHT = EntityRegistry.registerWithSpawnEgg("returning_knight", () -> EntityType.Builder.m_20704_(ReturningKnight::new, (MobCategory)MobCategory.MONSTER).m_20699_(3.0f, 8.0f).m_20712_("returning_knight"), 2251096, 6554982);
    public static final RegistryObject<EntityType<Remnant>> REMNANT = EntityRegistry.registerWithSpawnEgg("remnant", () -> EntityType.Builder.m_20704_(Remnant::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.0f, 1.75f).m_20712_("remnant"), 0x626363, 65514);
    public static final RegistryObject<EntityType<DarkSorcerer>> DARK_SORCERER = EntityRegistry.registerWithSpawnEgg("dark_sorcerer", () -> EntityType.Builder.m_20704_(DarkSorcerer::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.0f, 1.75f).m_20712_("dark_sorcerer"), 0, 2572343);
    public static final RegistryObject<EntityType<BigChungus>> BIG_CHUNGUS = EntityRegistry.registerWithSpawnEgg("big_chungus", () -> EntityType.Builder.m_20704_(BigChungus::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.75f, 1.0f).m_20712_("big_chungus"), 12636653, 0);
    public static final RegistryObject<EntityType<SoulReaperGhost>> SOUL_REAPER_GHOST = EntityRegistry.registerWithSpawnEgg("soul_reaper_ghost", () -> EntityType.Builder.m_20704_(SoulReaperGhost::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.0f, 1.75f).m_20712_("soul_reaper_ghost"), 13480150, 13200614);
    public static final RegistryObject<EntityType<Forlorn>> FORLORN = EntityRegistry.registerWithSpawnEgg("forlorn", () -> EntityType.Builder.m_20704_(Forlorn::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.0f, 1.75f).m_20712_("forlorn"), 4859716, 5701896);
    public static final RegistryObject<EntityType<EvilForlorn>> EVIL_FORLORN = EntityRegistry.registerWithSpawnEgg("evil_forlorn", () -> EntityType.Builder.m_20704_(EvilForlorn::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.0f, 1.75f).m_20712_("evil_forlorn"), 5701896, 4859716);
    public static final RegistryObject<EntityType<Soulmass>> SOULMASS = EntityRegistry.registerWithSpawnEgg("soulmass", () -> EntityType.Builder.m_20704_(Soulmass::new, (MobCategory)MobCategory.MONSTER).m_20699_(2.7f, 3.5f).m_20712_("soulmass"), 4494266, 9658504);
    public static final RegistryObject<EntityType<ChaosMonarch>> CHAOS_MONARCH = EntityRegistry.registerWithSpawnEgg("chaos_monarch", () -> EntityType.Builder.m_20704_(ChaosMonarch::new, (MobCategory)MobCategory.MONSTER).m_20699_(2.5f, 6.0f).m_20712_("chaos_monarch"), 4325468, 0);
    public static final RegistryObject<EntityType<Moonknight>> MOONKNIGHT = EntityRegistry.registerWithSpawnEgg("moonknight", () -> EntityType.Builder.m_20704_(Moonknight::new, (MobCategory)MobCategory.MONSTER).m_20699_(3.0f, 8.0f).m_20712_("moonknight"), 13357520, 390585);
    public static final RegistryObject<EntityType<FrostGiant>> FROST_GIANT = EntityRegistry.registerWithSpawnEgg("frost_giant", () -> EntityType.Builder.m_20704_(FrostGiant::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.25f, 2.6f).m_20712_("frost_giant"), 152127, 4644858);
    public static final RegistryObject<EntityType<RimeSpectre>> RIME_SPECTRE = EntityRegistry.registerWithSpawnEgg("rime_spectre", () -> EntityType.Builder.m_20704_(RimeSpectre::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.0f, 2.0f).m_20712_("rime_spectre"), 7005948, 411732);
    public static final RegistryObject<EntityType<DayStalker>> DAY_STALKER = EntityRegistry.registerWithSpawnEgg("day_stalker", () -> EntityType.Builder.m_20704_(DayStalker::new, (MobCategory)MobCategory.MONSTER).m_20699_(3.5f, 5.5f).m_20712_("day_stalker"), 0x212121, 0xFF8000);
    public static final RegistryObject<EntityType<NightProwler>> NIGHT_PROWLER = EntityRegistry.registerWithSpawnEgg("night_prowler", () -> EntityType.Builder.m_20704_(NightProwler::new, (MobCategory)MobCategory.MONSTER).m_20699_(3.5f, 5.5f).m_20712_("night_prowler"), 3429253, 16717692);
    public static final RegistryObject<EntityType<WarmthEntity>> WARMTH_ENTITY = EntityRegistry.registerWithSpawnEgg("warmth_entity", () -> EntityType.Builder.m_20704_(WarmthEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.0f, 1.0f).m_20712_("warmth_entity"), 14386944, 16775147);
    public static final RegistryObject<EntityType<MoonlightProjectile>> MOONLIGHT_ENTITY_TYPE = EntityRegistry.registerEntity("moonlight_projectile", () -> EntityType.Builder.m_20704_(MoonlightProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20702_(4).m_20717_(20).m_20712_("moonlight_projectile"));
    public static final RegistryObject<EntityType<MoonlightProjectile>> MOONLIGHT_BIG_ENTITY_TYPE = EntityRegistry.registerEntity("big_moonlight_projectile", () -> EntityType.Builder.m_20704_(MoonlightProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(2.0f, 1.0f).m_20702_(4).m_20717_(20).m_20712_("big_moonlight_projectile"));
    public static final RegistryObject<EntityType<MoonlightProjectile>> DARK_MOON_PROJECTILE = EntityRegistry.registerEntity("dark_moon_projectile", () -> EntityType.Builder.m_20704_(MoonlightProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(2.0f, 1.0f).m_20702_(4).m_20717_(20).m_20712_("big_moonlight_projectile"));
    public static final RegistryObject<EntityType<MoonlightProjectile>> VERTICAL_MOONLIGHT_ENTITY_TYPE = EntityRegistry.registerEntity("vertical_moonlight_projectile", () -> EntityType.Builder.m_20704_(MoonlightProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 3.0f).m_20702_(4).m_20717_(20).m_20712_("vertical_moonlight_projectile"));
    public static final RegistryObject<EntityType<MoonlightProjectile>> HORIZONTAL_MOONLIGHT_ENTITY_TYPE = EntityRegistry.registerEntity("horizontal_moonlight_projectile", () -> EntityType.Builder.m_20704_(MoonlightProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(3.0f, 1.0f).m_20702_(4).m_20717_(20).m_20712_("horizontal_moonlight_projectile"));
    public static final RegistryObject<EntityType<MoonlightProjectile>> SUNLIGHT_PROJECTILE_SMALL = EntityRegistry.registerEntity("sunlight_projectile_small", () -> EntityType.Builder.m_20704_(MoonlightProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20702_(4).m_20717_(20).m_20712_("sunlight_projectile_small"));
    public static final RegistryObject<EntityType<MoonlightProjectile>> SUNLIGHT_PROJECTILE_BIG = EntityRegistry.registerEntity("sunlight_projectile_big", () -> EntityType.Builder.m_20704_(MoonlightProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(2.0f, 1.0f).m_20702_(4).m_20717_(20).m_20712_("sunlight_projectile_big"));
    public static final RegistryObject<EntityType<MoonlightProjectile>> VERTICAL_SUNLIGHT_PROJECTILE = EntityRegistry.registerEntity("vertical_sunlight_projectile", () -> EntityType.Builder.m_20704_(MoonlightProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 3.0f).m_20702_(4).m_20717_(20).m_20712_("vertical_sunlight_projectile"));
    public static final RegistryObject<EntityType<DragonslayerSwordspearEntity>> SWORDSPEAR_ENTITY_TYPE = EntityRegistry.registerEntity("swordspear_entity", () -> EntityType.Builder.m_20704_(DragonslayerSwordspearEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20702_(4).m_20717_(20).m_20712_("swordspear_entity"));
    public static final RegistryObject<EntityType<CometSpearEntity>> COMET_SPEAR_ENTITY_TYPE = EntityRegistry.registerEntity("comet_spear_entity", () -> EntityType.Builder.m_20704_(CometSpearEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20702_(4).m_20717_(20).m_20712_("comet_spear_entity"));
    public static final RegistryObject<EntityType<ChargedArrow>> CHARGED_ARROW_ENTITY_TYPE = EntityRegistry.registerEntity("charged_arrow_entity", () -> EntityType.Builder.m_20704_(ChargedArrow::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20).m_20712_("charged_arrow_entity"));
    public static final RegistryObject<EntityType<SilverBulletEntity>> SILVER_BULLET_ENTITY_TYPE = EntityRegistry.registerEntity("silver_bullet_entity", () -> EntityType.Builder.m_20704_(SilverBulletEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20).m_20712_("silver_bullet_entity"));
    public static final RegistryObject<EntityType<Cannonball>> CANNONBALL = EntityRegistry.registerEntity("cannonball_entity_type", () -> EntityType.Builder.m_20704_(Cannonball::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(40).m_20712_("cannonball_entity_type"));
    public static final RegistryObject<EntityType<LeviathanAxeEntity>> LEVIATHAN_AXE_ENTITY_TYPE = EntityRegistry.registerEntity("leviathan_axe_entity", () -> EntityType.Builder.m_20704_(LeviathanAxeEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 1.0f).m_20702_(4).m_20717_(20).m_20712_("leviathan_axe_entity"));
    public static final RegistryObject<EntityType<MjolnirProjectile>> MJOLNIR_ENTITY_TYPE = EntityRegistry.registerEntity("mjolnir_entity", () -> EntityType.Builder.m_20704_(MjolnirProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(0.75f, 0.75f).m_20702_(4).m_20717_(20).m_20712_("mjolnir_entity"));
    public static final RegistryObject<EntityType<FreyrSwordEntity>> FREYR_SWORD_ENTITY_TYPE = EntityRegistry.registerEntity("freyr_sword_entity", () -> EntityType.Builder.m_20704_(FreyrSwordEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.3f, 2.0f).m_20712_("freyr_sword_entity"));
    public static final RegistryObject<EntityType<ShadowOrb>> SHADOW_ORB = EntityRegistry.registerEntity("shadow_orb_entity", () -> EntityType.Builder.m_20704_(ShadowOrb::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(30).m_20712_("shadow_orb_entity"));
    public static final RegistryObject<EntityType<DraupnirSpearEntity>> DRAUPNIR_SPEAR_TYPE = EntityRegistry.registerEntity("draupnir_spear_entity", () -> EntityType.Builder.m_20704_(DraupnirSpearEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20702_(4).m_20717_(30).m_20712_("draupnir_spear_entity"));
    public static final RegistryObject<EntityType<AreaEffectSphere>> AREA_EFFECT_SPHERE = EntityRegistry.registerEntity("area_effect_sphere", () -> EntityType.Builder.m_20704_(AreaEffectSphere::new, (MobCategory)MobCategory.MISC).m_20699_(3.0f, 3.0f).m_20719_().m_20702_(4).m_20717_(Integer.MAX_VALUE).m_20712_("area_effect_sphere"));
    public static final RegistryObject<EntityType<DragonStaffProjectile>> DRAGON_STAFF_PROJECTILE = EntityRegistry.registerEntity("dragon_staff_projectile", () -> EntityType.Builder.m_20704_(DragonStaffProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20702_(4).m_20717_(10).m_20712_("dragon_staff_projectile"));
    public static final RegistryObject<EntityType<WitheredWabbajackProjectile>> WITHERED_WABBAJACK_PROJECTILE = EntityRegistry.registerEntity("withered_wabbajack_projectile", () -> EntityType.Builder.m_20704_(WitheredWabbajackProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(0.3125f, 0.3125f).m_20702_(4).m_20717_(10).m_20712_("withered_wabbajack_projectile"));
    public static final RegistryObject<EntityType<ChaosSkull>> CHAOS_SKULL = EntityRegistry.registerEntity("chaos_skull", () -> EntityType.Builder.m_20704_(ChaosSkull::new, (MobCategory)MobCategory.MISC).m_20699_(0.4f, 0.4f).m_20702_(4).m_20717_(10).m_20712_("chaos_skull"));
    public static final RegistryObject<EntityType<ChaosOrbEntity>> CHAOS_ORB_ENTITY = EntityRegistry.registerEntity("chaos_orb_entity", () -> EntityType.Builder.m_20704_(ChaosOrbEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(10).m_20712_("chaos_orb_entity"));
    public static final RegistryObject<EntityType<GrowingFireball>> GROWING_FIREBALL_ENTITY = EntityRegistry.registerEntity("growing_fireball", () -> EntityType.Builder.m_20704_(GrowingFireball::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(10).m_20717_(20).m_20712_("growing_fireball"));
    public static final RegistryObject<EntityType<NightSkull>> NIGHT_SKULL = EntityRegistry.registerEntity("night_skull", () -> EntityType.Builder.m_20704_(NightSkull::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.75f).m_20702_(15).m_20717_(20).m_20712_("night_skull"));
    public static final RegistryObject<EntityType<FogEntity>> FOG_ENTITY = EntityRegistry.registerEntity("fog_entity", () -> EntityType.Builder.m_20704_(FogEntity::new, (MobCategory)MobCategory.MISC).m_20699_(8.0f, 3.0f).m_20719_().m_20702_(4).m_20717_(Integer.MAX_VALUE).m_20712_("fog_entity"));
    public static final RegistryObject<EntityType<BlackflameSnakeEntity>> BLACKFLAME_SNAKE_ENTITY = EntityRegistry.registerEntity("blackflame_snake_entity", () -> EntityType.Builder.m_20704_(BlackflameSnakeEntity::new, (MobCategory)MobCategory.MISC).m_20699_(2.0f, 2.0f).m_20719_().m_20702_(4).m_20717_(Integer.MAX_VALUE).m_20712_("blackflame_snake_entity"));
    public static final RegistryObject<EntityType<NoDragWitherSkull>> NO_DRAG_WITHER_SKULL = EntityRegistry.registerEntity("no_drag_wither_skull", () -> EntityType.Builder.m_20704_(NoDragWitherSkull::new, (MobCategory)MobCategory.MISC).m_20699_(0.3125f, 0.3125f).m_20702_(15).m_20717_(20).m_20712_("no_drag_wither_skull"));
    public static final RegistryObject<EntityType<NightProwlerGoal.DeathSpiralEntity>> DEATH_SPIRAL_ENTITY = EntityRegistry.registerEntity("death_spiral", () -> EntityType.Builder.m_20704_(NightProwlerGoal.DeathSpiralEntity::new, (MobCategory)MobCategory.MISC).m_20699_(2.0f, 2.0f).m_20719_().m_20702_(4).m_20717_(Integer.MAX_VALUE).m_20712_("death_spiral"));
    public static final RegistryObject<EntityType<NightsEdge>> NIGHTS_EDGE = EntityRegistry.registerEntity("nights_edge", () -> EntityType.Builder.m_20704_(NightsEdge::new, (MobCategory)MobCategory.MISC).m_20699_(0.75f, 2.0f).m_20702_(6).m_20717_(Integer.MAX_VALUE).m_20712_("nights_edge"));
    public static final RegistryObject<EntityType<NightWaveEntity>> NIGHT_WAVE = EntityRegistry.registerEntity("night_wave", () -> EntityType.Builder.m_20704_(NightWaveEntity::new, (MobCategory)MobCategory.MISC).m_20699_(3.5f, 1.0f).m_20719_().m_20702_(4).m_20717_(Integer.MAX_VALUE).m_20712_("night_wave"));
    public static final RegistryObject<EntityType<FlamePillar>> FLAME_PILLAR = EntityRegistry.registerEntity("flame_pillar", () -> EntityType.Builder.m_20704_(FlamePillar::new, (MobCategory)MobCategory.MISC).m_20699_(1.5f, 1.5f).m_20719_().m_20702_(4).m_20717_(Integer.MAX_VALUE).m_20712_("flame_pillar"));
    public static final RegistryObject<EntityType<TrueDamageArrow>> KRAKEN_SLAYER_PROJECTILE = EntityRegistry.registerEntity("kraken_slayer_projectile", () -> EntityType.Builder.m_20704_(TrueDamageArrow::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20).m_20712_("kraken_slayer_projectile"));
    public static final RegistryObject<EntityType<MoonlightArrow>> MOONLIGHT_ARROW = EntityRegistry.registerEntity("moonlight_arrow", () -> EntityType.Builder.m_20704_(MoonlightArrow::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20).m_20712_("moonlight_arrow"));
    public static final RegistryObject<EntityType<ArrowStormEntity>> ARROW_STORM_ENTITY = EntityRegistry.registerEntity("arrow_storm_entity", () -> EntityType.Builder.m_20704_(ArrowStormEntity::new, (MobCategory)MobCategory.MISC).m_20699_(3.0f, 1.5f).m_20719_().m_20702_(4).m_20717_(Integer.MAX_VALUE).m_20712_("arrow_storm_entity"));
    public static final RegistryObject<EntityType<HolyMoonlightPillar>> HOLY_MOONLIGHT_PILLAR = EntityRegistry.registerEntity("holy_moonlight_pillar", () -> EntityType.Builder.m_20704_(HolyMoonlightPillar::new, (MobCategory)MobCategory.MISC).m_20699_(1.85f, 1.85f).m_20719_().m_20702_(4).m_20717_(Integer.MAX_VALUE).m_20712_("holy_moonlight_pillar"));
    public static final RegistryObject<EntityType<WarmupLightningEntity>> WARMUP_LIGHTNING = EntityRegistry.registerEntity("warmup_lightning", () -> EntityType.Builder.m_20704_(WarmupLightningEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.5f, 1.5f).m_20719_().m_20702_(4).m_20717_(Integer.MAX_VALUE).m_20712_("warmup_lightning"));
    public static final RegistryObject<EntityType<GhostGlaiveEntity>> GHOST_GLAIVE_TYPE = EntityRegistry.registerEntity("ghost_glaive", () -> EntityType.Builder.m_20704_(GhostGlaiveEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20719_().m_20702_(4).m_20717_(Integer.MAX_VALUE).m_20712_("ghost_glaive"));
    public static final RegistryObject<EntityType<MoonveilWave>> MOONVEIL_HORIZONTAL = EntityRegistry.registerEntity("moonveil_horizontal", () -> EntityType.Builder.m_20704_(MoonveilWave::new, (MobCategory)MobCategory.MISC).m_20699_(4.5f, 0.5f).m_20719_().m_20702_(4).m_20717_(Integer.MAX_VALUE).m_20712_("moonveil_horizontal"));
    public static final RegistryObject<EntityType<MoonveilWave>> MOONVEIL_VERTICAL = EntityRegistry.registerEntity("moonveil_vertical", () -> EntityType.Builder.m_20704_(MoonveilWave::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 3.0f).m_20719_().m_20702_(4).m_20717_(Integer.MAX_VALUE).m_20712_("moonveil_vertical"));
    public static final RegistryObject<EntityType<BlackflameExplosionEntity>> BLACKFLAME_EXPLOSION_ENTITY = EntityRegistry.registerEntity("blackflame_explosion_entity", () -> EntityType.Builder.m_20704_(BlackflameExplosionEntity::new, (MobCategory)MobCategory.MISC).m_20699_(2.0f, 2.0f).m_20719_().m_20702_(4).m_20717_(Integer.MAX_VALUE).m_20712_("blackflame_explosion_entity"));
    public static final RegistryObject<EntityType<AbsorbedProjectilesOrb>> ABSORBED_PROJECTILES_ORB_ENTITY = EntityRegistry.registerEntity("absorbed_projectiles_orb_entity", () -> EntityType.Builder.m_20704_(AbsorbedProjectilesOrb::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20719_().m_20702_(4).m_20717_(Integer.MAX_VALUE).m_20712_("absorbed_projectiles_orb_entity"));
    public static final RegistryObject<EntityType<FrozenLightning>> FROZEN_LIGHTNING = EntityRegistry.registerEntity("frozen_lightning", () -> EntityType.Builder.m_20704_(FrozenLightning::new, (MobCategory)MobCategory.MISC).m_20699_(2.0f, 5.0f).m_20719_().m_20702_(4).m_20717_(20).m_20712_("frozen_lightning"));
    public static final RegistryObject<EntityType<SilverArrow>> SILVER_ARROW = EntityRegistry.registerEntity("silver_arrow", () -> EntityType.Builder.m_20704_(SilverArrow::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20719_().m_20702_(4).m_20717_(20).m_20712_("silver_arrow"));
    public static final RegistryObject<EntityType<PrimedTnt>> CHUNGUS_HEAD = EntityRegistry.registerEntity("chungus_head", () -> EntityType.Builder.m_20704_(PrimedTnt::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20719_().m_20702_(4).m_20717_(20).m_20712_("chungus_head"));
    public static final RegistryObject<EntityType<AirCombustion>> AIR_COMBUSTION = EntityRegistry.registerEntity("air_combustion", () -> EntityType.Builder.m_20704_(AirCombustion::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20719_().m_20702_(16).m_20717_(20).m_20712_("air_combustion"));
    public static final RegistryObject<EntityType<MoltenMetal>> MOLTEN_METAL = EntityRegistry.registerEntity("molten_metal", () -> EntityType.Builder.m_20704_(MoltenMetal::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 0.3f).m_20719_().m_20702_(16).m_20717_(20).m_20712_("molten_metal"));

    public static <E extends EntityType<? extends Mob>> RegistryObject<E> registerWithSpawnEgg(String id, Supplier<E> entity, int primaryColor, int secondaryColor) {
        RegistryObject returnable = EntityRegistry.registerEntity(id, entity);
        Supplier<Item> egg = () -> new ForgeSpawnEggItem((Supplier)returnable, primaryColor, secondaryColor, new Item.Properties());
        ItemRegistry.registerItem(id + "_spawn_egg", egg);
        return returnable;
    }

    public static <E extends EntityType<?>> RegistryObject<E> registerEntity(String id, Supplier<E> entity) {
        return ENTITIES.register(id, entity);
    }

    private static void registerBossDrops(String id, Item ... items) {
        BossLootTables.BOSS_DROPS.put(id, Lists.newArrayList((Object[])items));
    }

    public static void register(IEventBus bus) {
        ENTITIES.register(bus);
    }

    public static void registerBossDrops() {
        EntityRegistry.registerBossDrops("accursed_lord_boss", (Item)ItemRegistry.LORD_SOUL_RED.get(), (Item)WeaponRegistry.DARKIN_BLADE.get(), (Item)ItemRegistry.WITHERED_DEMON_HEART.get());
        EntityRegistry.registerBossDrops("chaos_monarch", (Item)WeaponRegistry.WITHERED_WABBAJACK.get(), (Item)ItemRegistry.LORD_SOUL_VOID.get(), (Item)ArmorRegistry.CHAOS_CROWN.get(), (Item)ArmorRegistry.CHAOS_ROBES.get(), Items.f_265918_, (Item)ItemRegistry.BLOOD_VIAL_RECIPE_PAGE.get());
        EntityRegistry.registerBossDrops("day_stalker", (Item)WeaponRegistry.DAWNBREAKER.get(), (Item)ItemRegistry.LORD_SOUL_DAY_STALKER.get());
        EntityRegistry.registerBossDrops("draugr_boss", (Item)WeaponRegistry.DRAUGR.get());
        EntityRegistry.registerBossDrops("moonknight", (Item)WeaponRegistry.MOONLIGHT_GREATSWORD.get(), (Item)ItemRegistry.LORD_SOUL_WHITE.get(), (Item)ItemRegistry.ESSENCE_OF_LUMINESCENCE.get(), (Item)ItemRegistry.MOONSTONE.get(), (Item)ItemRegistry.MOONSTONE.get());
        EntityRegistry.registerBossDrops("night_prowler", (Item)WeaponRegistry.SOUL_REAPER.get(), (Item)WeaponRegistry.FORLORN_SCYTHE.get(), (Item)ItemRegistry.LORD_SOUL_NIGHT_PROWLER.get());
        EntityRegistry.registerBossDrops("returning_knight", (Item)WeaponRegistry.NIGHTFALL.get(), (Item)ItemRegistry.LORD_SOUL_ROSE.get(), (Item)ItemRegistry.ARKENSTONE.get(), (Item)ItemRegistry.SOUL_INGOT.get(), (Item)ItemRegistry.SOUL_INGOT.get());
        EntityRegistry.registerBossDrops("night_shade", (Item)ItemRegistry.LORD_SOUL_DARK.get(), (Item)ItemRegistry.ESSENCE_OF_EVENTIDE.get());
    }
}

