/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.networking.packets.S2C;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.soulsweaponry.client.entitydata.ClientUmbralTrespassData;

public class UTDamageCooldownSyncS2C {
    private final float damage;
    private final int cooldown;
    private final boolean shouldHeal;

    public UTDamageCooldownSyncS2C(float damage, int cooldown, boolean shouldHeal) {
        this.damage = damage;
        this.cooldown = cooldown;
        this.shouldHeal = shouldHeal;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(this.damage);
        buf.writeInt(this.cooldown);
        buf.writeBoolean(this.shouldHeal);
    }

    public UTDamageCooldownSyncS2C(FriendlyByteBuf buf) {
        this.damage = buf.readFloat();
        this.cooldown = buf.readInt();
        this.shouldHeal = buf.readBoolean();
    }

    public float getDamage() {
        return this.damage;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public boolean shouldHeal() {
        return this.shouldHeal;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            this.handlePacket(world, this);
        }));
        context.setPacketHandled(true);
    }

    private void handlePacket(ClientLevel world, UTDamageCooldownSyncS2C packet) {
        ClientUmbralTrespassData.setDamage(packet.getDamage());
        ClientUmbralTrespassData.setCooldown(packet.getCooldown());
        ClientUmbralTrespassData.setShouldHeal(packet.shouldHeal());
    }
}

