/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.networking.packets.S2C;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.soulsweaponry.util.NbtHelper;

public class SummonUUIDsSyncS2C {
    private final int length;
    private final String listId;
    private final UUID[] summons;

    public SummonUUIDsSyncS2C(int listLength, String listId, UUID[] summons) {
        this.length = listLength;
        this.listId = listId;
        this.summons = summons;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.length);
        buf.m_130070_(this.listId);
        for (UUID uuid : this.summons) {
            buf.m_130077_(uuid);
        }
    }

    public SummonUUIDsSyncS2C(FriendlyByteBuf buf) {
        this.length = buf.readInt();
        this.listId = buf.m_130277_();
        this.summons = new UUID[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.summons[i] = buf.m_130259_();
        }
    }

    public int getLength() {
        return this.length;
    }

    public String getListId() {
        return this.listId;
    }

    public UUID[] getSummons() {
        return this.summons;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft client = Minecraft.m_91087_();
            if (client.f_91074_ == null) {
                return;
            }
            this.handlePacket(client.f_91074_, this);
        }));
        context.setPacketHandled(true);
    }

    private void handlePacket(LocalPlayer player, SummonUUIDsSyncS2C packet) {
        String listId = packet.getListId();
        CompoundTag nbt = player.getPersistentData();
        NbtHelper.saveUUIDArr(nbt, packet.getSummons(), listId);
    }
}

