/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.sword;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.NightsEdge;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.util.IKeybindAbility;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import org.apache.logging.log4j.util.TriConsumer;

public class NightsEdgeItem
extends ChargeToUseItem
implements IKeybindAbility {
    public NightsEdgeItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, (int)ConfigConstructor.nights_edge_weapon_damage, ConfigConstructor.nights_edge_weapon_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.NIGHTS_EDGE, TooltipAbilities.BLIGHT);
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_nights_edge;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.isDisabled(stack)) {
            return super.m_7579_(stack, target, attacker);
        }
        if (target.m_21023_((MobEffect)EffectRegistry.BLIGHT.get())) {
            int amp = target.m_21124_((MobEffect)EffectRegistry.BLIGHT.get()).m_19564_();
            target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BLIGHT.get(), 60, amp + 1));
            if (amp >= 10) {
                target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.DECAY.get(), 80, 0));
            }
        } else {
            target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BLIGHT.get(), 60, Mth.m_14143_((float)((float)WeaponUtil.getEnchantDamageBonus(stack) / 2.0f))));
        }
        return super.m_7579_(stack, target, attacker);
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        int i;
        Player player;
        if (user instanceof Player && !(player = (Player)user).m_36335_().m_41519_((Item)this) && (i = WeaponUtil.getChargeTime(stack, remainingUseTicks)) >= 10) {
            stack.m_41622_(1, (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
            WeaponUtil.doConsumerOnLine(world, player.m_146908_() + 90.0f, player.m_20182_(), 4.0, 10 + 2 * WeaponUtil.getEnchantDamageBonus(stack), 1.25f, (TriConsumer<Vec3, Integer, Float>)((TriConsumer)(position, warmup, yaw) -> this.spawnNightsEdge(world, (LivingEntity)player, stack, (Vec3)position, (int)warmup, yaw.floatValue())));
            this.applyItemCooldown(player, this.getScaledCooldown(stack));
        }
    }

    @Override
    public void useKeybindAbilityServer(ServerLevel world, ItemStack stack, Player player) {
        if (!player.m_36335_().m_41519_((Item)this)) {
            double verticalSearch = 3.0;
            int ripples = 3 + Mth.m_14143_((float)((float)WeaponUtil.getEnchantDamageBonus(stack) / 2.0f));
            Vec2 radii = new Vec2(1.5f, 1.75f);
            float ringYaw = player.m_146908_() + 90.0f;
            WeaponUtil.doConsumerOnCircle((Level)world, ringYaw, player.m_20182_(), verticalSearch, ripples, radii, (TriConsumer<Vec3, Integer, Float>)((TriConsumer)(position, warmup, yawDeg) -> this.spawnNightsEdge((Level)world, (LivingEntity)player, stack, (Vec3)position, (int)warmup, yawDeg.floatValue())));
            this.applyItemCooldown(player, this.getScaledCooldown(stack));
            stack.m_41622_(1, (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21190_(player.m_7655_()));
        }
    }

    public void spawnNightsEdge(Level world, LivingEntity user, ItemStack stack, Vec3 position, int warmup, float yaw) {
        NightsEdge edge = new NightsEdge((EntityType<? extends NightsEdge>)((EntityType)EntityRegistry.NIGHTS_EDGE.get()), world);
        edge.setOwner(user);
        edge.setDamage(ConfigConstructor.nights_edge_ability_damage + (float)(2 * WeaponUtil.getEnchantDamageBonus(stack)));
        edge.setWarmup(warmup);
        edge.m_146922_(yaw);
        edge.m_20343_(position.f_82479_, position.f_82480_, position.f_82481_);
        world.m_7967_((Entity)edge);
    }

    protected int getScaledCooldown(ItemStack stack) {
        float base = ConfigConstructor.nights_edge_ability_cooldown;
        return (int)Math.max(ConfigConstructor.nights_edge_ability_min_cooldown, base - (float)(this.getReduceCooldownEnchantLevel(stack) * 8));
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.nights_edge_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.nights_edge_enchant_reduces_cooldown_ids;
    }

    @Override
    public void useKeybindAbilityClient(ClientLevel world, ItemStack stack, Player player) {
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_nights_edge;
    }
}

