/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.sword;

import java.util.Map;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.IDragonBonus;
import net.soulsweaponry.items.UltraHeavyWeapon;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.util.DetonateGroundAttributes;
import net.soulsweaponry.util.IKeybindAbility;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import org.apache.logging.log4j.util.TriConsumer;

public class DragonslayerSwordBerserk
extends UltraHeavyWeapon
implements IKeybindAbility,
IDragonBonus {
    private static final MobEffectInstance[] CALCULATED_FALL_EFFECTS = new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19615_, 140, 1)};
    private final DetonateGroundAttributes attributes = new DetonateGroundAttributes(ConfigConstructor.heap_of_raw_iron_calculated_fall_base_radius, ConfigConstructor.heap_of_raw_iron_calculated_fall_height_increase_radius_modifier, ConfigConstructor.heap_of_raw_iron_calculated_fall_target_launch_modifier, ConfigConstructor.heap_of_raw_iron_calculated_fall_target_max_launch_power, ConfigConstructor.heap_of_raw_iron_calculated_fall_max_radius, ConfigConstructor.heap_of_raw_iron_calculated_fall_max_damage, ConfigConstructor.heap_of_raw_iron_calculated_fall_height_increase_damage_modifier, ConfigConstructor.heap_of_raw_iron_calculated_fall_heal_from_damage_modifier, Map.of(ParticleTypes.f_123744_, new Vec3(1.0, 6.0, 1.0), (ParticleOptions)ParticleRegistry.DARK_STAR.get(), new Vec3(1.0, 6.0, 1.0)), (TriConsumer<LivingEntity, LivingEntity, Float>)((TriConsumer)(target, user, fallDistance) -> {
        for (MobEffectInstance effect : CALCULATED_FALL_EFFECTS) {
            target.m_7292_(effect);
        }
    }), (TriConsumer<LivingEntity, Float, ItemStack>)((TriConsumer)(user, fallDistance, stack) -> {}));

    public DragonslayerSwordBerserk(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, (int)ConfigConstructor.heap_of_raw_iron_damage, ConfigConstructor.heap_of_raw_iron_attack_speed, settings, true);
        this.addTooltipAbility(TooltipAbilities.RAGE, TooltipAbilities.DRAGONS_SCOURGE);
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_heap_of_raw_iron;
    }

    @Override
    public void useKeybindAbilityServer(ServerLevel world, ItemStack stack, Player user) {
        if (!user.m_36335_().m_41519_((Item)this)) {
            stack.m_41622_(1, (LivingEntity)user, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
            this.applyItemCooldown(user, this.getScaledCooldown(stack));
            int power = Mth.m_14143_((float)((float)WeaponUtil.getEnchantDamageBonus(stack) / 2.0f));
            user.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BLOODTHIRSTY.get(), 200, power));
            user.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 0));
            world.m_5594_(null, user.m_20183_(), SoundEvents.f_11894_, SoundSource.PLAYERS, 0.75f, 1.0f);
        }
    }

    @Override
    public void useKeybindAbilityClient(ClientLevel world, ItemStack stack, Player player) {
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.heap_of_raw_iron_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.heap_of_raw_iron_enchant_reduces_cooldown_ids;
    }

    protected int getScaledCooldown(ItemStack stack) {
        float base = ConfigConstructor.heap_of_raw_iron_cooldown;
        return (int)Math.max(ConfigConstructor.heap_of_raw_iron_min_cooldown, base - (float)(this.getReduceCooldownEnchantLevel(stack) * 20));
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        return InteractionResultHolder.m_19100_((Object)user.m_21120_(hand));
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_heap_of_raw_iron;
    }

    @Override
    public float getBaseDragonBonus(ItemStack stack) {
        return ConfigConstructor.heap_of_raw_iron_dragons_scourge_bonus;
    }

    @Override
    public DetonateGroundAttributes getDetonationAttributes() {
        return this.attributes;
    }

    @Override
    public int getPostureLoss() {
        return (int)ConfigConstructor.heap_of_raw_iron_posture_loss;
    }
}

