/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.sword;

import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.soulsweaponry.client.renderer.item.DarkinBladeRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.UltraHeavyWeapon;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.DetonateGroundAttributes;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import org.apache.logging.log4j.util.TriConsumer;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DarkinBlade
extends UltraHeavyWeapon
implements GeoItem {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final DetonateGroundAttributes attributes = new DetonateGroundAttributes(ConfigConstructor.darkin_blade_calculated_fall_base_radius, ConfigConstructor.darkin_blade_calculated_fall_height_increase_radius_modifier, ConfigConstructor.darkin_blade_calculated_fall_target_launch_modifier, ConfigConstructor.darkin_blade_calculated_fall_target_max_launch_power, ConfigConstructor.darkin_blade_calculated_fall_max_radius, ConfigConstructor.darkin_blade_calculated_fall_max_damage, ConfigConstructor.darkin_blade_calculated_fall_height_increase_damage_modifier, ConfigConstructor.darkin_blade_calculated_fall_heal_from_damage_modifier, Map.of(ParticleTypes.f_123744_, new Vec3(1.0, 6.0, 1.0)), (TriConsumer<LivingEntity, LivingEntity, Float>)((TriConsumer)(target, user, fallDistance) -> {}), (TriConsumer<LivingEntity, Float, ItemStack>)((TriConsumer)(user, fallDistance, stack) -> {}));

    public DarkinBlade(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, (int)ConfigConstructor.darkin_blade_damage, ConfigConstructor.darkin_blade_attack_speed, settings, true);
        this.addTooltipAbility(TooltipAbilities.OMNIVAMP, TooltipAbilities.SWORD_SLAM);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Player player;
        if (this.isDisabled(stack)) {
            return super.m_7579_(stack, target, attacker);
        }
        if (attacker instanceof Player && !(player = (Player)attacker).m_36335_().m_41519_(stack.m_41720_()) && !(player.m_21223_() >= player.m_21233_())) {
            this.applyItemCooldown(player, (int)Math.max(ConfigConstructor.lifesteal_item_min_cooldown, ConfigConstructor.lifesteal_item_cooldown - (float)(this.getReduceLifeStealCooldownEnchantLevel(stack) * 6)));
            float healing = ConfigConstructor.lifesteal_item_base_healing;
            if (ConfigConstructor.lifesteal_item_heal_scales) {
                healing += (float)Mth.m_14167_((float)((float)WeaponUtil.getEnchantDamageBonus(stack) / 2.0f));
            }
            attacker.m_5634_(healing);
        }
        return super.m_7579_(stack, target, attacker);
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player player = (Player)user;
            float cooldownMod = 1.0f;
            int i = WeaponUtil.getChargeTime(stack, remainingUseTicks);
            if (i >= 10) {
                Vec3 rotation = player.m_20154_().m_82490_(1.0);
                player.m_5997_(rotation.m_7096_(), 1.0, rotation.m_7094_());
                world.m_5594_(player, player.m_20183_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
                cooldownMod = 0.75f;
                user.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.CALCULATED_FALL.get(), 600, (int)ConfigConstructor.darkin_blade_ability_damage));
            } else {
                this.detonateGroundEffect(user, (int)ConfigConstructor.darkin_blade_ability_damage, 0.0f, world, stack);
            }
            stack.m_41622_(3, user, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
            this.applyItemCooldown(player, Mth.m_14143_((float)((float)this.getScaledCooldown(stack) * cooldownMod)));
        }
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.darkin_blade_ability_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.darkin_blade_ability_enchant_reduces_cooldown_ids;
    }

    protected int getScaledCooldown(ItemStack stack) {
        int base = (int)ConfigConstructor.darkin_blade_ability_cooldown;
        return (int)Math.max(ConfigConstructor.darkin_blade_ability_min_cooldown, (float)(base - this.getReduceCooldownEnchantLevel(stack) * 15));
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_darkin_blade;
    }

    private PlayState predicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().then("heartbeat", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 20, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private DarkinBladeRenderer renderer = null;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new DarkinBladeRenderer();
                }
                return this.renderer;
            }
        });
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_darkin_blade;
    }

    @Override
    public DetonateGroundAttributes getDetonationAttributes() {
        return this.attributes;
    }

    @Override
    public int getPostureLoss() {
        return (int)ConfigConstructor.darkin_blade_posture_loss;
    }
}

