/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.staff;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.DragonStaffProjectile;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.util.CustomDamageSource;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;

public class DragonStaff
extends ModdedSword {
    public DragonStaff(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, (int)ConfigConstructor.dragon_staff_damage, ConfigConstructor.dragon_staff_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.DRAGON_STAFF, TooltipAbilities.VENGEFUL_FOG);
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (user.m_6144_() && remainingUseTicks > 0) {
            Vec3 pov = user.m_20154_();
            Vec3 particleSpawn = pov.m_82490_(1.0);
            Vec3 area = pov.m_82490_(10.0).m_82549_(user.m_20182_());
            Vec3i on = new Vec3i((int)area.m_7096_(), (int)area.m_7098_(), (int)area.m_7094_());
            boolean healTamed = ConfigConstructor.dragon_staff_vigorous_fog_heal_tamed_entities_owned_by_others;
            for (Entity entity : world.m_45933_((Entity)user, new AABB(user.m_20182_().m_82520_(0.0, 2.0, 0.0), new BlockPos(on).m_252807_()))) {
                OwnableEntity tameable;
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                if (entity instanceof OwnableEntity && (tameable = (OwnableEntity)entity).m_21805_() != null && (tameable.m_21805_().equals(user.m_20148_()) || healTamed)) {
                    living.m_5634_(ConfigConstructor.dragon_staff_vigorous_fog_damage_and_heal);
                } else {
                    living.m_6469_(CustomDamageSource.create(world, CustomDamageSource.DRAGON_MIST, (Entity)user), ConfigConstructor.dragon_staff_vigorous_fog_damage_and_heal);
                }
                living.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.HALLOWED_DRAGON_MIST.get(), 100, (int)ConfigConstructor.dragon_staff_aura_strength));
            }
            if (world.f_46443_) {
                for (int k = 0; k < 10; ++k) {
                    world.m_6493_((ParticleOptions)ParticleRegistry.PURPLE_FLAME.get(), true, particleSpawn.m_82549_(user.m_20182_()).m_7096_(), particleSpawn.m_82549_(user.m_20182_()).m_7098_() + 1.5, particleSpawn.m_82549_(user.m_20182_()).m_7094_(), pov.f_82479_ + user.m_217043_().m_188500_() - 0.25, pov.f_82480_ + user.m_217043_().m_188500_() - 0.5, pov.f_82481_ + user.m_217043_().m_188500_() - 0.25);
                    world.m_6493_((ParticleOptions)ParticleTypes.f_123799_, true, particleSpawn.m_82549_(user.m_20182_()).m_7096_(), particleSpawn.m_82549_(user.m_20182_()).m_7098_() + 1.5, particleSpawn.m_82549_(user.m_20182_()).m_7094_(), pov.f_82479_ + user.m_217043_().m_188500_() - 0.25, pov.f_82480_ + user.m_217043_().m_188500_() - 0.5, pov.f_82481_ + user.m_217043_().m_188500_() - 0.25);
                }
            }
        } else {
            user.m_21253_();
            super.m_5929_(world, user, stack, remainingUseTicks);
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity user) {
        this.stop(user, stack);
        return super.m_5922_(stack, world, user);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        this.stop(user, stack);
        super.m_5551_(stack, world, user, remainingUseTicks);
    }

    private void stop(LivingEntity user, ItemStack stack) {
        if (user instanceof Player) {
            Player player = (Player)user;
            this.applyItemCooldown(player, this.getCooldown(stack));
        }
        stack.m_41622_(3, user, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (this.isDisabled(itemStack)) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (!user.m_6144_()) {
            if (!user.m_7500_()) {
                user.m_36335_().m_41524_((Item)this, this.getCooldown(itemStack) * 2);
            }
            world.m_6263_(user, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11896_, SoundSource.NEUTRAL, 0.5f, 2.0f / (world.m_213780_().m_188501_() * 0.4f + 0.8f));
            if (!world.f_46443_) {
                DragonStaffProjectile fireball = new DragonStaffProjectile(world, (LivingEntity)user, itemStack);
                fireball.m_20343_(user.m_20185_(), user.m_20186_() + 1.0, user.m_20189_());
                fireball.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, 1.5f, 0.0f);
                world.m_7967_((Entity)fireball);
                itemStack.m_41622_(1, (LivingEntity)user, p_220045_0_ -> p_220045_0_.m_21190_(hand));
            }
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)world.m_5776_());
        }
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return (int)(ConfigConstructor.dragon_staff_use_time + (float)(WeaponUtil.getEnchantDamageBonus(stack) * 20));
    }

    private int getCooldown(ItemStack stack) {
        return (int)Math.max(ConfigConstructor.dragon_staff_min_cooldown, ConfigConstructor.dragon_staff_cooldown - (float)(this.getReduceCooldownEnchantLevel(stack) * 10));
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_dragon_staff;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_dragon_staff;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.dragon_staff_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.dragon_staff_enchant_reduces_cooldown_ids;
    }
}

