/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.spear;

import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.soulsweaponry.client.renderer.item.CometSpearItemRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.CometSpearEntity;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.items.IDetonateGround;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.DetonateGroundAttributes;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import org.apache.logging.log4j.util.TriConsumer;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CometSpear
extends ChargeToUseItem
implements GeoItem,
IDetonateGround {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final DetonateGroundAttributes attributes = new DetonateGroundAttributes(ConfigConstructor.comet_spear_calculated_fall_base_radius, ConfigConstructor.comet_spear_calculated_fall_height_increase_radius_modifier, ConfigConstructor.comet_spear_calculated_fall_target_launch_modifier, ConfigConstructor.comet_spear_calculated_fall_target_max_launch_power, ConfigConstructor.comet_spear_calculated_fall_max_radius, ConfigConstructor.comet_spear_calculated_fall_max_damage, ConfigConstructor.comet_spear_calculated_fall_height_increase_damage_modifier, ConfigConstructor.comet_spear_calculated_fall_heal_from_damage_modifier, Map.of(ParticleTypes.f_123744_, new Vec3(1.0, 6.0, 1.0)), (TriConsumer<LivingEntity, LivingEntity, Float>)((TriConsumer)(target, user, fallDistance) -> {}), (TriConsumer<LivingEntity, Float, ItemStack>)((TriConsumer)(user, fallDistance, stack) -> {}));

    public CometSpear(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, (int)ConfigConstructor.comet_spear_damage, ConfigConstructor.comet_spear_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.SKYFALL, TooltipAbilities.INFINITY, TooltipAbilities.CRIT);
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player playerEntity = (Player)user;
            int i = WeaponUtil.getChargeTime(stack, remainingUseTicks);
            if (i >= 10) {
                float enchant = WeaponUtil.getEnchantDamageBonus(stack);
                if (user.m_6144_()) {
                    WeaponUtil.launchTarget(user, 5.0f + enchant, false);
                    playerEntity.m_204079_(20);
                    world.m_6269_(null, (Entity)playerEntity, SoundEvents.f_12519_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (playerEntity.m_20096_()) {
                        playerEntity.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                    }
                    user.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.CALCULATED_FALL.get(), 600, (int)ConfigConstructor.comet_spear_ability_damage));
                    this.applyItemCooldown(playerEntity, this.getScaledCooldownSkyfall(stack));
                    stack.m_41622_(4, (LivingEntity)playerEntity, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
                } else {
                    stack.m_41622_(2, (LivingEntity)playerEntity, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
                    this.applyItemCooldown(playerEntity, this.getScaledCooldownThrow(stack));
                    CometSpearEntity entity = new CometSpearEntity(world, (LivingEntity)playerEntity, stack);
                    entity.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, 5.0f, 1.0f);
                    entity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    world.m_7967_((Entity)entity);
                    world.m_6269_(null, (Entity)entity, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    protected int getScaledCooldownSkyfall(ItemStack stack) {
        int base = (int)ConfigConstructor.comet_spear_skyfall_ability_cooldown;
        return (int)Math.max(ConfigConstructor.comet_spear_skyfall_ability_min_cooldown, (float)(base - this.getReduceCooldownEnchantLevel(stack) * 20));
    }

    protected int getScaledCooldownThrow(ItemStack stack) {
        int base = (int)ConfigConstructor.comet_spear_throw_ability_cooldown;
        return (int)Math.max(ConfigConstructor.comet_spear_throw_ability_min_cooldown, (float)(base - this.getReduceCooldownEnchantLevel(stack) * 5));
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.comet_spear_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.comet_spear_enchant_reduces_cooldown_ids;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private CometSpearItemRenderer renderer = null;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new CometSpearItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_comet_spear;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_comet_spear;
    }

    @Override
    public DetonateGroundAttributes getDetonationAttributes() {
        return this.attributes;
    }
}

