/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.gun;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.SilverBulletEntity;
import net.soulsweaponry.items.IConfigDisable;
import net.soulsweaponry.items.ITooltipInfo;
import net.soulsweaponry.registry.EnchantRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import org.jetbrains.annotations.Nullable;

public abstract class GunItem
extends ProjectileWeaponItem
implements IConfigDisable,
ITooltipInfo {
    protected final List<TooltipAbilities> tooltipAbilities = new ArrayList<TooltipAbilities>();

    public GunItem(Item.Properties settings) {
        super(settings);
        this.addTooltipAbility(TooltipAbilities.GUN_ITEM);
    }

    public Predicate<ItemStack> m_6437_() {
        return stack -> stack.m_150930_((Item)ItemRegistry.SILVER_BULLET.get()) && stack.m_41613_() >= this.getBulletsNeeded((ItemStack)stack);
    }

    public int getReducedCooldown(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.FAST_HANDS, (ItemStack)stack) * 8;
    }

    public abstract int getPostureLoss(ItemStack var1);

    public abstract float getBulletDamage(ItemStack var1);

    public abstract float getBulletVelocity(ItemStack var1);

    public abstract float getBulletDivergence(ItemStack var1);

    public abstract int getCooldown(ItemStack var1);

    public abstract boolean m_41475_();

    public int m_8105_(ItemStack stack) {
        return 0;
    }

    public int getBulletsNeeded(ItemStack stack) {
        return 1;
    }

    public int getBulletsNeededWithInfinity(ItemStack stack) {
        return 1;
    }

    public AbstractArrow createSilverBulletEntity(Level world, LivingEntity shooter, ItemStack gunStack) {
        if (EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.MISFIRE_CURSE, (ItemStack)gunStack) > 0 && !world.f_46443_ && shooter.m_217043_().m_188500_() < ConfigConstructor.misfire_curse_enchant_trigger_chance) {
            world.m_255391_(null, shooter.m_20185_(), shooter.m_20227_(0.5), shooter.m_20189_(), 3.0f, true, Level.ExplosionInteraction.MOB);
            shooter.m_20254_(3);
        }
        float power = this.getCalculatedDamage(this.getBulletDamage(gunStack), gunStack);
        int ethereal = EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.ETHEREAL, (ItemStack)gunStack);
        int explosivePower = EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.EXPLOSIVE_ROUNDS, (ItemStack)gunStack);
        int chainLightningLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.CHAIN_LIGHTNING, (ItemStack)gunStack);
        int blightCarrierLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.BLIGHT_CARRIER, (ItemStack)gunStack);
        int freezeLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.FROSTSILVER, (ItemStack)gunStack);
        int phantomTraceLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.PHANTOM_TRACE, (ItemStack)gunStack);
        int tetherLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.TETHER, (ItemStack)gunStack);
        int ricochetLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.RICOCHET, (ItemStack)gunStack);
        SilverBulletEntity entity = this.getModdedProjectile(world, shooter, gunStack);
        entity.m_20343_(shooter.m_20185_(), shooter.m_20188_() - (double)0.4f, shooter.m_20189_());
        entity.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        entity.setMaxAge(this.getProjectileMaxAge());
        if (ethereal > 0) {
            entity.m_36790_(true);
            entity.setEthereal(true);
            entity.setMaxAge(this.getProjectileMaxAgeEthereal());
        }
        entity.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, this.getBulletVelocity(gunStack), this.getBulletDivergence(gunStack));
        entity.setPostureLoss(this.getPostureLoss(gunStack));
        entity.m_36781_(power);
        if (explosivePower > 0) {
            entity.setExplosionPower(explosivePower);
        }
        if (chainLightningLevel > 0) {
            entity.setChainLightningDamage(this.getBulletDamage(gunStack) * (float)chainLightningLevel * ConfigConstructor.chain_lightning_enchant_damage_mod_per_level);
            entity.setChainLightningRange((float)chainLightningLevel * ConfigConstructor.chain_lightning_enchant_range_per_level);
        }
        if (blightCarrierLevel > 0) {
            entity.setBlightCarrier((int)((float)blightCarrierLevel * ConfigConstructor.blight_carrier_enchant_blight_per_level));
        }
        if (freezeLevel > 0) {
            entity.setFreezeAmplifier((int)((float)freezeLevel * ConfigConstructor.frostsilver_enchant_permafrost_per_level));
        }
        if (tetherLevel > 0 && ricochetLevel == 0) {
            entity.setTether(tetherLevel);
        }
        if (ricochetLevel > 0) {
            entity.setRicochetBounces((int)((float)ricochetLevel * ConfigConstructor.ricochet_enchant_bounce_per_level));
        }
        if (phantomTraceLevel > 0) {
            for (int i = 1; i < phantomTraceLevel + 1; ++i) {
                SilverBulletEntity copy = this.getModdedProjectile(world, shooter, gunStack);
                copy.m_20361_((Entity)entity);
                copy.m_36790_(ethereal > 0);
                copy.setEthereal(ethereal > 0);
                copy.m_20084_(UUID.randomUUID());
                copy.setEchoCopy(true);
                copy.setEchoCopyTimer(10 * i);
                copy.setMaxEchoDelay(10 * i);
                copy.m_36781_(this.getCalculatedDamage(this.getBulletDamage(gunStack) * ConfigConstructor.phantom_trace_enchant_phantom_projectile_damage_mod, gunStack));
                world.m_7967_((Entity)copy);
            }
        }
        return entity;
    }

    @Nullable
    public ItemStack canShoot(Player user, ItemStack stack) {
        boolean infinity = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
        boolean bl = user.m_150110_().f_35937_ || infinity && this.getBulletsNeededWithInfinity(stack) <= 0;
        ItemStack bullet = this.getProjectileType(user, stack);
        if (!bullet.m_41619_() || bl) {
            if (bullet.m_41619_()) {
                return new ItemStack((ItemLike)ItemRegistry.SILVER_BULLET.get());
            }
            int toRemove = bl ? 0 : this.getBulletsNeeded(stack);
            Item bulletItem = (Item)ItemRegistry.SILVER_BULLET.get();
            if (infinity) {
                return bullet;
            }
            for (int slot = 0; slot < user.m_150109_().m_6643_() && toRemove > 0; ++slot) {
                ItemStack slotStack = user.m_150109_().m_8020_(slot);
                if (!slotStack.m_150930_(bulletItem)) continue;
                int removed = Math.min(slotStack.m_41613_(), toRemove);
                slotStack.m_41774_(removed);
                toRemove -= removed;
            }
            return bullet;
        }
        return null;
    }

    public ItemStack getProjectileType(Player player, ItemStack stack) {
        ItemStack slotStack;
        int needed = this.getBulletsNeeded(stack);
        Item bulletItem = (Item)ItemRegistry.SILVER_BULLET.get();
        Predicate heldPred = this.m_6442_();
        ItemStack held = ProjectileWeaponItem.m_43010_((LivingEntity)player, (Predicate)heldPred);
        if (!held.m_41619_()) {
            return held;
        }
        int totalFound = 0;
        for (int slot = 0; !(slot >= player.m_150109_().m_6643_() || (slotStack = player.m_150109_().m_8020_(slot)).m_150930_(bulletItem) && (totalFound += slotStack.m_41613_()) >= needed); ++slot) {
        }
        if (totalFound < needed) {
            if (player.m_150110_().f_35937_) {
                return new ItemStack((ItemLike)bulletItem, needed);
            }
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)bulletItem, needed);
    }

    public SilverBulletEntity getModdedProjectile(Level world, LivingEntity shooter, ItemStack gunStack) {
        return new SilverBulletEntity(world, shooter, gunStack);
    }

    public void spawnShotParticles(Level world, Player user, int amount, float spread) {
        Vec3 look = user.m_20154_();
        Vec3 eyePos = user.m_146892_();
        Vec3 muzzle = eyePos.m_82549_(look);
        RandomSource rand = user.m_217043_();
        for (int i = 0; i < amount; ++i) {
            double vx = look.f_82479_ + rand.m_188583_() * (double)spread;
            double vy = look.f_82480_ + rand.m_188583_() * (double)spread;
            double vz = look.f_82481_ + rand.m_188583_() * (double)spread;
            if (i % 2 == 0) {
                world.m_6493_((ParticleOptions)ParticleTypes.f_123744_, true, muzzle.f_82479_, muzzle.f_82480_, muzzle.f_82481_, vx, vy, vz);
            } else {
                world.m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, muzzle.f_82479_, muzzle.f_82480_, muzzle.f_82481_, vx, vy, vz);
            }
            world.m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, muzzle.f_82479_, muzzle.f_82480_, muzzle.f_82481_, vx, vy, vz);
        }
    }

    public void postShot(Level world, Player user, ItemStack stack) {
        world.m_5594_(user, user.m_20183_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
        stack.m_41622_(this.getStackDamageToApply(), (LivingEntity)user, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
        user.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        if (!user.m_7500_()) {
            user.m_36335_().m_41524_((Item)this, this.getCooldown(stack));
        }
    }

    public float getCalculatedDamage(float resultDamage, ItemStack gunStack) {
        return resultDamage / this.getBulletVelocity(gunStack) + (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)gunStack) / 2.0f;
    }

    public int getStackDamageToApply() {
        return 1;
    }

    public int getProjectileMaxAge() {
        return 60;
    }

    public int getProjectileMaxAgeEthereal() {
        return 25;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        if (this.isDisabled(stack)) {
            tooltip.add((Component)Component.m_264568_((String)"tooltip.soulsweapons.disabled", (String)"Disabled"));
        }
        this.appendTooltipAbilities(stack, world, tooltip, context);
        super.m_7373_(stack, world, tooltip, context);
    }

    @Override
    public List<TooltipAbilities> getTooltipAbilities() {
        return this.tooltipAbilities;
    }

    @Override
    public void addTooltipAbility(TooltipAbilities ... abilities) {
        Collections.addAll(this.tooltipAbilities, abilities);
    }

    @Override
    public Component[] getAdditionalTooltips() {
        return new Component[0];
    }

    public int m_6615_() {
        return 15;
    }

    public int m_6473_() {
        return 7;
    }
}

