/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.gun;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.gun.GunItem;
import net.soulsweaponry.registry.EnchantRegistry;
import net.soulsweaponry.registry.SoundRegistry;

public class GatlingGun
extends GunItem {
    public GatlingGun(Item.Properties settings) {
        super(settings);
    }

    @Override
    public int getPostureLoss(ItemStack stack) {
        int lvl = EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.VISCERAL, (ItemStack)stack);
        return (int)(ConfigConstructor.gatling_gun_posture_loss + (float)lvl * ConfigConstructor.gatling_gun_posture_loss_per_enchant_level);
    }

    @Override
    public float getBulletDamage(ItemStack stack) {
        return ConfigConstructor.gatling_gun_damage;
    }

    @Override
    public float getBulletVelocity(ItemStack stack) {
        return ConfigConstructor.gatling_gun_velocity;
    }

    @Override
    public float getBulletDivergence(ItemStack stack) {
        return ConfigConstructor.gatling_gun_divergence;
    }

    @Override
    public int getCooldown(ItemStack stack) {
        return (int)(ConfigConstructor.gatling_gun_cooldown - (float)(3 * this.getReducedCooldown(stack)) + (float)(EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) * 30));
    }

    @Override
    public int getBulletsNeeded(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0 ? this.getBulletsNeededWithInfinity(stack) : (int)ConfigConstructor.gatling_gun_bullets_needed;
    }

    @Override
    public int getBulletsNeededWithInfinity(ItemStack stack) {
        return (int)ConfigConstructor.gatling_gun_bullets_needed_with_infinity;
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_gatling_gun;
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (remainingUseTicks < this.m_8105_(stack) - 15 && remainingUseTicks % 4 == 0) {
            Player playerEntity;
            ItemStack itemStack;
            if (user instanceof Player && (itemStack = this.canShoot(playerEntity = (Player)user, stack)) != null) {
                AbstractArrow entity = this.createSilverBulletEntity(world, user, stack);
                world.m_7967_((Entity)entity);
                this.spawnShotParticles(world, playerEntity, 2 + EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.FAST_HANDS, (ItemStack)stack), 0.15f);
                world.m_5594_(playerEntity, user.m_20183_(), (SoundEvent)SoundRegistry.GATLING_GUN_BARRAGE_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        } else if (-remainingUseTicks > this.m_8105_(stack)) {
            user.m_21253_();
            super.m_5929_(world, user, stack, remainingUseTicks);
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity user) {
        this.stop(user, stack, world);
        return super.m_5922_(stack, world, user);
    }

    @Override
    public int m_8105_(ItemStack stack) {
        int lvl = EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.FAST_HANDS, (ItemStack)stack);
        return (int)(ConfigConstructor.gatling_gun_max_time * (float)(lvl == 0 ? 1 : lvl));
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        this.stop(user, stack, world);
    }

    private void stop(LivingEntity user, ItemStack stack, Level world) {
        Player player;
        world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.GATLING_GUN_STOP_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        if (user instanceof Player && !(player = (Player)user).m_7500_()) {
            player.m_36335_().m_41524_((Item)this, this.getCooldown(stack));
            stack.m_41622_(5, (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (this.isDisabled(user.m_21120_(hand))) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)user.m_21120_(hand));
        }
        ItemStack itemStack = user.m_21120_(hand);
        world.m_5594_(user, user.m_20183_(), (SoundEvent)SoundRegistry.GATLING_GUN_STARTUP_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_gatling_gun;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }
}

