/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.soulsweaponry.items.IConfigDisable;
import net.soulsweaponry.items.ICooldownItem;
import net.soulsweaponry.items.ITooltipInfo;
import net.soulsweaponry.registry.AttributeRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import org.jetbrains.annotations.Nullable;

public abstract class ModdedArmor
extends ArmorItem
implements IConfigDisable,
ICooldownItem,
ITooltipInfo {
    protected final List<TooltipAbilities> tooltipAbilities = new ArrayList<TooltipAbilities>();

    public ModdedArmor(ArmorMaterial material, ArmorItem.Type type, Item.Properties settings) {
        super(material, type, settings);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        if (this.isDisabled(stack)) {
            tooltip.add((Component)Component.m_264568_((String)"tooltip.soulsweapons.disabled", (String)"Disabled"));
        }
        this.appendTooltipAbilities(stack, world, tooltip, context);
        super.m_7373_(stack, world, tooltip, context);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (this.isDisabled(stack)) {
            return;
        }
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public List<TooltipAbilities> getTooltipAbilities() {
        return this.tooltipAbilities;
    }

    @Override
    public void addTooltipAbility(TooltipAbilities ... abilities) {
        Collections.addAll(this.tooltipAbilities, abilities);
    }

    @Override
    public Component[] getAdditionalTooltips() {
        return new Component[0];
    }

    public abstract boolean m_41475_();

    public abstract boolean isSlotActive(Player var1, EquipmentSlot var2);

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        Multimap vanilla = super.m_7167_(slot);
        if (slot == this.f_265916_.m_266308_()) {
            AttributeModifier attr;
            float[] basePostureIncrease;
            AttributeModifier attr2;
            float[] postureBuildup;
            AttributeModifier attr3;
            float[] bleedDamage;
            AttributeModifier attr4;
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(vanilla);
            float[] bleedBuildup = this.getBleedBuildupResistances();
            if (bleedBuildup != null && (attr4 = WeaponUtil.makeAttribute((Attribute)AttributeRegistry.BLEED_BUILDUP_RESISTANCE.get(), slot, bleedBuildup)) != null) {
                builder.put((Object)((Attribute)AttributeRegistry.BLEED_BUILDUP_RESISTANCE.get()), (Object)attr4);
            }
            if ((bleedDamage = this.getBleedDamageResistances()) != null && (attr3 = WeaponUtil.makeAttribute((Attribute)AttributeRegistry.BLEED_DAMAGE_RESISTANCE.get(), slot, bleedDamage)) != null) {
                builder.put((Object)((Attribute)AttributeRegistry.BLEED_DAMAGE_RESISTANCE.get()), (Object)attr3);
            }
            if ((postureBuildup = this.getPostureBuildupResistances()) != null && (attr2 = WeaponUtil.makeAttribute((Attribute)AttributeRegistry.POSTURE_BUILDUP_RESISTANCE.get(), slot, postureBuildup)) != null) {
                builder.put((Object)((Attribute)AttributeRegistry.POSTURE_BUILDUP_RESISTANCE.get()), (Object)attr2);
            }
            if ((basePostureIncrease = this.getBasePostureIncrease()) != null && (attr = WeaponUtil.makeAttribute((Attribute)AttributeRegistry.BASE_POSTURE_INCREASE.get(), slot, basePostureIncrease)) != null) {
                builder.put((Object)((Attribute)AttributeRegistry.BASE_POSTURE_INCREASE.get()), (Object)attr);
            }
            return builder.build();
        }
        return vanilla;
    }

    public float[] getBleedBuildupResistances() {
        return null;
    }

    public float[] getBleedDamageResistances() {
        return null;
    }

    public float[] getPostureBuildupResistances() {
        return null;
    }

    public float[] getBasePostureIncrease() {
        return null;
    }
}

