/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.soulsweaponry.items.ModdedItem;

public class LoreItem
extends ModdedItem {
    private final int linesOfLore;
    private final boolean isInfo;
    private final boolean fireproof;

    public LoreItem(Item.Properties settings, int linesOfLore) {
        this(settings, linesOfLore, false);
    }

    public LoreItem(Item.Properties settings, int linesOfLore, boolean fireproof) {
        this(settings, linesOfLore, false, fireproof);
    }

    public LoreItem(Item.Properties settings, int linesOfLore, boolean isInfo, boolean fireproof) {
        super(settings);
        this.linesOfLore = linesOfLore;
        this.isInfo = isInfo;
        this.fireproof = fireproof;
    }

    private String getIdName() {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)this);
        return id.m_135815_();
    }

    public boolean isInfo() {
        return this.isInfo;
    }

    public Component[] getInfo() {
        Component[] tooltips = new Component[this.linesOfLore];
        for (int i = 1; i <= this.linesOfLore; ++i) {
            tooltips[i - 1] = Component.m_237115_((String)("tooltip.soulsweapons." + this.getIdName() + ".part_" + i)).m_130940_(ChatFormatting.DARK_GRAY);
        }
        return tooltips;
    }

    @Override
    public Component[] getAdditionalTooltips() {
        return this.isInfo() && this.getInfo().length > 0 ? this.getInfo() : super.getAdditionalTooltips();
    }

    @Override
    public Component[] getLoreTooltips() {
        return !this.isInfo() && this.getInfo().length > 0 ? this.getInfo() : super.getAdditionalTooltips();
    }

    @Override
    public boolean m_41475_() {
        return this.fireproof;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return false;
    }
}

