/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.soulsweaponry.client.registry.KeyBindRegistry;
import net.soulsweaponry.config.ClientConfig;
import net.soulsweaponry.mixin.KeyBindingAccessor;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.TooltipUtil;
import net.soulsweaponry.util.WeaponUtil;
import org.jetbrains.annotations.Nullable;

public interface ITooltipInfo {
    public List<TooltipAbilities> getTooltipAbilities();

    public Component[] getAdditionalTooltips();

    public void addTooltipAbility(TooltipAbilities ... var1);

    default public Component[] getLoreTooltips() {
        return new Component[0];
    }

    default public boolean removeTooltipAbility(TooltipAbilities ability) {
        return this.getTooltipAbilities().remove((Object)ability);
    }

    default public void appendTooltipAbilities(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        if (this.getAdditionalTooltips().length > 0 || this.getTooltipAbilities() != null && !this.getTooltipAbilities().isEmpty()) {
            if (ITooltipInfo.shouldShowInfo()) {
                for (TooltipAbilities ability : this.getTooltipAbilities()) {
                    TooltipUtil.addAbilityTooltip(ability, stack, tooltip);
                }
                tooltip.addAll(Arrays.asList(this.getAdditionalTooltips()));
            } else {
                ITooltipInfo.addShowInfoText(tooltip);
            }
        }
        if (this.getLoreTooltips().length > 0) {
            if (ITooltipInfo.shouldShowLore()) {
                tooltip.addAll(Arrays.asList(this.getLoreTooltips()));
            } else {
                ITooltipInfo.addShowLoreText(tooltip);
            }
        }
    }

    public static boolean shouldShowInfo() {
        if (ClientConfig.always_show_item_tooltip) {
            return true;
        }
        if (KeyBindRegistry.showItemTooltip.m_90862_()) {
            boolean epicFight = WeaponUtil.isModLoaded("epicfight");
            return epicFight ? Screen.m_96639_() : Screen.m_96638_();
        }
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)((KeyBindingAccessor)KeyBindRegistry.showItemTooltip).getBoundKey().m_84873_());
    }

    public static boolean shouldShowLore() {
        if (ClientConfig.always_show_item_lore) {
            return true;
        }
        if (KeyBindRegistry.showItemLore.m_90862_()) {
            return Screen.m_96637_();
        }
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)((KeyBindingAccessor)KeyBindRegistry.showItemLore).getBoundKey().m_84873_());
    }

    public static Component getShowInfoKeyText() {
        if (KeyBindRegistry.showItemTooltip.m_90862_()) {
            boolean epicFight = WeaponUtil.isModLoaded("epicfight");
            return epicFight ? Component.m_237115_((String)"key.keyboard.left.alt") : Component.m_237115_((String)"key.keyboard.left.shift");
        }
        return KeyBindRegistry.showItemTooltip.m_90863_();
    }

    public static Component getShowLoreKeyText() {
        if (KeyBindRegistry.showItemLore.m_90862_()) {
            return Component.m_237115_((String)"key.keyboard.left.control");
        }
        return KeyBindRegistry.showItemLore.m_90863_();
    }

    public static MutableComponent formatKeybindText(Component input) {
        MutableComponent text = input.m_6881_();
        String upper = text.getString().toUpperCase(Locale.ROOT);
        return Component.m_237113_((String)upper).m_130940_(ChatFormatting.YELLOW);
    }

    public static void addShowInfoText(List<Component> tooltip) {
        MutableComponent keyText = ITooltipInfo.formatKeybindText(ITooltipInfo.getShowInfoKeyText());
        tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.show_item_info", (Object[])new Object[]{keyText}));
    }

    public static void addShowLoreText(List<Component> tooltip) {
        MutableComponent keyText = ITooltipInfo.formatKeybindText(ITooltipInfo.getShowLoreKeyText());
        tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.show_item_lore", (Object[])new Object[]{keyText}));
    }
}

