/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.util;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RandomSummonPos {
    private final Level world;
    private final RandomSource random;
    private final int spawnAmount;
    private final int maxFails;
    private final BlockPos start;
    private final int radius;
    private final int minYOffset;
    private final int maxYOffset;
    private final Consumer<Vec3> consumer;

    public RandomSummonPos(Level world, RandomSource random, int spawnAmount, int maxFails, BlockPos start, int radius, int minYOffset, int maxYOffset, Consumer<Vec3> consumer) {
        this.world = world;
        this.random = random;
        this.spawnAmount = spawnAmount;
        this.maxFails = maxFails;
        this.start = start;
        this.radius = radius;
        this.minYOffset = minYOffset;
        this.maxYOffset = maxYOffset;
        this.consumer = consumer;
    }

    public void applySummonSpawns() {
        int spawns = 0;
        int fails = 0;
        while (spawns < this.spawnAmount && fails < this.maxFails) {
            BlockPos blockPos = this.getRandomValidSpawn();
            if (blockPos != null) {
                Vec3 pos = blockPos.m_252807_();
                this.consumer.accept(pos);
                ++spawns;
                continue;
            }
            ++fails;
        }
    }

    @Nullable
    public BlockPos getRandomValidSpawn() {
        int xOffset = this.random.m_188503_(this.radius * 2) - this.radius;
        int zOffset = this.random.m_188503_(this.radius * 2) - this.radius;
        int spawnX = this.start.m_123341_() + xOffset;
        int spawnZ = this.start.m_123343_() + zOffset;
        int minY = this.start.m_123342_() - this.minYOffset;
        int maxY = this.start.m_123342_() + this.maxYOffset;
        BlockPos spawnPos = null;
        for (int y = maxY; y >= minY; --y) {
            BlockPos currentPos = new BlockPos(spawnX, y, spawnZ);
            if (!this.isValidSpawn(currentPos)) continue;
            spawnPos = currentPos;
            break;
        }
        return spawnPos;
    }

    public boolean isValidSpawn(BlockPos pos) {
        return this.world.m_8055_(pos).m_60795_() && !this.world.m_8055_(pos.m_7495_()).m_60795_();
    }
}

