/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile.noclip;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.soulsweaponry.entity.mobs.NightProwler;
import net.soulsweaponry.entity.projectile.noclip.NoClipEntity;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import org.jetbrains.annotations.Nullable;

public class BlackflameSnakeEntity
extends NoClipEntity {
    private boolean hasHitPlayer;
    private static final EntityDataAccessor<Optional<UUID>> TARGET_UUID = SynchedEntityData.m_135353_(BlackflameSnakeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public BlackflameSnakeEntity(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
    }

    public BlackflameSnakeEntity(Level world) {
        super((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.BLACKFLAME_SNAKE_ENTITY.get()), world);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            Entity target = this.getSavedTarget((ServerLevel)this.m_9236_());
            if (target != null) {
                double f = target.m_20185_() - this.m_20185_();
                double g = (target.m_20227_(0.5) - this.m_20227_(0.5)) / 4.0;
                double h = target.m_20189_() - this.m_20189_();
                this.m_6686_(f, g, h, 0.3f, 1.0f);
                this.f_19864_ = true;
            }
            if (this.f_19797_ % 4 == 0) {
                for (Entity entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_())) {
                    LivingEntity living;
                    if (!(entity instanceof LivingEntity) || this.m_150171_((Entity)(living = (LivingEntity)entity)) || entity instanceof NightProwler || !living.m_6469_(this.m_9236_().m_269111_().m_269299_((Entity)this, (LivingEntity)this.m_19749_()), (float)this.m_36789_())) continue;
                    living.m_5997_(0.0, 1.5, 0.0);
                    if (!(living instanceof Player)) continue;
                    this.hasHitPlayer = true;
                }
                this.m_5496_(SoundEvents.f_11913_, 1.0f, 1.0f);
            }
        } else if (this.f_19797_ % 4 == 0) {
            ParticleHandler.particleOutburstMap(this.m_9236_(), 100, this.m_20185_(), this.m_20186_(), this.m_20189_(), ParticleEvents.BLACKFLAME_SNAKE_PARTICLE_MAP, 1.0f);
        }
        if (this.f_19797_ > 100 || this.hasHitPlayer) {
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, true, Level.ExplosionInteraction.TNT);
            this.m_146870_();
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_UUID, Optional.empty());
    }

    public void setTargetUuid(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(TARGET_UUID, Optional.ofNullable(uuid));
    }

    public UUID getTargetUuid() {
        return ((Optional)this.f_19804_.m_135370_(TARGET_UUID)).orElse(null);
    }

    @Nullable
    public Entity getSavedTarget(ServerLevel world) {
        return world.m_8791_(this.getTargetUuid());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        UUID uUID = null;
        if (nbt.m_128403_("TargetUuid")) {
            uUID = nbt.m_128342_("TargetUuid");
        }
        if (uUID != null) {
            try {
                this.setTargetUuid(uUID);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (nbt.m_128441_("HasHitPlayer")) {
            this.hasHitPlayer = nbt.m_128471_("HasHitPlayer");
        }
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.getTargetUuid() != null) {
            nbt.m_128362_("TargetUuid", this.getTargetUuid());
        }
        nbt.m_128379_("HasHitPlayer", this.hasHitPlayer);
    }
}

