/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile.noclip;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.SoulsWeaponry;
import net.soulsweaponry.entity.projectile.noclip.NoClipEntity;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import org.jetbrains.annotations.Nullable;

public class AbsorbedProjectilesOrb
extends NoClipEntity {
    private final List<EntityType<?>> projectileTypes = new ArrayList();
    private final List<Float> projectileDamage = new ArrayList<Float>();
    private int currentIndex = 0;
    private UUID targetUuid;

    public AbsorbedProjectilesOrb(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
    }

    public AbsorbedProjectilesOrb(Level world, LivingEntity target) {
        super((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.ABSORBED_PROJECTILES_ORB_ENTITY.get()), world);
        this.targetUuid = target.m_20148_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.f_19797_ % 5 == 0) {
                List<Vec3> list = ParticleHandler.getSphereParticleCords(50.0, 1.0f);
                for (Vec3 vec : list) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleRegistry.NIGHTFALL_PARTICLE.get(), this.m_20185_() + vec.m_7096_(), this.m_20186_() + vec.m_7098_(), this.m_20189_() + vec.m_7094_(), 0.0, 0.0, 0.0);
                }
            }
        } else {
            if (this.f_19797_ > 20 && this.f_19797_ % 5 == 0 && !this.projectileTypes.isEmpty() && this.getTarget() != null) {
                try {
                    Entity target = this.getTarget();
                    double d = target.m_20185_() - this.m_20185_();
                    double e = target.m_20188_() - this.m_20227_(0.5);
                    double f = target.m_20189_() - this.m_20189_();
                    double g = Math.sqrt(d * d + f * f);
                    EntityType<?> entityType = this.projectileTypes.get(this.currentIndex);
                    float damage = this.projectileDamage.get(this.currentIndex).floatValue();
                    Entity entity = entityType.m_20615_(this.m_9236_());
                    if (entity instanceof Projectile) {
                        Projectile projectile = (Projectile)entity;
                        entity.m_20343_(this.m_20185_(), this.m_20188_(), this.m_20189_());
                        projectile.m_6686_(d, e + g * (double)0.2f, f, 1.6f, 1.0f);
                        projectile.m_5602_(this.m_19749_());
                        if (projectile instanceof AbstractArrow) {
                            AbstractArrow persistent = (AbstractArrow)projectile;
                            persistent.m_36781_((double)damage);
                        }
                        this.m_9236_().m_7967_(entity);
                    }
                    ++this.currentIndex;
                    if (this.currentIndex >= this.projectileTypes.size()) {
                        this.m_146870_();
                    }
                }
                catch (Exception e) {
                    SoulsWeaponry.LOGGER.warn("Current index exceeded amount in list. Discarding entity.");
                    this.m_146870_();
                }
            }
            if (this.projectileTypes.isEmpty()) {
                this.m_146870_();
            }
        }
    }

    @Nullable
    public Entity getTarget() {
        if (!this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(this.targetUuid);
        }
        return null;
    }

    public void setProjectiles(List<EntityType<?>> projectileTypes, List<Float> projectileDamage) {
        this.projectileTypes.addAll(projectileTypes);
        this.projectileDamage.addAll(projectileDamage);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("Target")) {
            this.targetUuid = nbt.m_128342_("Target");
        }
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128362_("Target", this.targetUuid);
    }
}

