/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile.arrow;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.IPostureLossProjectile;
import net.soulsweaponry.entity.projectile.arrow.ModArrow;
import net.soulsweaponry.registry.EntityRegistry;

public class SilverArrow
extends ModArrow
implements IPostureLossProjectile {
    private int postureLoss;
    private float bonusUndeadDamage;

    public SilverArrow(EntityType<? extends Arrow> entityType, Level world) {
        super(entityType, world);
    }

    public SilverArrow(double x, double y, double z, Level world) {
        super((EntityType<? extends Arrow>)((EntityType)EntityRegistry.SILVER_ARROW.get()), x, y, z, world);
    }

    public SilverArrow(LivingEntity owner, Level world) {
        super((EntityType<? extends Arrow>)((EntityType)EntityRegistry.SILVER_ARROW.get()), owner, world);
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            this.applyPostureLoss(target);
            if (target.m_21222_()) {
                this.m_36781_(this.m_36789_() + (double)this.getBonusUndeadDamage() / this.m_20184_().m_82553_());
            }
        }
        super.m_5790_(entityHitResult);
    }

    @Override
    public int getPostureLoss() {
        return this.postureLoss;
    }

    @Override
    public void setPostureLoss(int postureLoss) {
        this.postureLoss = postureLoss;
    }

    public float getBonusUndeadDamage() {
        return this.bonusUndeadDamage;
    }

    public void setBonusUndeadDamage(float bonusUndeadDamage) {
        this.bonusUndeadDamage = bonusUndeadDamage;
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("postureLoss")) {
            this.setPostureLoss(nbt.m_128451_("postureLoss"));
        }
        if (nbt.m_128441_("bonusUndeadDamage")) {
            this.setBonusUndeadDamage(nbt.m_128457_("bonusUndeadDamage"));
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("postureLoss", this.getPostureLoss());
        nbt.m_128350_("bonusUndeadDamage", this.getBonusUndeadDamage());
    }

    @Override
    public boolean canHaveArrowEffects(ItemStack arrowStack, ItemStack bowStack) {
        return ConfigConstructor.simons_bowblade_projectile_can_apply_arrow_effects;
    }
}

