/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class NightsEdge
extends PathfinderMob
implements TraceableEntity,
GeoEntity {
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUuid;
    private int warmup;
    public int maxTicks;
    private int ticksLeft;
    private float damage;
    private boolean startedAttack;
    private final AnimatableInstanceCache factory;
    private static final EntityDataAccessor<Boolean> EMERGE = SynchedEntityData.m_135353_(NightsEdge.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public NightsEdge(EntityType<? extends NightsEdge> type, Level world) {
        super(type, world);
        this.ticksLeft = this.maxTicks = 15;
        this.damage = 15.0f;
        this.factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
        this.f_19794_ = true;
    }

    public boolean m_20068_() {
        return true;
    }

    public void setWarmup(int warmup) {
        this.warmup = warmup;
    }

    public int getWarmup() {
        return this.warmup;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 120.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22278_, 10.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22280_, 0.8);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.setWarmup(this.getWarmup() - 1);
            if (this.getWarmup() < 0) {
                this.setEmerge(true);
                if (this.getWarmup() == -7) {
                    List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(0.2));
                    for (LivingEntity livingEntity : list) {
                        this.damage(livingEntity);
                    }
                }
                if (!this.startedAttack) {
                    this.m_9236_().m_7605_((Entity)this, (byte)4);
                    this.startedAttack = true;
                }
                if (--this.ticksLeft < 0) {
                    this.m_146870_();
                }
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    private void damage(LivingEntity target) {
        LivingEntity livingEntity = this.getOwner();
        if (target.m_6084_() && !target.m_20147_() && target != livingEntity) {
            if (livingEntity == null) {
                if (target.m_6469_(this.m_269291_().m_269425_(), this.getDamage())) {
                    target.m_5997_(0.0, 0.5, 0.0);
                }
            } else if (!livingEntity.m_7307_((Entity)target) && target.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)livingEntity), this.getDamage())) {
                target.m_5997_(0.0, 0.5, 0.0);
            }
        }
    }

    public void m_7822_(byte status) {
        super.m_7822_(status);
        if (status == 4 && !this.m_20067_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11865_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.2f + 0.85f, false);
        }
    }

    private float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EMERGE, (Object)false);
    }

    private void setEmerge(boolean bl) {
        this.f_19804_.m_135381_(EMERGE, (Object)bl);
    }

    private boolean getEmerge() {
        return (Boolean)this.f_19804_.m_135370_(EMERGE);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("Warmup")) {
            this.warmup = nbt.m_128451_("Warmup");
        }
        if (nbt.m_128403_("Owner")) {
            this.ownerUuid = nbt.m_128342_("Owner");
        }
        if (nbt.m_128441_("Damage")) {
            this.damage = nbt.m_128457_("Damage");
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("Warmup", this.warmup);
        nbt.m_128350_("Damage", this.damage);
        if (this.ownerUuid != null) {
            nbt.m_128362_("Owner", this.ownerUuid);
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUuid != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUuid)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void setOwner(@Nullable LivingEntity owner) {
        this.owner = owner;
        this.ownerUuid = owner == null ? null : owner.m_20148_();
    }

    private PlayState idle(AnimationState<?> state) {
        if (this.getEmerge()) {
            state.getController().setAnimation(RawAnimation.begin().then("emerge", Animation.LoopType.HOLD_ON_LAST_FRAME));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle", 0, this::idle)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

