/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.ModPersistentProjectile;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import org.jetbrains.annotations.Nullable;

public class DragonslayerSwordspearEntity
extends ModPersistentProjectile {
    private static final EntityDataAccessor<Boolean> ENCHANTED = SynchedEntityData.m_135353_(DragonslayerSwordspearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean dealtDamage;

    public DragonslayerSwordspearEntity(EntityType<? extends DragonslayerSwordspearEntity> entityType, Level world) {
        super(entityType, world);
        this.setItemStack(new ItemStack((ItemLike)WeaponRegistry.DRAGONSLAYER_SWORDSPEAR.get()));
    }

    public DragonslayerSwordspearEntity(Level world, LivingEntity owner, ItemStack stack) {
        super((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.SWORDSPEAR_ENTITY_TYPE.get()), owner, world);
        this.setItemStack(stack.m_41777_());
        this.f_19804_.m_135381_(ENCHANTED, (Object)stack.m_41790_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ENCHANTED, (Object)false);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        if (this.f_19797_ > 60) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        super.m_8119_();
    }

    public boolean isEnchanted() {
        return (Boolean)this.f_19804_.m_135370_(ENCHANTED);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 currentPosition, Vec3 nextPosition) {
        return this.dealtDamage ? null : super.m_6351_(currentPosition, nextPosition);
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        float f = ConfigConstructor.dragonslayer_swordspear_projectile_damage;
        if (this.m_19749_() == null || entity == null) {
            return;
        }
        if (entity instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_7941_(), (MobType)((LivingEntity)entity).m_6336_());
        }
        Entity entity2 = this.m_19749_();
        DamageSource damageSource = this.m_9236_().m_269111_().m_269548_();
        this.dealtDamage = true;
        SoundEvent soundEvent = SoundEvents.f_12514_;
        if (entity.m_6469_(damageSource, f)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity;
                if (entity2 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingEntity2, (Entity)entity2);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity2), (Entity)livingEntity2);
                }
                this.m_7761_(livingEntity2);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float g = 1.0f;
        if (!this.m_9236_().f_46443_) {
            BlockPos blockPos = entity.m_20183_();
            if (this.m_9236_().m_45527_(blockPos)) {
                int i = 0;
                while ((float)i < ConfigConstructor.dragonslayer_swordspear_lightning_amount) {
                    LightningBolt lightningEntity = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                    lightningEntity.m_20219_(Vec3.m_82539_((Vec3i)blockPos));
                    lightningEntity.m_20879_(entity2 instanceof ServerPlayer ? (ServerPlayer)entity2 : null);
                    this.m_9236_().m_7967_((Entity)lightningEntity);
                    soundEvent = SoundEvents.f_12521_;
                    g = 5.0f;
                    ++i;
                }
            }
        }
        this.m_5496_(soundEvent, g, 1.0f);
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_5825_() {
        return true;
    }
}

