/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.ai.goal.AccursedLordGoal;
import net.soulsweaponry.entity.mobs.BossEntity;
import net.soulsweaponry.entity.mobs.ChaosMonarch;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class AccursedLordBoss
extends BossEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public int deathTicks;
    private int spawnTicks;
    private static final EntityDataAccessor<Integer> ATTACKS = SynchedEntityData.m_135353_(AccursedLordBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public ArrayList<BlockPos> lavaPos = new ArrayList();

    public AccursedLordBoss(EntityType<? extends AccursedLordBoss> entityType, Level world) {
        super(entityType, world, BossEvent.BossBarColor.RED);
    }

    @Override
    public boolean m_5825_() {
        return ConfigConstructor.decaying_king_is_fire_immune;
    }

    private PlayState attackAnimations(AnimationState<?> state) {
        switch (this.getAttackAnimation().ordinal()) {
            case 1: 
            case 5: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.model.shootFireMouth"));
                break;
            }
            case 6: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.model.groundSlamHand"));
                break;
            }
            case 3: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.model.explosion"));
                break;
            }
            case 2: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.model.pull"));
                break;
            }
            case 4: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.model.spin"));
                break;
            }
            case 0: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.model.swordSlam"));
                break;
            }
            case 8: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.model.death"));
                break;
            }
            case 7: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.model.spawn"));
                break;
            }
            default: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.model.idle"));
            }
        }
        return PlayState.CONTINUE;
    }

    @Override
    public int getTicksUntilDeath() {
        return 150;
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public int getXp() {
        return (int)ConfigConstructor.decaying_king_xp;
    }

    @Override
    public boolean isSpawning() {
        return this.getAttackAnimation().equals((Object)AccursedLordAnimations.SPAWN);
    }

    @Override
    public SoundEvent getBossMusic() {
        return null;
    }

    @Override
    public boolean hasBossMusic() {
        return false;
    }

    @Override
    public void m_6153_() {
        ++this.deathTicks;
        if (this.deathTicks >= this.getTicksUntilDeath() && !this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            CustomDeathHandler.deathExplosionEvent(this.m_9236_(), this.m_20182_(), (SoundEvent)SoundRegistry.DAWNBREAKER_EVENT.get(), new ParticleOptions[]{ParticleTypes.f_123755_, ParticleTypes.f_123744_});
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new AccursedLordGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, ChaosMonarch.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, WitherSkeleton.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, WitherBoss.class, true));
        this.f_21346_.m_25352_(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        super.m_8099_();
    }

    public static AttributeSupplier.Builder createDemonAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 60.0).m_22268_(Attributes.f_22276_, ConfigConstructor.decaying_king_health).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, ConfigConstructor.decaying_king_armor).m_22268_(Attributes.f_22282_, 2.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKS, (Object)9);
    }

    public void setAttackAnimation(AccursedLordAnimations attack) {
        for (int i = 0; i < AccursedLordAnimations.values().length; ++i) {
            if (!AccursedLordAnimations.values()[i].equals((Object)attack)) continue;
            this.f_19804_.m_135381_(ATTACKS, (Object)i);
        }
    }

    public void setAttackAnimation(int random) {
        this.f_19804_.m_135381_(ATTACKS, (Object)random);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isSpawning()) {
            ++this.spawnTicks;
            for (int i = 0; i < 50; ++i) {
                RandomSource random = this.m_217043_();
                BlockPos pos = this.m_20183_();
                double d = random.m_188583_() * 0.05;
                double e = random.m_188583_() * 0.05;
                double newX = random.m_188500_() - 0.5 + random.m_188583_() * 0.15 + d;
                double newZ = random.m_188500_() - 0.5 + random.m_188583_() * 0.15 + e;
                double newY = random.m_188500_() - 0.5 + random.m_188500_() * 0.5;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), newX / 2.0, newY / 6.0, newZ / 2.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), newX / 2.0, newY / 6.0, newZ / 2.0);
            }
            if (this.spawnTicks % 10 == 0 && this.spawnTicks < 70) {
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12601_, SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (this.spawnTicks == 111) {
                this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.DAWNBREAKER_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                AABB chunkBox = new AABB(this.m_20183_()).m_82400_(5.0);
                List nearbyEntities = this.m_9236_().m_45933_((Entity)this, chunkBox);
                for (Entity nearbyEntity : nearbyEntities) {
                    if (!(nearbyEntity instanceof LivingEntity)) continue;
                    LivingEntity closestTarget = (LivingEntity)nearbyEntity;
                    double x = closestTarget.m_20185_() - this.m_20185_();
                    double z = closestTarget.m_20189_() - this.m_20189_();
                    closestTarget.m_147240_(10.0, -x, -z);
                    closestTarget.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), 50.0f * ConfigConstructor.decaying_king_damage_modifier);
                }
                if (!this.m_9236_().f_46443_) {
                    ParticleHandler.particleSphere(this.m_9236_(), 1000, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), (ParticleOptions)ParticleTypes.f_123744_, 1.0f);
                    ParticleHandler.particleOutburstMap(this.m_9236_(), 200, this.m_20185_(), this.m_20186_() + (double)0.1f, this.m_20189_(), ParticleEvents.DAWNBREAKER_MAP, 1.0f);
                }
            }
            if (this.spawnTicks >= 125) {
                this.setAttackAnimation(AccursedLordAnimations.IDLE);
            }
        }
    }

    public void removePlacedLava() {
        for (BlockPos pos : this.lavaPos) {
            if (!this.m_9236_().m_8055_(pos).m_60713_(Blocks.f_49991_)) continue;
            this.m_9236_().m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
        this.lavaPos.clear();
    }

    public AccursedLordAnimations getAttackAnimation() {
        return AccursedLordAnimations.values()[(Integer)this.f_19804_.m_135370_(ATTACKS)];
    }

    @Override
    public void setDeath() {
        this.setAttackAnimation(AccursedLordAnimations.DEATH);
        this.removePlacedLava();
    }

    @Override
    public boolean m_21222_() {
        return ConfigConstructor.decaying_king_is_undead;
    }

    @Override
    public String getGroupId() {
        return ConfigConstructor.decaying_king_group_type;
    }

    @Override
    public String[] getBlacklistedStatusEffects() {
        return ConfigConstructor.decaying_king_status_effect_blacklist;
    }

    @Override
    public boolean m_213824_() {
        return ConfigConstructor.decaying_king_disables_shields;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::attackAnimations)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.DEMON_BOSS_IDLE_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SoundRegistry.DEMON_BOSS_HURT_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.DEMON_BOSS_DEATH_EVENT.get();
    }

    public static enum AccursedLordAnimations {
        SWORDSLAM,
        FIREBALLS,
        PULL,
        HEATWAVE,
        SPIN,
        WITHERBALLS,
        HAND_SLAM,
        SPAWN,
        DEATH,
        IDLE;

    }
}

