/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.client.registry;

import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.IConfigDisable;
import net.soulsweaponry.networking.ModMessages;
import net.soulsweaponry.networking.packets.C2S.CollectSummonsC2S;
import net.soulsweaponry.networking.packets.C2S.GiveResistanceC2S;
import net.soulsweaponry.networking.packets.C2S.KeybindAbilityC2S;
import net.soulsweaponry.networking.packets.C2S.KillNearbyEntitiesC2S;
import net.soulsweaponry.networking.packets.C2S.MoonlightC2S;
import net.soulsweaponry.networking.packets.C2S.ParryC2S;
import net.soulsweaponry.networking.packets.C2S.ReturnFreyrSwordC2S;
import net.soulsweaponry.networking.packets.C2S.ReturnThrownWeaponC2S;
import net.soulsweaponry.networking.packets.C2S.StationaryFreyrSwordC2S;
import net.soulsweaponry.networking.packets.C2S.SwitchTrickWeaponC2S;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.IKeybindAbility;
import net.soulsweaponry.util.WeaponUtil;

public class KeyBindRegistry {
    public static KeyMapping returnFreyrSword;
    public static KeyMapping stationaryFreyrSword;
    public static KeyMapping collectSummons;
    public static KeyMapping switchWeapon;
    public static KeyMapping keybindAbility;
    public static KeyMapping parry;
    public static KeyMapping effectShootMoonlight;
    public static KeyMapping returnThrownWeapon;
    public static KeyMapping showItemTooltip;
    public static KeyMapping showItemLore;
    public static KeyMapping killNearbyEntities;
    public static KeyMapping giveResistance;

    public static void register(RegisterKeyMappingsEvent event) {
        returnFreyrSword = KeyBindRegistry.registerKeyboard("return_freyr_sword", 90);
        stationaryFreyrSword = KeyBindRegistry.registerKeyboard("freyr_sword_stationary", 346);
        collectSummons = KeyBindRegistry.registerKeyboard("collect_summons_soul_reaper", 86);
        switchWeapon = KeyBindRegistry.registerKeyboard("switch_weapon", 66);
        keybindAbility = KeyBindRegistry.registerKeyboard("keybind_ability", 342);
        parry = KeyBindRegistry.registerKeyboard("parry", 82);
        effectShootMoonlight = KeyBindRegistry.registerKeyboard("effect_shoot_moonlight", 72);
        returnThrownWeapon = KeyBindRegistry.registerKeyboard("return_thrown_weapon", 78);
        showItemTooltip = KeyBindRegistry.registerKeyboard("show_tooltip", -1);
        showItemLore = KeyBindRegistry.registerKeyboard("show_lore", -1);
        event.register(returnFreyrSword);
        event.register(stationaryFreyrSword);
        event.register(collectSummons);
        event.register(switchWeapon);
        event.register(keybindAbility);
        event.register(parry);
        event.register(effectShootMoonlight);
        event.register(returnThrownWeapon);
        event.register(showItemTooltip);
        event.register(showItemLore);
        if (!FMLLoader.isProduction()) {
            killNearbyEntities = KeyBindRegistry.registerKeyboard("kill_nearby_entities", 75);
            giveResistance = KeyBindRegistry.registerKeyboard("give_or_clear_resistance", 74);
            event.register(killNearbyEntities);
            event.register(giveResistance);
        }
    }

    public static void registerKeyInputs() {
        Minecraft client = Minecraft.m_91087_();
        if (client == null) {
            return;
        }
        while (returnFreyrSword.m_90859_()) {
            ModMessages.sendToServer(new ReturnFreyrSwordC2S());
        }
        while (stationaryFreyrSword.m_90859_()) {
            ModMessages.sendToServer(new StationaryFreyrSwordC2S());
        }
        while (collectSummons.m_90859_()) {
            ModMessages.sendToServer(new CollectSummonsC2S());
        }
        while (switchWeapon.m_90859_()) {
            ModMessages.sendToServer(new SwitchTrickWeaponC2S());
        }
        while (keybindAbility.m_90859_()) {
            ModMessages.sendToServer(new KeybindAbilityC2S());
            if (client.f_91074_ == null) continue;
            LocalPlayer player = client.f_91074_;
            for (InteractionHand hand : InteractionHand.values()) {
                IConfigDisable configDisable;
                ItemStack stack = player.m_21120_(hand);
                Item item = stack.m_41720_();
                if (!(item instanceof IKeybindAbility)) continue;
                IKeybindAbility abilityItem = (IKeybindAbility)item;
                Item item2 = stack.m_41720_();
                if (item2 instanceof IConfigDisable && (configDisable = (IConfigDisable)item2).isDisabled(stack)) {
                    configDisable.notifyDisabled((LivingEntity)player);
                    continue;
                }
                abilityItem.useKeybindAbilityClient(client.f_91073_, player.m_21120_(hand), (Player)player);
            }
            for (ItemStack armorStack : player.m_6168_()) {
                IConfigDisable configDisable;
                InteractionHand hand;
                hand = armorStack.m_41720_();
                if (!(hand instanceof IKeybindAbility)) continue;
                IKeybindAbility abilityItem = (IKeybindAbility)hand;
                Item item = armorStack.m_41720_();
                if (item instanceof IConfigDisable && (configDisable = (IConfigDisable)item).isDisabled(armorStack)) {
                    configDisable.notifyDisabled((LivingEntity)player);
                    continue;
                }
                abilityItem.useKeybindAbilityClient(client.f_91073_, armorStack, (Player)player);
            }
        }
        while (parry.m_90859_()) {
            try {
                ModMessages.sendToServer(new ParryC2S());
            }
            catch (Exception player) {}
        }
        boolean effect = effectShootMoonlight.m_90857_();
        boolean melee = client.f_91066_.f_92096_.m_90857_() && client.f_91067_.m_91600_();
        boolean controller = false;
        if (WeaponUtil.isModLoaded("controllable")) {
            controller = ButtonBindings.ATTACK.isButtonPressed();
        }
        if ((effect || melee || controller) && client.f_91074_ != null) {
            boolean accept = false;
            if (effect && client.f_91074_.m_21023_((MobEffect)EffectRegistry.MOON_HERALD.get()) && !client.f_91074_.m_36335_().m_41519_((Item)ItemRegistry.MOONSTONE_RING.get())) {
                accept = true;
                client.f_91074_.m_36335_().m_41524_((Item)ItemRegistry.MOONSTONE_RING.get(), (int)ConfigConstructor.moonstone_ring_projectile_cooldown);
            } else if (melee || controller) {
                for (InteractionHand hand : InteractionHand.values()) {
                    boolean bluemoon;
                    ItemStack stack = client.f_91074_.m_21120_(hand);
                    boolean moonlight = stack.m_150930_((Item)WeaponRegistry.MOONLIGHT_SHORTSWORD.get()) && !ConfigConstructor.disable_use_moonlight_shortsword;
                    boolean bl = bluemoon = stack.m_150930_((Item)WeaponRegistry.BLUEMOON_SHORTSWORD.get()) && !ConfigConstructor.disable_use_bluemoon_shortsword;
                    if (!moonlight && !bluemoon) continue;
                    accept = true;
                }
            }
            if (accept) {
                ModMessages.sendToServer(new MoonlightC2S());
            }
        }
        while (returnThrownWeapon.m_90859_()) {
            ModMessages.sendToServer(new ReturnThrownWeaponC2S());
        }
        if (!FMLLoader.isProduction()) {
            while (killNearbyEntities.m_90859_()) {
                ModMessages.sendToServer(new KillNearbyEntitiesC2S());
            }
            while (giveResistance.m_90859_()) {
                ModMessages.sendToServer(new GiveResistanceC2S());
            }
        }
    }

    private static KeyMapping registerKeyboard(String name, int keycode) {
        return new KeyMapping("key.soulsweapons." + name, keycode, "category.soulsweapons.main");
    }
}

