/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.BossHealthOverlay;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.soulsweaponry.client.entitydata.ClientTargetPostureData;
import net.soulsweaponry.config.ClientConfig;
import net.soulsweaponry.mixin.BossBarHudAccessor;

public class TargetPostureHudOverlay {
    private static final ResourceLocation TEXTURE = new ResourceLocation("soulsweapons", "textures/gui/posture_bars_target.png");
    public static final TargetPostureHudOverlay INSTANCE = new TargetPostureHudOverlay();
    public static final IGuiOverlay HUD_TARGET_POSTURE = (gui, drawContext, partialTicks, width, height) -> INSTANCE.render(drawContext, partialTicks, width, height);

    public void render(GuiGraphics drawContext, float tickDelta, int width, int height) {
        Minecraft client = Minecraft.m_91087_();
        if (client == null || ClientConfig.disable_target_posture_hud) {
            return;
        }
        int barX = width / 2 - 91;
        if (client.f_91074_ == null || client.f_91074_.m_21224_()) {
            return;
        }
        int posture = ClientTargetPostureData.getTargetPosture();
        if (posture <= 0) {
            return;
        }
        float posturePerPixel = (float)ClientTargetPostureData.getMaxPosture() / 182.0f;
        int pixelOffset = Mth.m_14143_((float)((float)posture / posturePerPixel));
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BossHealthOverlay bossHud = client.f_91065_.m_93090_();
        Map<UUID, LerpingBossEvent> bars = ((BossBarHudAccessor)bossHud).getBossBars();
        String name = ClientTargetPostureData.getName();
        int initialBarY = 12;
        int SLOT_HEIGHT = 19;
        int maxY = height / 3;
        int available = maxY - initialBarY;
        int slotCount = Math.min(bars.size(), (available + 19) / 19);
        int barY = initialBarY + slotCount * 19;
        Font font = client.f_91062_;
        int nameWidth = font.m_92895_(name);
        int textX = barX + (182 - nameWidth) / 2;
        int textY = barY - 9;
        drawContext.m_280488_(font, name, textX, textY, 0xFFFFFF);
        drawContext.m_280163_(TEXTURE, barX - 25, barY - 10, 0.0f, 0.0f, 25, 25, 207, 25);
        drawContext.m_280163_(TEXTURE, barX, barY, 25.0f, 10.0f, 182, 5, 207, 25);
        drawContext.m_280163_(TEXTURE, barX, barY, 25.0f, 15.0f, pixelOffset, 5, 207, 25);
    }
}

