/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.dimension.portal;

import com.google.common.collect.ImmutableList;
import com.legacy.structure_gel.api.block.GelPortalBlock;
import com.legacy.structure_gel.api.dimension.portal.GelTeleporter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GelPortalLogic {
    public final Block frame;
    public final GelPortalBlock portal;
    public final LevelAccessor level;
    public final Direction.Axis axis;
    public final Direction rightDir;
    public final Direction leftDir;
    public int portalBlockCount;
    @Nullable
    public BlockPos bottomLeft;
    public int height;
    public int width;
    public List<Block> allowedInsideBlocks = new ArrayList<Block>();

    private GelPortalLogic(LevelAccessor level, BlockPos pos, Direction.Axis axis, Block frame, GelPortalBlock portal, List<Block> allowedInsideBlocks) {
        this.level = level;
        this.axis = axis;
        this.frame = frame;
        this.portal = portal;
        this.allowedInsideBlocks = allowedInsideBlocks;
        if (axis == Direction.Axis.X) {
            this.leftDir = Direction.EAST;
            this.rightDir = Direction.WEST;
        } else {
            this.leftDir = Direction.NORTH;
            this.rightDir = Direction.SOUTH;
        }
        BlockPos blockpos = pos;
        while (pos.m_123342_() > blockpos.m_123342_() - 21 && pos.m_123342_() > 0 && this.isValidInsideMaterial(level.m_8055_(pos.m_7495_()))) {
            pos = pos.m_7495_();
        }
        int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
        if (i >= 0) {
            this.bottomLeft = pos.m_5484_(this.leftDir, i);
            this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
            if (this.width < 2 || this.width > 21) {
                this.bottomLeft = null;
                this.width = 0;
            }
        }
        if (this.bottomLeft != null) {
            this.height = this.calculatePortalHeight();
        }
    }

    public static boolean fillPortal(Level level, BlockPos pos, GelPortalBlock portal, List<Block> allowedInsideBlocks) {
        GelTeleporter teleporter = portal.getTeleporter(null);
        if (level.m_46472_() == teleporter.getDimension1().get() || level.m_46472_() == teleporter.getDimension2().get()) {
            return GelPortalLogic.trySpawnPortal(level, pos, portal, allowedInsideBlocks);
        }
        return false;
    }

    public static boolean trySpawnPortal(Level level, BlockPos pos, GelPortalBlock portalBlock, List<Block> allowedInsideBlocks) {
        GelPortalLogic portal = GelPortalLogic.getPortalFrame(level, pos, portalBlock, allowedInsideBlocks);
        if (portal != null && portal.portalBlockCount == 0) {
            portal.placePortalBlocks();
            return true;
        }
        return false;
    }

    @Nullable
    public static GelPortalLogic getPortalFrame(Level level, BlockPos pos, GelPortalBlock portalBlock, List<Block> allowedInsideBlocks) {
        GelPortalLogic portal = GelPortalLogic.getPortalFrame(level, pos, portalBlock, allowedInsideBlocks, Direction.Axis.X);
        if (portal == null) {
            portal = GelPortalLogic.getPortalFrame(level, pos, portalBlock, allowedInsideBlocks, Direction.Axis.Z);
        }
        return portal;
    }

    @Nullable
    private static GelPortalLogic getPortalFrame(Level level, BlockPos pos, GelPortalBlock portalBlock, List<Block> allowedInsideBlocks, Direction.Axis axis) {
        GelPortalLogic portal = new GelPortalLogic((LevelAccessor)level, pos, axis, portalBlock.getFrameBlock().get().m_60734_(), portalBlock, allowedInsideBlocks);
        return portal.isValidSize() ? portal : null;
    }

    public static boolean isPortalComplete(LevelAccessor level, BlockPos pos, Direction.Axis axis, Block frame, GelPortalBlock portal) {
        GelPortalLogic portalSize = new GelPortalLogic(level, pos, axis, frame, portal, (List<Block>)ImmutableList.of());
        return portalSize.isValidSize() && portalSize.hasAllPortalBlocks();
    }

    private boolean isValidSize() {
        return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    private boolean hasAllPortalBlocks() {
        return this.portalBlockCount >= this.width * this.height;
    }

    private int getDistanceUntilEdge(BlockPos pos, Direction direction) {
        BlockPos blockpos;
        int i;
        for (i = 0; i < 22 && this.isValidInsideMaterial(this.level.m_8055_(blockpos = pos.m_5484_(direction, i))) && this.level.m_8055_(blockpos.m_7495_()).m_60734_() == this.frame; ++i) {
        }
        Block block = this.level.m_8055_(pos.m_5484_(direction, i)).m_60734_();
        return block == this.frame ? i : 0;
    }

    private int calculatePortalHeight() {
        this.height = 0;
        block0: while (this.height < 21) {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.m_5484_(this.rightDir, i).m_6630_(this.height);
                BlockState blockstate = this.level.m_8055_(blockpos);
                if (!this.isValidInsideMaterial(blockstate)) break block0;
                Block block = blockstate.m_60734_();
                if (block == this.portal) {
                    ++this.portalBlockCount;
                }
                if (i == 0 ? (block = this.level.m_8055_(blockpos.m_121945_(this.leftDir)).m_60734_()) != this.frame : i == this.width - 1 && (block = this.level.m_8055_(blockpos.m_121945_(this.rightDir)).m_60734_()) != this.frame) break block0;
            }
            ++this.height;
        }
        for (int j = 0; j < this.width; ++j) {
            if (this.level.m_8055_(this.bottomLeft.m_5484_(this.rightDir, j).m_6630_(this.height)).m_60734_() == this.frame) continue;
            this.height = 0;
            break;
        }
        if (this.height <= 21 && this.height >= 3) {
            return this.height;
        }
        this.bottomLeft = null;
        this.width = 0;
        this.height = 0;
        return 0;
    }

    private boolean isValidInsideMaterial(BlockState state) {
        Block block = state.m_60734_();
        return state.m_60795_() || block == this.portal || this.allowedInsideBlocks.contains(block);
    }

    private void placePortalBlocks() {
        for (int i = 0; i < this.width; ++i) {
            BlockPos blockpos = this.bottomLeft.m_5484_(this.rightDir, i);
            for (int j = 0; j < this.height; ++j) {
                this.level.m_7731_(blockpos.m_6630_(j), (BlockState)this.portal.m_49966_().m_61124_((Property)NetherPortalBlock.f_54904_, (Comparable)this.axis), 18);
            }
        }
    }
}

