/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.compat.sereneseasons;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModTags;
import sereneseasons.season.SeasonHooks;
import snownee.snow.SnowCommonConfig;

public class SereneSeasonsCompat {
    public static boolean shouldMelt(Level level, BlockPos pos, Holder<Biome> biome) {
        if (!SereneSeasonsCompat.snowAndIceMeltInWarmBiomes((ResourceKey<Level>)level.m_46472_(), biome)) {
            return false;
        }
        Season.SubSeason subSeason = SeasonHelper.getSeasonState((Level)level).getSubSeason();
        SeasonsConfig.SeasonProperties meltInfo = ModConfig.seasons.getSeasonProperties(subSeason);
        if (meltInfo == null) {
            return false;
        }
        return meltInfo.meltChance() > 0.0f && meltInfo.meltRolls() > 0 && !SereneSeasonsCompat.coldEnoughToSnow(level, pos, biome);
    }

    public static boolean snowAndIceMeltInWarmBiomes(ResourceKey<Level> dimension, Holder<Biome> biome) {
        if (!ModConfig.seasons.generateSnowAndIce) {
            return false;
        }
        if (biome.m_203656_(ModTags.Biomes.BLACKLISTED_BIOMES)) {
            return false;
        }
        return ModConfig.seasons.isDimensionWhitelisted(dimension);
    }

    public static boolean coldEnoughToSnow(Level level, BlockPos pos, Holder<Biome> biome) {
        if (ModConfig.seasons.generateSnowAndIce) {
            return SeasonHooks.getBiomeTemperature((Level)level, biome, (BlockPos)pos) < 0.15f;
        }
        return ((Biome)biome.m_203334_()).m_198904_(pos);
    }

    public static boolean isWinter(Level level, BlockPos pos, Holder<Biome> biome) {
        if (!SereneSeasonsCompat.isSeasonal((ResourceKey<Level>)level.m_46472_(), biome)) {
            return false;
        }
        return SeasonHelper.getSeasonState((Level)level).getSeason() == Season.WINTER;
    }

    public static boolean isSeasonal(ResourceKey<Level> dimension, Holder<Biome> biome) {
        return !biome.m_203656_(ModTags.Biomes.BLACKLISTED_BIOMES) && !biome.m_203656_(ModTags.Biomes.TROPICAL_BIOMES) && ModConfig.seasons.isDimensionWhitelisted(dimension);
    }

    public static void weatherTick(ServerLevel level, Runnable action) {
        if (!ModConfig.seasons.isDimensionWhitelisted(level.m_46472_())) {
            return;
        }
        Season.SubSeason subSeason = SeasonHelper.getSeasonState((Level)level).getSubSeason();
        if (subSeason.getSeason() == Season.WINTER) {
            if (level.f_46441_.m_188503_(SnowCommonConfig.weatherTickSlowness) == 0) {
                action.run();
            }
            return;
        }
        SeasonsConfig.SeasonProperties meltInfo = ModConfig.seasons.getSeasonProperties(subSeason);
        if (meltInfo == null) {
            action.run();
            return;
        }
        int meltRolls = meltInfo.meltRolls();
        if (meltRolls == 0) {
            return;
        }
        float meltChance = meltInfo.meltChance() * 0.01f;
        if (meltChance == 0.0f) {
            return;
        }
        for (int i = 0; i < meltRolls; ++i) {
            if (!(level.f_46441_.m_188501_() < meltChance)) continue;
            action.run();
        }
    }
}

