/*
 * Decompiled with CFR 0.152.
 */
package filthycoin.theorcs.common.entities.state_machines.states;

import filthycoin.theorcs.common.entities.state_machines.BaseState;
import filthycoin.theorcs.common.entities.state_machines.StateMachine;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MonsterWanderingState
extends BaseState {
    private int ticks = 0;
    private boolean has_territory = false;

    public MonsterWanderingState(boolean has_territory) {
        this.has_territory = has_territory;
    }

    @Override
    public void Start(StateMachine machine) {
        this.ticks = 0;
    }

    @Override
    public void Update(StateMachine machine) {
        Player player;
        Level level = machine.entity.m_9236_();
        if (machine.GetParameter("aggro_timer").get().floatValue() > 0.0f) {
            machine.SetParameter("aggro_timer", machine.GetParameter("aggro_timer").get().floatValue() - 1.0f);
        }
        if ((player = level.m_45946_(TargetingConditions.f_26872_, (LivingEntity)machine.entity)) != null && machine.entity.IsWithinAttackRadius((LivingEntity)player) && machine.entity.m_21040_((LivingEntity)player, TargetingConditions.f_26872_)) {
            machine.SetParameter("angry", 1.0f);
            machine.entity.m_6710_((LivingEntity)player);
        }
        if (!machine.entity.m_21573_().m_26572_() || machine.entity.m_21573_().m_26577_()) {
            ++this.ticks;
            if (this.ticks > 20 + machine.entity.m_217043_().m_188503_(machine.entity.wander_wait_time_range)) {
                float territory_size = machine.entity.wandering_distance;
                Vec3 startPos = machine.entity.startPosition;
                if (!this.has_territory) {
                    startPos = machine.entity.m_20182_();
                }
                RandomSource rand = machine.entity.m_217043_();
                Vec3 movePos = new Vec3(startPos.f_82479_ + (double)((rand.m_188501_() * 2.0f - 1.0f) * territory_size), startPos.f_82480_, startPos.f_82481_ + (double)((rand.m_188501_() * 2.0f - 1.0f) * territory_size));
                machine.entity.m_21573_().m_26519_(movePos.f_82479_, movePos.f_82480_, movePos.f_82481_, 0.5);
                machine.entity.SetAnimation("walk");
            } else {
                machine.entity.SetAnimation("idle");
            }
        } else {
            this.ticks = 0;
        }
    }

    @Override
    public void End(StateMachine machine) {
        machine.entity.m_21573_().m_26573_();
    }
}

