/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.core;

import com.electronwill.nightconfig.core.CommentedConfig;
import fuzs.forgeconfigscreens.ForgeConfigScreens;
import fuzs.forgeconfigscreens.core.NetworkingHelper;
import fuzs.forgeconfigscreens.core.ServiceProviderHelper;
import fuzs.forgeconfigscreens.core.WritableMessage;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public interface CommonAbstractions {
    public static final CommonAbstractions INSTANCE = ServiceProviderHelper.load(CommonAbstractions.class);

    public Optional<String> getModDisplayName(String var1);

    public boolean isDevelopmentEnvironment();

    public boolean isClientEnvironment();

    public Path getDefaultConfigPath();

    public void fireReloadingEvent(ModConfig var1);

    default public void setConfigData(ModConfig modConfig, CommentedConfig data) {
        try {
            Method setConfigData = ModConfig.class.getDeclaredMethod("setConfigData", CommentedConfig.class);
            setConfigData.setAccessible(true);
            MethodHandles.lookup().unreflect(setConfigData).invoke(modConfig, data);
        }
        catch (Throwable e) {
            ForgeConfigScreens.LOGGER.error("Unable to set config data for {}", (Object)modConfig.getFileName(), (Object)e);
        }
    }

    public <T extends WritableMessage> void registerClientboundMessage(Class<T> var1, Supplier<NetworkingHelper.ClientMessageListener<T>> var2);

    public <T extends WritableMessage> void registerServerboundMessage(Class<T> var1, Supplier<NetworkingHelper.ServerMessageListener<T>> var2);

    public static <T extends WritableMessage> Function<FriendlyByteBuf, T> findMessageConstructor(Class<T> clazz) {
        try {
            return CommonAbstractions.findMessageConstructor(clazz, MethodType.methodType(Void.TYPE, FriendlyByteBuf.class));
        }
        catch (Throwable e) {
            try {
                return CommonAbstractions.findMessageConstructor(clazz, MethodType.methodType(Void.TYPE));
            }
            catch (Throwable ignored) {
                throw new RuntimeException(e);
            }
        }
    }

    private static <T extends WritableMessage> Function<FriendlyByteBuf, T> findMessageConstructor(Class<T> clazz, MethodType methodType) throws ReflectiveOperationException {
        MethodHandle constructor = MethodHandles.publicLookup().findConstructor(clazz, methodType);
        return friendlyByteBuf -> {
            try {
                return constructor.invoke((FriendlyByteBuf)friendlyByteBuf);
            }
            catch (Throwable e) {
                try {
                    return constructor.invoke();
                }
                catch (Throwable ignored) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public Packet<?> toClientboundPacket(WritableMessage var1);

    public Packet<?> toServerboundPacket(WritableMessage var1);

    public void registerConfig(String var1, ModConfig.Type var2, IConfigSpec<?> var3);

    public void registerConfig(String var1, ModConfig.Type var2, IConfigSpec<?> var3, String var4);
}

