/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.client.helper;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.utils.UnmodifiableConfigWrapper;
import com.electronwill.nightconfig.toml.TomlFormat;
import fuzs.forgeconfigscreens.core.CommonAbstractions;
import fuzs.forgeconfigscreens.core.NetworkingHelper;
import fuzs.forgeconfigscreens.network.client.C2SSendConfigMessage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ServerConfigUploader {
    private static final MethodHandle UNMODIFIABLE_CONFIG_WRAPPER_CONFIG_GETTER;

    public static void saveAndUpload(ModConfig config) {
        Minecraft minecraft;
        ClientPacketListener connection;
        ServerConfigUploader.findForgeConfigSpec(config.getSpec()).ifPresent(ForgeConfigSpec::save);
        CommonAbstractions.INSTANCE.fireReloadingEvent(config);
        if (config.getType() == ModConfig.Type.SERVER && (connection = (minecraft = Minecraft.m_91087_()).m_91403_()) != null && !minecraft.m_91090_()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            TomlFormat.instance().createWriter().write((UnmodifiableConfig)config.getConfigData(), (OutputStream)stream);
            NetworkingHelper.sendToServer(connection.m_104910_(), new C2SSendConfigMessage(config.getFileName(), stream.toByteArray()));
        }
    }

    public static Optional<ForgeConfigSpec> findForgeConfigSpec(Object o) {
        Optional<ForgeConfigSpec> optional;
        while (!(o instanceof ForgeConfigSpec) && o instanceof UnmodifiableConfigWrapper) {
            try {
                o = UNMODIFIABLE_CONFIG_WRAPPER_CONFIG_GETTER.invoke(o);
            }
            catch (Throwable throwable) {}
        }
        if (o instanceof ForgeConfigSpec) {
            ForgeConfigSpec spec = (ForgeConfigSpec)o;
            optional = Optional.of(spec);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    static {
        try {
            Field field = UnmodifiableConfigWrapper.class.getDeclaredField("config");
            field.setAccessible(true);
            UNMODIFIABLE_CONFIG_WRAPPER_CONFIG_GETTER = MethodHandles.lookup().unreflectGetter(field);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

