/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.client.gui.components;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.forgeconfigscreens.ForgeConfigScreens;
import fuzs.forgeconfigscreens.client.gui.data.IEntryData;
import fuzs.forgeconfigscreens.client.gui.screens.ConfigScreen;
import fuzs.forgeconfigscreens.client.gui.screens.SelectConfigWorldScreen;
import fuzs.forgeconfigscreens.core.CommonAbstractions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ConfigWorldSelectionList
extends ObjectSelectionList<ConfigWorldListEntry> {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat();
    private static final ResourceLocation ICON_MISSING = new ResourceLocation("textures/misc/unknown_server.png");
    private static final ResourceLocation ICON_OVERLAY_LOCATION = new ResourceLocation("textures/gui/world_selection.png");
    private static final Component FROM_NEWER_TOOLTIP_1 = Component.m_237115_((String)"selectWorld.tooltip.fromNewerVersion1").m_130940_(ChatFormatting.RED);
    private static final Component FROM_NEWER_TOOLTIP_2 = Component.m_237115_((String)"selectWorld.tooltip.fromNewerVersion2").m_130940_(ChatFormatting.RED);
    private static final Component SNAPSHOT_TOOLTIP_1 = Component.m_237115_((String)"selectWorld.tooltip.snapshot1").m_130940_(ChatFormatting.GOLD);
    private static final Component SNAPSHOT_TOOLTIP_2 = Component.m_237115_((String)"selectWorld.tooltip.snapshot2").m_130940_(ChatFormatting.GOLD);
    private static final Component WORLD_LOCKED_TOOLTIP = Component.m_237115_((String)"selectWorld.locked").m_130940_(ChatFormatting.RED);
    private static final Component WORLD_REQUIRES_CONVERSION = Component.m_237115_((String)"selectWorld.conversion.tooltip").m_130940_(ChatFormatting.RED);
    private static final String SERVER_CONFIG_NAME = "serverconfig";
    private static final Marker CONFIG = MarkerFactory.getMarker((String)"CONFIG");
    private final SelectConfigWorldScreen screen;
    private final List<LevelSummary> levelList;
    private final Component createConfigTooltip;

    public ConfigWorldSelectionList(SelectConfigWorldScreen selectConfigWorldScreen, Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight, String query, List<LevelSummary> levelList) {
        super(minecraft, width, height, y0, y1, itemHeight);
        this.screen = selectConfigWorldScreen;
        this.levelList = levelList;
        this.createConfigTooltip = Component.m_237110_((String)"configmenusforge.gui.select.create_config", (Object[])new Object[]{selectConfigWorldScreen.getDisplayName()}).m_130940_(ChatFormatting.GOLD);
        this.refreshList(query);
    }

    public void refreshList(String query) {
        this.m_93516_();
        String s = query.toLowerCase(Locale.ROOT);
        for (LevelSummary levelsummary : this.levelList) {
            if (!levelsummary.m_78361_().toLowerCase(Locale.ROOT).contains(s) && !levelsummary.m_78358_().toLowerCase(Locale.ROOT).contains(s)) continue;
            this.m_7085_((AbstractSelectionList.Entry)new ConfigWorldListEntry(this.screen, this.f_93386_, levelsummary));
        }
    }

    protected int m_5756_() {
        return this.f_93388_ / 2 + 144;
    }

    public int m_5759_() {
        return 260;
    }

    public boolean m_93696_() {
        return this.screen.m_7222_() == this;
    }

    public void setSelected(@Nullable ConfigWorldListEntry configWorldListEntry) {
        super.m_6987_((AbstractSelectionList.Entry)configWorldListEntry);
        this.screen.updateButtonStatus(configWorldListEntry != null && !configWorldListEntry.summary.m_164916_());
    }

    public final class ConfigWorldListEntry
    extends ObjectSelectionList.Entry<ConfigWorldListEntry>
    implements AutoCloseable {
        final LevelSummary summary;
        private final SelectConfigWorldScreen screen;
        private final Minecraft minecraft;
        private final ResourceLocation iconLocation;
        @Nullable
        private final DynamicTexture icon;
        private File iconFile;
        private long lastClickTime;

        public ConfigWorldListEntry(SelectConfigWorldScreen selectConfigWorldScreen, Minecraft minecraft, LevelSummary levelSummary) {
            this.screen = selectConfigWorldScreen;
            this.summary = levelSummary;
            this.minecraft = minecraft;
            String s = levelSummary.m_78358_();
            this.iconLocation = new ResourceLocation("minecraft", "worlds/" + Util.m_137483_((String)s, ResourceLocation::m_135828_) + "/" + Hashing.sha1().hashUnencodedChars((CharSequence)s) + "/icon");
            this.iconFile = levelSummary.m_230875_().toFile();
            if (!this.iconFile.isFile()) {
                this.iconFile = null;
            }
            this.icon = this.loadServerIcon();
        }

        private static void loadModConfig(ModConfig config, Path configBasePath) {
            ForgeConfigScreens.LOGGER.trace(CONFIG, "Loading config file type {} at {} for {}", new Object[]{config.getType(), config.getFileName(), config.getModId()});
            try {
                Files.createDirectories(configBasePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            CommentedFileConfig configData = (CommentedFileConfig)config.getHandler().reader(configBasePath).apply(config);
            CommonAbstractions.INSTANCE.setConfigData(config, (CommentedConfig)configData);
            config.save();
        }

        public Component m_142172_() {
            MutableComponent translatablecomponent = Component.m_237110_((String)"narrator.select.world", (Object[])new Object[]{this.summary.m_78361_(), new Date(this.summary.m_78366_()), this.summary.m_78368_() ? Component.m_237115_((String)"gameMode.hardcore") : Component.m_237115_((String)("gameMode." + this.summary.m_78367_().m_46405_())), this.summary.m_78369_() ? Component.m_237115_((String)"selectWorld.cheats") : Component.m_237119_(), this.summary.m_78370_()});
            MutableComponent component = this.summary.m_78375_() ? CommonComponents.m_267603_((Component[])new Component[]{translatablecomponent, WORLD_LOCKED_TOOLTIP}) : translatablecomponent;
            return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{component});
        }

        public void m_6311_(GuiGraphics guiGraphics, int pIndex, int top, int left, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean hovered, float pPartialTicks) {
            Object s = this.summary.m_78361_();
            String s1 = this.summary.m_78358_() + " (" + DATE_FORMAT.format(new Date(this.summary.m_78366_())) + ")";
            if (StringUtils.isEmpty((CharSequence)s)) {
                s = I18n.m_118938_((String)"selectWorld.world", (Object[])new Object[0]) + " " + (pIndex + 1);
            }
            Component component = this.summary.m_78376_();
            guiGraphics.m_280488_(this.minecraft.f_91062_, (String)s, left + 32 + 3, top + 1, 0xFFFFFF);
            guiGraphics.m_280488_(this.minecraft.f_91062_, s1, left + 32 + 3, top + 9 + 3, 0x808080);
            guiGraphics.m_280430_(this.minecraft.f_91062_, component, left + 32 + 3, top + 9 + 9 + 3, 0x808080);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            guiGraphics.m_280163_(this.icon != null ? this.iconLocation : ICON_MISSING, left, top, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
            if (((Boolean)this.minecraft.f_91066_.m_231828_().m_231551_()).booleanValue() || hovered) {
                int textureY;
                guiGraphics.m_280509_(left, top, left + 32, top + 32, -1601138544);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean leftHovered = pMouseX - left < 32;
                int n = textureY = leftHovered ? 32 : 0;
                if (this.summary.m_78375_()) {
                    guiGraphics.m_280163_(ICON_OVERLAY_LOCATION, left, top, 96.0f, (float)textureY, 32, 32, 256, 256);
                    if (leftHovered) {
                        this.screen.setActiveTooltip(this.minecraft.f_91062_.m_92923_((FormattedText)WORLD_LOCKED_TOOLTIP, 175));
                    }
                } else if (this.summary.m_193020_()) {
                    guiGraphics.m_280163_(ICON_OVERLAY_LOCATION, left, top, 96.0f, 32.0f, 32, 32, 256, 256);
                    if (leftHovered) {
                        this.screen.setActiveTooltip(this.minecraft.f_91062_.m_92923_((FormattedText)WORLD_REQUIRES_CONVERSION, 175));
                    }
                } else if (this.summary.m_78372_()) {
                    guiGraphics.m_280163_(ICON_OVERLAY_LOCATION, left, top, 32.0f, (float)textureY, 32, 32, 256, 256);
                    if (this.summary.m_78373_()) {
                        guiGraphics.m_280163_(ICON_OVERLAY_LOCATION, left, top, 96.0f, (float)textureY, 32, 32, 256, 256);
                        if (leftHovered) {
                            this.screen.setActiveTooltip((List<FormattedCharSequence>)ImmutableList.of((Object)FROM_NEWER_TOOLTIP_1.m_7532_(), (Object)FROM_NEWER_TOOLTIP_2.m_7532_()));
                        }
                    } else if (!SharedConstants.m_183709_().m_132498_()) {
                        guiGraphics.m_280163_(ICON_OVERLAY_LOCATION, left, top, 64.0f, (float)textureY, 32, 32, 256, 256);
                        if (leftHovered) {
                            this.screen.setActiveTooltip((List<FormattedCharSequence>)ImmutableList.of((Object)SNAPSHOT_TOOLTIP_1.m_7532_(), (Object)SNAPSHOT_TOOLTIP_2.m_7532_()));
                        }
                    }
                } else if (!this.fileExists()) {
                    guiGraphics.m_280163_(ICON_OVERLAY_LOCATION, left, top, 32.0f, (float)textureY, 32, 32, 256, 256);
                    guiGraphics.m_280163_(ICON_OVERLAY_LOCATION, left, top, 64.0f, (float)textureY, 32, 32, 256, 256);
                    if (leftHovered) {
                        this.screen.setActiveTooltip(this.minecraft.f_91062_.m_92923_((FormattedText)ConfigWorldSelectionList.this.createConfigTooltip, 200));
                    }
                } else {
                    guiGraphics.m_280163_(ICON_OVERLAY_LOCATION, left, top, 0.0f, (float)textureY, 32, 32, 256, 256);
                }
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.summary.m_164916_()) {
                return true;
            }
            ConfigWorldSelectionList.this.setSelected(this);
            this.screen.updateButtonStatus(ConfigWorldSelectionList.this.m_93511_() != null);
            if (mouseX - (double)ConfigWorldSelectionList.this.m_5747_() <= 32.0) {
                this.openConfig();
                return true;
            }
            if (Util.m_137550_() - this.lastClickTime < 250L) {
                this.openConfig();
                return true;
            }
            this.lastClickTime = Util.m_137550_();
            return false;
        }

        public void openConfig() {
            this.loadModConfig(this.screen.getConfig());
            ConfigScreen configScreen = ConfigScreen.create(this.screen, this.screen.getDisplayName(), this.screen.getConfig(), IEntryData.makeValueToDataMap(this.screen.getConfig()));
            this.minecraft.m_91152_((Screen)configScreen);
        }

        public void loadModConfig(ModConfig config) {
            ConfigWorldListEntry.loadModConfig(config, this.getConfigBasePath());
        }

        private Path getConfigBasePath() {
            return this.minecraft.m_91392_().m_78257_().resolve(this.summary.m_78358_()).resolve(ConfigWorldSelectionList.SERVER_CONFIG_NAME);
        }

        public boolean fileExists() {
            return Files.exists(this.getConfigBasePath().resolve(this.screen.getConfig().getFileName()), new LinkOption[0]);
        }

        @Nullable
        private DynamicTexture loadServerIcon() {
            boolean flag;
            boolean bl = flag = this.iconFile != null && this.iconFile.isFile();
            if (flag) {
                try {
                    DynamicTexture dynamictexture1;
                    try (FileInputStream inputstream = new FileInputStream(this.iconFile);){
                        NativeImage nativeimage = NativeImage.m_85058_((InputStream)inputstream);
                        Validate.validState((nativeimage.m_84982_() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                        Validate.validState((nativeimage.m_85084_() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                        DynamicTexture dynamictexture = new DynamicTexture(nativeimage);
                        this.minecraft.m_91097_().m_118495_(this.iconLocation, (AbstractTexture)dynamictexture);
                        dynamictexture1 = dynamictexture;
                    }
                    return dynamictexture1;
                }
                catch (Throwable throwable2) {
                    ForgeConfigScreens.LOGGER.error("Invalid icon for world {}", (Object)this.summary.m_78358_(), (Object)throwable2);
                    this.iconFile = null;
                    return null;
                }
            }
            this.minecraft.m_91097_().m_118513_(this.iconLocation);
            return null;
        }

        @Override
        public void close() {
            if (this.icon != null) {
                this.icon.close();
            }
        }
    }
}

