/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.item;

import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.List;
import java.util.UUID;
import net.bandit.darkdoppelganger.Config;
import net.bandit.darkdoppelganger.entity.DarkDoppelgangerEntity;
import net.bandit.darkdoppelganger.entity.EntityRegistry;
import net.bandit.darkdoppelganger.registry.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ShadowOrbItem
extends Item {
    private static final String TAG_THROWER = "ThrowerUUID";
    private static final String E_QUEUED = "DoppelSummonQueued";
    private static final String E_DELAY = "DoppelSummonDelay";
    private static final String E_ANCHOR_X = "DoppelAnchorX";
    private static final String E_ANCHOR_Y = "DoppelAnchorY";
    private static final String E_ANCHOR_Z = "DoppelAnchorZ";
    private static final String E_ANGLE = "DoppelAngle";
    private static final String E_THROWER = "DoppelThrowerUUID";
    private static final int SUMMON_DELAY_TICKS = 100;
    private static final double VOID_TRIGGER_Y = 30.0;
    private static final int NO_PICKUP_DELAY = 700;

    public ShadowOrbItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        if (!level.f_46443_) {
            ItemStack thrown = held.m_41777_();
            thrown.m_41764_(1);
            ShadowOrbItem.tagWithThrower(thrown, player);
            ItemEntity orb = new ItemEntity(level, player.m_20185_(), player.m_20188_() - 0.2, player.m_20189_(), thrown);
            orb.m_32010_(700);
            orb.m_32052_(player.m_20148_());
            Vec3 motion = player.m_20154_().m_82541_().m_82490_(0.85).m_82520_(0.0, 0.1, 0.0);
            orb.m_20256_(motion);
            level.m_7967_((Entity)orb);
            if (!player.m_150110_().f_35937_) {
                held.m_41774_(1);
            }
        }
        return InteractionResultHolder.m_19092_((Object)held, (boolean)level.f_46443_);
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        ShadowOrbItem.tagWithThrower(stack, player);
        super.m_7836_(stack, level, player);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        Level level = entity.m_9236_();
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        entity.m_32010_(700);
        ShadowOrbItem.ensureThrowerTagOnce(stack, serverLevel, entity);
        CompoundTag e = entity.getPersistentData();
        if (e.m_128471_(E_QUEUED)) {
            int delay;
            entity.m_32064_();
            entity.m_20242_(true);
            entity.m_20256_(Vec3.f_82478_);
            entity.m_32010_(700);
            Vec3 anchor = new Vec3(e.m_128459_(E_ANCHOR_X), e.m_128459_(E_ANCHOR_Y), e.m_128459_(E_ANCHOR_Z));
            float angle = e.m_128457_(E_ANGLE) + 0.35f;
            e.m_128350_(E_ANGLE, angle);
            double radius = 0.45;
            double ox = Math.cos(angle) * radius;
            double oz = Math.sin(angle) * radius;
            double bob = Math.sin((double)angle * 0.6) * 0.08;
            Vec3 pos = anchor.m_82520_(ox, bob, oz);
            entity.m_6021_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, pos.f_82479_, pos.f_82480_ + 0.1, pos.f_82481_, 2, 0.05, 0.02, 0.05, 0.0);
            if (entity.f_19797_ % 4 == 0) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, pos.f_82479_, pos.f_82480_ + 0.15, pos.f_82481_, 1, 0.02, 0.02, 0.02, 0.0);
            }
            if (entity.f_19797_ % 20 == 0) {
                serverLevel.m_5594_(null, BlockPos.m_274446_((Position)pos), SoundEvents.f_144243_, SoundSource.AMBIENT, 0.4f, 0.8f);
            }
            if ((delay = e.m_128451_(E_DELAY)) > 0) {
                e.m_128405_(E_DELAY, delay - 1);
                return false;
            }
            Player thrower = ShadowOrbItem.getThrower(serverLevel, stack, entity);
            if (thrower != null && thrower.m_6084_()) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                serverLevel.m_5594_(null, BlockPos.m_274446_((Position)pos), SoundEvents.f_11850_, SoundSource.HOSTILE, 0.7f, 0.7f);
                ShadowOrbItem.summonDoppelganger(serverLevel, thrower);
            }
            entity.m_146870_();
            return false;
        }
        if (serverLevel.m_46472_() == Level.f_46430_ && entity.m_20186_() < 30.0) {
            Player thrower;
            UUID throwerId = ShadowOrbItem.getThrowerIdFromStack(stack);
            if (throwerId != null) {
                e.m_128362_(E_THROWER, throwerId);
            }
            Player player = thrower = throwerId != null ? serverLevel.m_46003_(throwerId) : null;
            if (thrower != null) {
                serverLevel.m_5594_(null, thrower.m_20183_(), (SoundEvent)ModSounds.BOSS_LAUGH.get(), SoundSource.HOSTILE, 2.0f, 0.8f);
            }
            Vec3 anchor = thrower != null ? ShadowOrbItem.getHoverAnchor(serverLevel, thrower) : new Vec3(entity.m_20185_(), 40.0, entity.m_20189_());
            e.m_128379_(E_QUEUED, true);
            e.m_128405_(E_DELAY, 100);
            e.m_128347_(E_ANCHOR_X, anchor.f_82479_);
            e.m_128347_(E_ANCHOR_Y, anchor.f_82480_);
            e.m_128347_(E_ANCHOR_Z, anchor.f_82481_);
            e.m_128350_(E_ANGLE, serverLevel.f_46441_.m_188501_() * ((float)Math.PI * 2));
            entity.m_20242_(true);
            entity.m_20256_(Vec3.f_82478_);
            entity.m_6021_(anchor.f_82479_, anchor.f_82480_, anchor.f_82481_);
            entity.m_32064_();
            entity.m_32010_(700);
            return false;
        }
        return false;
    }

    public static void tagWithThrower(ItemStack stack, Player player) {
        stack.m_41784_().m_128362_(TAG_THROWER, player.m_20148_());
    }

    private static void ensureThrowerTagOnce(ItemStack stack, ServerLevel level, ItemEntity entity) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128403_(TAG_THROWER)) {
            return;
        }
        Player nearest = level.m_45930_((Entity)entity, 2.0);
        if (nearest != null) {
            ShadowOrbItem.tagWithThrower(stack, nearest);
        }
    }

    @Nullable
    private static UUID getThrowerIdFromStack(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128403_(TAG_THROWER)) {
            return tag.m_128342_(TAG_THROWER);
        }
        return null;
    }

    @Nullable
    private static Player getThrower(ServerLevel level, ItemStack stack, ItemEntity entity) {
        CompoundTag e = entity.getPersistentData();
        if (e.m_128403_(E_THROWER)) {
            return level.m_46003_(e.m_128342_(E_THROWER));
        }
        UUID fromStack = ShadowOrbItem.getThrowerIdFromStack(stack);
        return fromStack != null ? level.m_46003_(fromStack) : null;
    }

    private static Vec3 getHoverAnchor(ServerLevel level, Player player) {
        Vec3 forward = player.m_20154_().m_82541_();
        Vec3 base = player.m_20182_().m_82549_(forward.m_82490_(1.8)).m_82520_(0.0, 1.2, 0.0);
        BlockPos pos = BlockPos.m_274446_((Position)base);
        int groundY = ShadowOrbItem.findGroundY(level, pos, 12);
        if (groundY != Integer.MIN_VALUE) {
            base = new Vec3(base.f_82479_, (double)groundY + 1.3, base.f_82481_);
        }
        return base;
    }

    private static int findGroundY(ServerLevel level, BlockPos start, int maxDown) {
        BlockPos.MutableBlockPos m = start.m_122032_();
        for (int i = 0; i <= maxDown; ++i) {
            BlockPos below = m.m_6625_(i + 1);
            BlockState state = level.m_8055_(below);
            if (state.m_60795_() || !state.m_60804_((BlockGetter)level, below)) continue;
            return below.m_123342_();
        }
        return Integer.MIN_VALUE;
    }

    private static void summonDoppelganger(ServerLevel level, Player player) {
        List banned = (List)Config.DOPPELGANGER_BANNED_ARMOR.get();
        Vec3 back = player.m_20154_().m_82541_().m_82490_(-2.5);
        Vec3 spawnPos = player.m_20182_().m_82549_(back).m_82520_(0.0, 0.25, 0.0);
        BlockPos groundCheck = BlockPos.m_274561_((double)spawnPos.f_82479_, (double)(spawnPos.f_82480_ - 1.0), (double)spawnPos.f_82481_);
        BlockState below = level.m_8055_(groundCheck);
        if (below.m_60795_() || !below.m_60804_((BlockGetter)level, groundCheck)) {
            spawnPos = player.m_20182_().m_82520_(0.0, 0.25, 0.0);
        }
        DarkDoppelgangerEntity boss = new DarkDoppelgangerEntity((EntityType<? extends AbstractSpellCastingMob>)((EntityType)EntityRegistry.DARK_DOPPELGANGER.get()), (Level)level);
        boss.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
        boss.m_6593_((Component)Component.m_237113_((String)player.m_7755_().getString()));
        boss.m_20340_(true);
        boss.setSummonerPlayer(player);
        boss.m_20049_("dark_doppelganger_boss");
        boss.m_8061_(EquipmentSlot.MAINHAND, player.m_21205_().m_41777_());
        ShadowOrbItem.setArmorFromPlayer(boss, player, banned);
        boss.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        boss.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
        boss.m_21409_(EquipmentSlot.HEAD, 0.0f);
        boss.m_21409_(EquipmentSlot.CHEST, 0.0f);
        boss.m_21409_(EquipmentSlot.LEGS, 0.0f);
        boss.m_21409_(EquipmentSlot.FEET, 0.0f);
        boss.m_21530_();
        boolean spawned = level.m_7967_((Entity)boss);
        if (spawned) {
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, boss.m_20185_(), boss.m_20186_(), boss.m_20189_(), 30, 0.5, 1.0, 0.5, 0.05);
            level.m_5594_(null, boss.m_20183_(), SoundEvents.f_11851_, SoundSource.HOSTILE, 1.0f, 0.5f);
        }
    }

    private static void setArmorFromPlayer(DarkDoppelgangerEntity boss, Player player, List<? extends String> banned) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itemStack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            ItemStack playerArmor = player.m_6844_(slot);
            boolean bannedArmor = ShadowOrbItem.isArmorBanned(playerArmor, banned);
            if (!playerArmor.m_41619_() && !bannedArmor) {
                itemStack = playerArmor.m_41777_();
            } else {
                switch (slot) {
                    case HEAD: {
                        itemStack = new ItemStack((ItemLike)ItemRegistry.NETHERITE_MAGE_HELMET.get());
                        break;
                    }
                    case CHEST: {
                        itemStack = new ItemStack((ItemLike)ItemRegistry.NETHERITE_MAGE_CHESTPLATE.get());
                        break;
                    }
                    case LEGS: {
                        itemStack = new ItemStack((ItemLike)ItemRegistry.NETHERITE_MAGE_LEGGINGS.get());
                        break;
                    }
                    case FEET: {
                        itemStack = new ItemStack((ItemLike)ItemRegistry.NETHERITE_MAGE_BOOTS.get());
                        break;
                    }
                    default: {
                        itemStack = ItemStack.f_41583_;
                    }
                }
            }
            ItemStack equip = itemStack;
            boss.m_8061_(slot, equip);
        }
    }

    private static boolean isArmorBanned(ItemStack stack, List<? extends String> bannedList) {
        if (stack.m_41619_()) {
            return false;
        }
        String itemId = stack.m_41720_().m_204114_().m_205785_().m_135782_().toString();
        for (String string : bannedList) {
            if (!(string.endsWith("*") ? itemId.startsWith(string.substring(0, string.length() - 1)) : itemId.equals(string))) continue;
            return true;
        }
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"orb.tooltip1").m_130940_(ChatFormatting.DARK_PURPLE));
        tooltip.add((Component)Component.m_237115_((String)"orb.tooltip2").m_130940_(ChatFormatting.GRAY));
    }
}

