/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.entity.mobs.IAnimatedAttacker;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.goals.PatrolNearLocationGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.SpellBarrageGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.melee.AttackAnimationData;
import io.redspace.ironsspellbooks.entity.mobs.wizards.GenericAnimatedWarlockAttackGoal;
import io.redspace.ironsspellbooks.spells.NoneSpell;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.bandit.darkdoppelganger.Config;
import net.bandit.darkdoppelganger.DarkDoppelgangerMod;
import net.bandit.darkdoppelganger.entity.DarkDoppelgangerEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class DarkDoppelgangerMinionEntity
extends AbstractSpellCastingMob
implements IAnimatedAttacker {
    private static final String NBT_SUMMONER_UUID = "SummonerUUID";
    private static final String NBT_IS_BOSS_MINION = "IsBossMinion";
    private static final String NBT_PLAYER_MINION_UUID = "DarkDoppel_SummonerMinionUUID";
    private static final String PERSISTED_TAG = "darkdoppelganger";
    private static final String NBT_WARN_COOLDOWN = "MinionWarnCooldown";
    private int age;
    @Nullable
    private UUID summonerUUID;
    private boolean isBossMinion = false;
    RawAnimation animationToPlay = null;
    private final RawAnimation ANIMATION_SPAWN = RawAnimation.begin().thenPlay("join_1");
    private final AnimationController<DarkDoppelgangerMinionEntity> meleeController = new AnimationController((GeoAnimatable)this, "keeper_animations", 0, this::predicate);
    private final AnimationController<DarkDoppelgangerMinionEntity> spawnController = new AnimationController((GeoAnimatable)this, "spawn_animations", 0, this::spawnPredicate);

    public DarkDoppelgangerMinionEntity(EntityType<? extends AbstractSpellCastingMob> type, Level world) {
        super(type, world);
        this.m_6593_((Component)Component.m_237113_((String)"Dark Doppelganger Minion"));
        this.f_21365_ = this.createLookControl();
        this.f_21342_ = this.createMoveControl();
    }

    public void setSummonerUUID(UUID uuid) {
        this.summonerUUID = uuid;
    }

    @Nullable
    public UUID getSummonerUUID() {
        return this.summonerUUID;
    }

    public void setBossMinion(boolean bossMinion) {
        if (this.isBossMinion == bossMinion) {
            return;
        }
        this.isBossMinion = bossMinion;
        if (!this.m_9236_().f_46443_) {
            this.f_21345_.m_262460_(g -> true);
            this.f_21346_.m_262460_(g -> true);
            this.m_8099_();
        }
    }

    public boolean isBossMinion() {
        return this.isBossMinion;
    }

    @Nullable
    public ServerPlayer getSummonerPlayer() {
        Level level;
        if (this.summonerUUID == null || !((level = this.m_9236_()) instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return serverLevel.m_7654_().m_6846_().m_11259_(this.summonerUUID);
    }

    public boolean m_21532_() {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 32.0).m_22268_((Attribute)ForgeMod.ENTITY_REACH.get(), 3.0);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.m_9236_().f_46443_) {
            this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.MINION_HEALTH.get()).doubleValue());
            this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Config.MINION_ATTACK_DAMAGE.get()).doubleValue());
            this.m_21051_(Attributes.f_22279_).m_22100_(((Double)Config.MINION_MOVEMENT_SPEED.get()).doubleValue());
            this.m_21051_(Attributes.f_22284_).m_22100_(((Double)Config.MINION_ARMOR.get()).doubleValue());
            this.m_21153_(this.m_21233_());
        }
    }

    protected void m_6668_(DamageSource source) {
    }

    public void playAnimation(String animationId) {
        try {
            this.animationToPlay = RawAnimation.begin().thenPlay(animationId);
        }
        catch (Exception ignored) {
            DarkDoppelgangerMod.LOGGER.error("Entity {} Failed to play animation: {}", (Object)this, (Object)animationId);
        }
    }

    private PlayState predicate(AnimationState<DarkDoppelgangerMinionEntity> animationEvent) {
        AnimationController controller = animationEvent.getController();
        if (this.age > 45 && this.animationToPlay != null) {
            controller.forceAnimationReset();
            controller.setAnimation(this.animationToPlay);
            this.animationToPlay = null;
        }
        return this.spawnController.getAnimationState() == AnimationController.State.STOPPED ? PlayState.CONTINUE : PlayState.STOP;
    }

    private PlayState spawnPredicate(AnimationState<DarkDoppelgangerMinionEntity> animationEvent) {
        AnimationController controller = animationEvent.getController();
        if (this.age < 45) {
            controller.setAnimation(this.ANIMATION_SPAWN);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{this.meleeController});
        controllerRegistrar.add(new AnimationController[]{this.spawnController});
        super.registerControllers(controllerRegistrar);
    }

    public boolean isAnimating() {
        return this.meleeController.getAnimationState() != AnimationController.State.STOPPED || this.spawnController.getAnimationState() != AnimationController.State.STOPPED || super.isAnimating();
    }

    private List<AbstractSpell> getConfiguredSpells(List<? extends String> ids) {
        return ids.stream().map(ResourceLocation::new).map(SpellRegistry::getSpell).filter(spell -> !(spell instanceof NoneSpell)).toList();
    }

    private List<AbstractSpell> getMinionConfiguredSpells() {
        return this.getConfiguredSpells((List)Config.MINION_SPELLS.get());
    }

    private List<AbstractSpell> getSpellGroup(List<AbstractSpell> list, int start, int count) {
        if (start >= list.size()) {
            return List.of();
        }
        return list.subList(start, Math.min(start + count, list.size()));
    }

    private AbstractSpell getMinionBarrageSpell() {
        try {
            ResourceLocation id = ResourceLocation.m_135820_((String)((String)Config.MINION_BARRAGE_SPELL.get()));
            if (id == null) {
                return (AbstractSpell)SpellRegistry.DEVOUR_SPELL.get();
            }
            AbstractSpell spell = SpellRegistry.getSpell((ResourceLocation)id);
            if (spell instanceof NoneSpell) {
                return (AbstractSpell)SpellRegistry.DEVOUR_SPELL.get();
            }
            return spell;
        }
        catch (Exception e) {
            return (AbstractSpell)SpellRegistry.DEVOUR_SPELL.get();
        }
    }

    protected MoveControl createMoveControl() {
        return new MoveControl((Mob)this){

            protected float m_24991_(float pSourceAngle, float pTargetAngle, float pMaximumChange) {
                double d1;
                double d0 = this.f_24975_ - this.f_24974_.m_20185_();
                if (d0 * d0 + (d1 = this.f_24977_ - this.f_24974_.m_20189_()) * d1 < 0.5) {
                    return pSourceAngle;
                }
                return super.m_24991_(pSourceAngle, pTargetAngle, pMaximumChange * 0.25f);
            }
        };
    }

    public boolean m_7307_(Entity other) {
        if (other == null) {
            return false;
        }
        if (this.isBossMinion) {
            DarkDoppelgangerMinionEntity m;
            if (other instanceof DarkDoppelgangerEntity) {
                DarkDoppelgangerEntity d = (DarkDoppelgangerEntity)other;
                if (!d.isClone) {
                    return true;
                }
            }
            return other instanceof DarkDoppelgangerMinionEntity && (m = (DarkDoppelgangerMinionEntity)other).isBossMinion();
        }
        ServerPlayer summoner = this.getSummonerPlayer();
        if (summoner != null) {
            if (other == summoner) {
                return true;
            }
            if (other.m_7307_((Entity)summoner)) {
                return true;
            }
        }
        return super.m_7307_(other);
    }

    public boolean m_6779_(LivingEntity target) {
        if (target == null) {
            return false;
        }
        if (this.isBossMinion) {
            DarkDoppelgangerMinionEntity m;
            if (target instanceof DarkDoppelgangerEntity) {
                DarkDoppelgangerEntity d = (DarkDoppelgangerEntity)target;
                if (!d.isClone) {
                    return false;
                }
            }
            if (target instanceof DarkDoppelgangerMinionEntity && (m = (DarkDoppelgangerMinionEntity)target).isBossMinion()) {
                return false;
            }
            return super.m_6779_(target);
        }
        if (target instanceof Player) {
            return false;
        }
        ServerPlayer summoner = this.getSummonerPlayer();
        if (summoner != null) {
            if (target == summoner) {
                return false;
            }
            if (target.m_7307_((Entity)summoner)) {
                return false;
            }
        }
        return super.m_6779_(target);
    }

    public void m_8119_() {
        LivingEntity t;
        CompoundTag data;
        int cd;
        super.m_8119_();
        ++this.age;
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.isBossMinion) {
            return;
        }
        ServerPlayer sp = this.getSummonerPlayer();
        if (sp == null || sp.m_21224_()) {
            this.m_146870_();
            return;
        }
        ServerPlayer summoner = sp;
        if (sp != null && (cd = (data = sp.getPersistentData().m_128469_(PERSISTED_TAG)).m_128451_(NBT_WARN_COOLDOWN)) > 0) {
            data.m_128405_(NBT_WARN_COOLDOWN, cd - 1);
            sp.getPersistentData().m_128365_(PERSISTED_TAG, (Tag)data);
        }
        if (summoner.m_9236_() != this.m_9236_()) {
            this.m_146870_();
            return;
        }
        double distSq = this.m_20280_((Entity)summoner);
        if (distSq > 324.0) {
            this.m_6021_(summoner.m_20185_(), summoner.m_20186_(), summoner.m_20189_());
        } else if (distSq > 36.0) {
            this.m_21573_().m_5624_((Entity)summoner, 1.2);
        }
        if (this.m_5448_() == null) {
            LivingEntity a = summoner.m_21214_();
            LivingEntity b = summoner.m_21188_();
            if (a != null && a.m_6084_() && this.m_6779_(a)) {
                this.m_6710_(a);
            } else if (b != null && b.m_6084_() && this.m_6779_(b)) {
                this.m_6710_(b);
            }
        }
        if (!((t = this.m_5448_()) == null || t.m_6084_() && this.m_6779_(t) && !(this.m_20280_((Entity)t) > 1024.0))) {
            this.m_6710_(null);
        }
    }

    public static boolean playerHasLivingMinion(ServerLevel level, ServerPlayer player) {
        DarkDoppelgangerMinionEntity m;
        CompoundTag tag = player.getPersistentData();
        if (!tag.m_128403_(NBT_PLAYER_MINION_UUID)) {
            return false;
        }
        UUID id = tag.m_128342_(NBT_PLAYER_MINION_UUID);
        Entity e = level.m_8791_(id);
        if (e instanceof DarkDoppelgangerMinionEntity && (m = (DarkDoppelgangerMinionEntity)e).m_6084_() && !m.isBossMinion()) {
            return true;
        }
        tag.m_128473_(NBT_PLAYER_MINION_UUID);
        return false;
    }

    public static void linkPlayerToMinion(ServerPlayer player, UUID minionId) {
        player.getPersistentData().m_128362_(NBT_PLAYER_MINION_UUID, minionId);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.summonerUUID != null) {
            tag.m_128362_(NBT_SUMMONER_UUID, this.summonerUUID);
        }
        tag.m_128379_(NBT_IS_BOSS_MINION, this.isBossMinion);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_(NBT_SUMMONER_UUID)) {
            this.summonerUUID = tag.m_128342_(NBT_SUMMONER_UUID);
        }
        this.isBossMinion = tag.m_128471_(NBT_IS_BOSS_MINION);
    }

    public boolean m_8023_() {
        return true;
    }

    protected void m_8099_() {
        this.setFirstPhaseGoals();
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        if (this.isBossMinion) {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        } else {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 6, true, true, e -> {
                if (!(e instanceof Mob)) {
                    return false;
                }
                Mob mob = (Mob)e;
                if (e instanceof Player) {
                    return false;
                }
                if (mob.m_6095_().m_20674_() != MobCategory.MONSTER) {
                    return false;
                }
                ServerPlayer summoner = this.getSummonerPlayer();
                if (summoner != null) {
                    if (e == summoner) {
                        return false;
                    }
                    if (e.m_7307_((Entity)summoner)) {
                        return false;
                    }
                }
                return this.m_6779_((LivingEntity)e);
            }));
        }
    }

    protected void setFirstPhaseGoals() {
        this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
        this.f_21345_.m_262460_(x -> true);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        AbstractSpell barrageSpell = this.getMinionBarrageSpell();
        this.f_21345_.m_25352_(2, (Goal)new SpellBarrageGoal((IMagicEntity)this, barrageSpell, 3, 6, 100, 250, 1));
        ArrayList<AbstractSpell> allSpells = new ArrayList<AbstractSpell>(this.getMinionConfiguredSpells());
        Collections.shuffle(allSpells, new Random(this.f_19796_.m_188505_()));
        List<AbstractSpell> group1 = this.getSpellGroup(allSpells, 0, 3);
        List<AbstractSpell> group2 = this.getSpellGroup(allSpells, 3, 3);
        List<AbstractSpell> group3 = this.getSpellGroup(allSpells, 6, 2);
        List<AbstractSpell> group4 = this.getSpellGroup(allSpells, 8, 4);
        this.f_21345_.m_25352_(3, (Goal)new GenericAnimatedWarlockAttackGoal((PathfinderMob)this, 1.25, 50, 75).setMoveset(List.of(new AttackAnimationData(9, "simple_sword_upward_swipe", new int[]{5}), new AttackAnimationData(8, "simple_sword_lunge_stab", new int[]{6}), new AttackAnimationData(10, "simple_sword_stab_alternate", new int[]{8}), new AttackAnimationData(10, "simple_sword_horizontal_cross_swipe", new int[]{8}))).setComboChance(0.4f).setMeleeAttackInverval(10, 30).setMeleeMovespeedModifier(1.5f).setSpells(group1, group2, group3, group4));
        this.f_21345_.m_25352_(4, (Goal)new PatrolNearLocationGoal((PathfinderMob)this, 30.0f, 0.75));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    public void m_6667_(DamageSource source) {
        this.clearPlayerMinionLink();
        super.m_6667_(source);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        this.clearPlayerMinionLink();
        super.m_142687_(reason);
    }

    private void clearPlayerMinionLink() {
        UUID stored;
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.isBossMinion) {
            return;
        }
        ServerPlayer summoner = this.getSummonerPlayer();
        if (summoner == null) {
            return;
        }
        CompoundTag tag = summoner.getPersistentData();
        if (tag.m_128403_(NBT_PLAYER_MINION_UUID) && (stored = tag.m_128342_(NBT_PLAYER_MINION_UUID)).equals(this.m_20148_())) {
            tag.m_128473_(NBT_PLAYER_MINION_UUID);
        }
    }
}

