/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.darkdoppelganger.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.bandit.darkdoppelganger.entity.DarkDoppelgangerEntity;
import net.bandit.darkdoppelganger.event.SummonDoppelganger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ModCommands {
    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"darkd").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"summon_doppelganger").executes(ctx -> SummonDoppelganger.summonDoppelganger((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"kill_doppelganger").executes(ctx -> ModCommands.killDoppelgangers((CommandSourceStack)ctx.getSource(), 256))).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)4096)).executes(ctx -> ModCommands.killDoppelgangers((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"))))));
    }

    private static int killDoppelgangers(CommandSourceStack source, int radius) {
        ServerLevel level = source.m_81372_();
        Vec3 pos = source.m_81371_();
        AABB box = new AABB(pos.f_82479_ - (double)radius, pos.f_82480_ - (double)radius, pos.f_82481_ - (double)radius, pos.f_82479_ + (double)radius, pos.f_82480_ + (double)radius, pos.f_82481_ + (double)radius);
        List found = level.m_45976_(DarkDoppelgangerEntity.class, box);
        int bosses = 0;
        int clones = 0;
        for (DarkDoppelgangerEntity d : found) {
            boolean isClone;
            boolean isBoss = d.m_19880_().contains("dark_doppelganger_boss");
            boolean bl = isClone = d.m_19880_().contains("dark_doppelganger_clone") || d.isClone;
            if (!isBoss && !isClone) continue;
            d.m_6074_();
            if (isBoss) {
                ++bosses;
                continue;
            }
            ++clones;
        }
        int total = bosses + clones;
        if (total == 0) {
            source.m_81352_((Component)Component.m_237113_((String)("No Dark Doppelganger entities found in radius " + radius + ".")));
        } else {
            int fb = bosses;
            int fc = clones;
            source.m_288197_(() -> Component.m_237113_((String)("Removed " + total + " Dark Doppelganger entity(ies) in radius " + radius + " (bosses: " + fb + ", clones/minions: " + fc + ").")), true);
        }
        return total;
    }
}

