/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.tools.rules;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.InControl;
import mcjty.incontrol.tools.varia.Tools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class TestingTools {
    public static <T extends Comparable<T>> BlockState set(BlockState state, Property<T> property, String value) {
        Optional optionalValue = property.m_6215_(value);
        return optionalValue.map(t -> (BlockState)state.m_61124_(property, t)).orElse(state);
    }

    public static List<Predicate<ItemStack>> getItemsJson(JsonElement itemObj) {
        ArrayList<Predicate<ItemStack>> items = new ArrayList<Predicate<ItemStack>>();
        if (itemObj.isJsonObject()) {
            Predicate<ItemStack> matcher = TestingTools.getMatcher(itemObj.getAsJsonObject());
            if (matcher != null) {
                items.add(matcher);
            }
        } else if (itemObj.isJsonArray()) {
            for (JsonElement element : itemObj.getAsJsonArray()) {
                JsonObject obj = element.getAsJsonObject();
                Predicate<ItemStack> matcher = TestingTools.getMatcher(obj);
                if (matcher == null) continue;
                items.add(matcher);
            }
        } else {
            ErrorHandler.error("Item description is not valid!");
        }
        return items;
    }

    private static Predicate<Integer> getExpressionInteger(String expression, boolean onlyInt) {
        try {
            if (expression.startsWith(">=")) {
                int amount = Integer.parseInt(expression.substring(2));
                return i -> i >= amount;
            }
            if (expression.startsWith(">")) {
                int amount = Integer.parseInt(expression.substring(1));
                return i -> i > amount;
            }
            if (expression.startsWith("<=")) {
                int amount = Integer.parseInt(expression.substring(2));
                return i -> i <= amount;
            }
            if (expression.startsWith("<")) {
                int amount = Integer.parseInt(expression.substring(1));
                return i -> i < amount;
            }
            if (expression.startsWith("=")) {
                int amount = Integer.parseInt(expression.substring(1));
                return i -> i == amount;
            }
            if (expression.startsWith("!=") || expression.startsWith("<>")) {
                int amount = Integer.parseInt(expression.substring(2));
                return i -> i != amount;
            }
            if (expression.contains("-")) {
                String[] split = StringUtils.split((String)expression, (String)"-");
                int amount1 = Integer.parseInt(split[0]);
                int amount2 = Integer.parseInt(split[1]);
                return i -> i >= amount1 && i <= amount2;
            }
            int amount = Integer.parseInt(expression);
            return i -> i == amount;
        }
        catch (NumberFormatException e) {
            if (onlyInt) {
                ErrorHandler.error("Bad expression '" + expression + "'!");
            }
            return null;
        }
    }

    public static Predicate<Integer> getExpression(JsonElement element) {
        if (element.isJsonPrimitive()) {
            if (element.getAsJsonPrimitive().isNumber()) {
                int amount = element.getAsInt();
                return i -> i == amount;
            }
            return TestingTools.getExpressionInteger(element.getAsString(), true);
        }
        ErrorHandler.error("Bad expression!");
        return null;
    }

    private static Predicate<CompoundTag> getExpressionOrString(JsonElement element, String tag) {
        if (element.isJsonPrimitive()) {
            if (element.getAsJsonPrimitive().isNumber()) {
                int amount = element.getAsInt();
                return tagCompound -> tagCompound.m_128451_(tag) == amount;
            }
            if (element.getAsJsonPrimitive().isBoolean()) {
                boolean v = element.getAsBoolean();
                return tagCompound -> tagCompound.m_128471_(tag) == v;
            }
            String str = element.getAsString();
            Predicate<Integer> predicate = TestingTools.getExpressionInteger(str, false);
            if (predicate == null) {
                return tagCompound -> str.equals(tagCompound.m_128461_(tag));
            }
            return tagCompound -> predicate.test(tagCompound.m_128451_(tag));
        }
        ErrorHandler.error("Bad expression!");
        return null;
    }

    private static Predicate<ItemStack> getMatcher(String name) {
        ItemStack stack = Tools.parseStack(name);
        if (!stack.m_41619_()) {
            if (name.contains("/") && name.contains("@")) {
                return s -> ItemStack.m_41656_((ItemStack)s, (ItemStack)stack) && ItemStack.m_150942_((ItemStack)s, (ItemStack)stack);
            }
            if (name.contains("/")) {
                return s -> ItemStack.m_150942_((ItemStack)s, (ItemStack)stack) && ItemStack.m_150942_((ItemStack)s, (ItemStack)stack);
            }
            if (name.contains("@")) {
                return s -> ItemStack.m_41656_((ItemStack)s, (ItemStack)stack);
            }
            return s -> s.m_41720_() == stack.m_41720_();
        }
        return null;
    }

    private static Predicate<ItemStack> getMatcher(JsonObject obj) {
        Predicate<Integer> energy;
        List<Predicate<CompoundTag>> nbtMatchers;
        Predicate<ItemStack> finalTest;
        Predicate<Integer> count;
        Predicate<ItemStack> test;
        Item item;
        if (obj.has("empty")) {
            boolean empty = obj.get("empty").getAsBoolean();
            return s -> s.m_41619_() == empty;
        }
        if (obj.has("item")) {
            String name = obj.get("item").getAsString();
            item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
            if (item == null) {
                ErrorHandler.error("Unknown item '" + name + "'!");
                return null;
            }
        } else {
            item = null;
        }
        if (obj.has("damage")) {
            Predicate<Integer> damage = TestingTools.getExpression(obj.get("damage"));
            if (damage == null) {
                return null;
            }
            test = item == null ? s -> damage.test(s.m_41773_()) : s -> s.m_41720_() == item && damage.test(s.m_41773_());
        } else {
            test = item == null ? null : s -> s.m_41720_() == item;
        }
        if (obj.has("count") && (count = TestingTools.getExpression(obj.get("count"))) != null) {
            if (test == null) {
                test = s -> count.test(s.m_41613_());
            } else {
                finalTest = test;
                test = s -> finalTest.test((ItemStack)s) && count.test(s.m_41613_());
            }
        }
        if (obj.has("tag")) {
            ResourceLocation tagname = new ResourceLocation(obj.get("tag").getAsString());
            TagKey key = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagname);
            if (test == null) {
                test = s -> s.m_204117_(key);
            } else {
                Predicate<ItemStack> finalTest2 = test;
                test = s -> finalTest2.test((ItemStack)s) && s.m_204117_(key);
            }
        }
        if (obj.has("mod")) {
            String mod = obj.get("mod").getAsString();
            if (test == null) {
                test = s -> mod.equals(ForgeRegistries.ITEMS.getKey((Object)s.m_41720_()).m_135827_());
            } else {
                finalTest = test;
                test = s -> finalTest.test((ItemStack)s) && mod.equals(ForgeRegistries.ITEMS.getKey((Object)s.m_41720_()).m_135827_());
            }
        }
        if (obj.has("nbt") && (nbtMatchers = TestingTools.getNbtMatchers(obj)) != null) {
            if (test == null) {
                test = s -> nbtMatchers.stream().allMatch(p -> p.test(s.m_41783_()));
            } else {
                finalTest = test;
                test = s -> finalTest.test((ItemStack)s) && nbtMatchers.stream().allMatch(p -> p.test(s.m_41783_()));
            }
        }
        if (obj.has("energy") && (energy = TestingTools.getExpression(obj.get("energy"))) != null) {
            if (test == null) {
                test = s -> energy.test(TestingTools.getEnergy(s));
            } else {
                finalTest = test;
                test = s -> finalTest.test((ItemStack)s) && energy.test(TestingTools.getEnergy(s));
            }
        }
        if (test == null) {
            ErrorHandler.error("No item description found!");
        }
        return test;
    }

    private static int getEnergy(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public static boolean contains(LevelAccessor world, BlockPos pos, @Nullable Direction side, @Nonnull List<Predicate<ItemStack>> matchers) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity != null) {
            return tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, side).map(h -> {
                for (int i = 0; i < h.getSlots(); ++i) {
                    ItemStack stack = h.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    for (Predicate matcher : matchers) {
                        if (!matcher.test(stack)) continue;
                        return true;
                    }
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    public static int getEnergy(LevelAccessor world, BlockPos pos, @Nullable Direction side) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity != null) {
            return tileEntity.getCapability(ForgeCapabilities.ENERGY, side).map(IEnergyStorage::getEnergyStored).orElse(0);
        }
        return 0;
    }

    private static List<Predicate<CompoundTag>> getNbtMatchers(JsonObject obj) {
        JsonArray nbtArray = obj.getAsJsonArray("nbt");
        return TestingTools.getNbtMatchers(nbtArray);
    }

    private static List<Predicate<CompoundTag>> getNbtMatchers(JsonArray nbtArray) {
        ArrayList<Predicate<CompoundTag>> nbtMatchers = new ArrayList<Predicate<CompoundTag>>();
        for (JsonElement element : nbtArray) {
            JsonObject o = element.getAsJsonObject();
            String tag = o.get("tag").getAsString();
            if (o.has("contains")) {
                List<Predicate<CompoundTag>> subMatchers = TestingTools.getNbtMatchers(o.getAsJsonArray("contains"));
                nbtMatchers.add(tagCompound -> {
                    if (tagCompound != null) {
                        ListTag list = tagCompound.m_128437_(tag, 10);
                        for (Tag base : list) {
                            for (Predicate matcher : subMatchers) {
                                if (!matcher.test((CompoundTag)base)) continue;
                                return true;
                            }
                        }
                    }
                    return false;
                });
                continue;
            }
            Predicate<CompoundTag> nbt = TestingTools.getExpressionOrString(o.get("value"), tag);
            if (nbt == null) continue;
            nbtMatchers.add(nbt);
        }
        return nbtMatchers;
    }

    public static List<Predicate<ItemStack>> getItems(List<String> itemNames) {
        ArrayList<Predicate<ItemStack>> items = new ArrayList<Predicate<ItemStack>>();
        Iterator<String> iterator = itemNames.iterator();
        while (iterator.hasNext()) {
            Predicate<ItemStack> matcher;
            JsonParser parser = new JsonParser();
            String json = iterator.next();
            JsonElement element = parser.parse(json);
            if (element.isJsonPrimitive()) {
                String name = element.getAsString();
                matcher = TestingTools.getMatcher(name);
                if (matcher == null) continue;
                items.add(matcher);
                continue;
            }
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                matcher = TestingTools.getMatcher(obj);
                if (matcher == null) continue;
                items.add(matcher);
                continue;
            }
            ErrorHandler.error("Item description '" + json + "' is not valid!");
        }
        return items;
    }

    public static boolean isSlimeChunk(ChunkPos cp, LevelAccessor world) {
        long seed = 0L;
        if (world instanceof WorldGenLevel) {
            WorldGenLevel level = (WorldGenLevel)world;
            seed = level.m_7328_();
        }
        return WorldgenRandom.m_224681_((int)cp.f_45578_, (int)cp.f_45579_, (long)seed, (long)987234911L).m_188503_(10) == 0;
    }

    public static boolean isFakePlayer(Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        if (entity instanceof FakePlayer) {
            return true;
        }
        PlayerList playerList = entity.m_20193_().m_7654_().m_6846_();
        ServerPlayer playerByUUID = playerList.m_11259_(((Player)entity).m_36316_().getId());
        if (playerByUUID == null) {
            return true;
        }
        return entity != playerByUUID;
    }

    public static boolean isRealPlayer(Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        return !TestingTools.isFakePlayer(entity);
    }

    public static void warn(String message) {
        InControl.setup.getLogger().warn(message);
    }

    public static boolean isChunkInvalid(LevelAccessor world, BlockPos pos) {
        LevelChunk chunk = world.m_7726_().m_7131_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
        return chunk == null || !chunk.m_6415_().m_62427_(ChunkStatus.f_62326_);
    }

    @Nullable
    public static NumberResult parseNumberCheck(JsonElement element) {
        if (!element.isJsonObject()) {
            ErrorHandler.error("Number check needs to be an object!");
            return null;
        }
        JsonObject object = element.getAsJsonObject();
        if (!object.has("name")) {
            ErrorHandler.error("Number check needs to have a 'name' field!");
            return null;
        }
        if (!object.has("expression")) {
            ErrorHandler.error("Number check needs to have a 'expression' field!");
            return null;
        }
        String number = object.get("name").getAsString();
        String expression = object.get("expression").getAsString();
        Predicate<Integer> test = Tools.parseExpression(expression);
        if (test == null) {
            return null;
        }
        return new NumberResult(number, test);
    }

    public record NumberResult(String number, Predicate<Integer> test) {
    }
}

