/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import com.google.gson.JsonElement;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.InControl;
import mcjty.incontrol.data.DataStorage;
import mcjty.incontrol.rules.EffectRule;
import mcjty.incontrol.rules.ExperienceRule;
import mcjty.incontrol.rules.HarvestRule;
import mcjty.incontrol.rules.LeftClickRule;
import mcjty.incontrol.rules.LootRule;
import mcjty.incontrol.rules.PhaseRule;
import mcjty.incontrol.rules.PlaceRule;
import mcjty.incontrol.rules.RightClickRule;
import mcjty.incontrol.rules.SpawnRule;
import mcjty.incontrol.rules.SummonAidRule;
import mcjty.incontrol.rules.support.SpawnWhen;
import mcjty.incontrol.tools.varia.JSonTools;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class RulesManager {
    private static final List<SpawnRule> rules = new ArrayList<SpawnRule>();
    private static List<SpawnRule> filteredRulesPosition = null;
    private static List<SpawnRule> filteredRulesOnJoin = null;
    private static List<SpawnRule> filteredRulesFinalize = null;
    private static List<SpawnRule> filteredRulesDespawn = null;
    private static final List<SummonAidRule> summonAidRules = new ArrayList<SummonAidRule>();
    private static List<SummonAidRule> filteredSummonAidRules = null;
    private static final List<LootRule> lootRules = new ArrayList<LootRule>();
    private static List<LootRule> filteredLootRules = null;
    private static final List<ExperienceRule> experienceRules = new ArrayList<ExperienceRule>();
    private static List<ExperienceRule> filteredExperienceRules = null;
    public static List<PhaseRule> phaseRules = new ArrayList<PhaseRule>();
    private static String path;
    private static final List<EffectRule> effectRules;
    private static List<EffectRule> filteredEffectRules;
    private static final List<HarvestRule> harvestRules;
    private static List<HarvestRule> filteredHarvestRules;
    private static final List<PlaceRule> placeRules;
    private static List<PlaceRule> filteredPlaceRules;
    private static final List<RightClickRule> rightclickRules;
    private static List<RightClickRule> filteredRightClickRules;
    private static final List<LeftClickRule> leftclickRules;
    private static List<LeftClickRule> filteredLeftClickRules;

    public static void reloadRules() {
        rules.clear();
        summonAidRules.clear();
        lootRules.clear();
        experienceRules.clear();
        phaseRules.clear();
        effectRules.clear();
        harvestRules.clear();
        placeRules.clear();
        rightclickRules.clear();
        leftclickRules.clear();
        RulesManager.onPhaseChange();
        RulesManager.readAllRules();
    }

    public static void setRulePath(Path path) {
        RulesManager.path = path.toString();
    }

    public static void readRules() {
        RulesManager.readAllRules();
    }

    public static void onPhaseChange() {
        filteredRulesPosition = null;
        filteredRulesOnJoin = null;
        filteredRulesFinalize = null;
        filteredRulesDespawn = null;
        filteredSummonAidRules = null;
        filteredLootRules = null;
        filteredExperienceRules = null;
        filteredEffectRules = null;
        filteredHarvestRules = null;
        filteredPlaceRules = null;
        filteredRightClickRules = null;
        filteredLeftClickRules = null;
    }

    private static List<SpawnRule> getCorrectList(SpawnWhen when) {
        return switch (when) {
            default -> throw new IncompatibleClassChangeError();
            case SpawnWhen.POSITION -> filteredRulesPosition;
            case SpawnWhen.ONJOIN -> filteredRulesOnJoin;
            case SpawnWhen.FINALIZE -> filteredRulesFinalize;
            case SpawnWhen.DESPAWN -> filteredRulesDespawn;
        };
    }

    private static void setCorrectList(SpawnWhen when, List<SpawnRule> list) {
        switch (when) {
            case POSITION: {
                filteredRulesPosition = list;
                break;
            }
            case ONJOIN: {
                filteredRulesOnJoin = list;
                break;
            }
            case FINALIZE: {
                filteredRulesFinalize = list;
                break;
            }
            case DESPAWN: {
                filteredRulesDespawn = list;
            }
        }
    }

    public static List<EffectRule> getFilteredEffectRules(Level world) {
        if (filteredEffectRules == null) {
            Set<String> phases = DataStorage.getData((LevelAccessor)world).getPhases();
            filteredEffectRules = effectRules.stream().filter(r -> phases.containsAll(r.getPhases())).collect(Collectors.toList());
        }
        return filteredEffectRules;
    }

    public static List<HarvestRule> getFilteredHarvestRules(LevelAccessor world) {
        if (filteredHarvestRules == null) {
            Set<String> phases = DataStorage.getData(world).getPhases();
            filteredHarvestRules = harvestRules.stream().filter(r -> phases.containsAll(r.getPhases())).collect(Collectors.toList());
        }
        return filteredHarvestRules;
    }

    public static List<PlaceRule> getFilteredPlaceRules(LevelAccessor world) {
        if (filteredPlaceRules == null) {
            Set<String> phases = DataStorage.getData(world).getPhases();
            filteredPlaceRules = placeRules.stream().filter(r -> phases.containsAll(r.getPhases())).collect(Collectors.toList());
        }
        return filteredPlaceRules;
    }

    public static List<RightClickRule> getFilteredRightClickRules(Level world) {
        if (filteredRightClickRules == null) {
            Set<String> phases = DataStorage.getData((LevelAccessor)world).getPhases();
            filteredRightClickRules = rightclickRules.stream().filter(r -> phases.containsAll(r.getPhases())).collect(Collectors.toList());
        }
        return filteredRightClickRules;
    }

    public static List<LeftClickRule> getFilteredLeftClickRules(Level world) {
        if (filteredLeftClickRules == null) {
            Set<String> phases = DataStorage.getData((LevelAccessor)world).getPhases();
            filteredLeftClickRules = leftclickRules.stream().filter(r -> phases.containsAll(r.getPhases())).collect(Collectors.toList());
        }
        return filteredLeftClickRules;
    }

    public static List<SpawnRule> getFilteredRules(Level world, SpawnWhen when) {
        List<SpawnRule> correctList = RulesManager.getCorrectList(when);
        if (correctList == null) {
            Set<String> phases = DataStorage.getData((LevelAccessor)world).getPhases();
            correctList = rules.stream().filter(r -> r.getWhen() == when && phases.containsAll(r.getPhases())).collect(Collectors.toList());
        }
        RulesManager.setCorrectList(when, correctList);
        return correctList;
    }

    public static List<SummonAidRule> getFilteredSummonAidRules(Level world) {
        if (filteredSummonAidRules == null) {
            Set<String> phases = DataStorage.getData((LevelAccessor)world).getPhases();
            filteredSummonAidRules = summonAidRules.stream().filter(r -> phases.containsAll(r.getPhases())).collect(Collectors.toList());
        }
        return filteredSummonAidRules;
    }

    public static List<LootRule> getFilteredLootRules(Level world) {
        if (filteredLootRules == null) {
            Set<String> phases = DataStorage.getData((LevelAccessor)world).getPhases();
            filteredLootRules = lootRules.stream().filter(r -> phases.containsAll(r.getPhases())).collect(Collectors.toList());
        }
        return filteredLootRules;
    }

    public static List<ExperienceRule> getFilteredExperienceRuiles(Level world) {
        if (filteredExperienceRules == null) {
            Set<String> phases = DataStorage.getData((LevelAccessor)world).getPhases();
            filteredExperienceRules = experienceRules.stream().filter(r -> phases.containsAll(r.getPhases())).collect(Collectors.toList());
        }
        return filteredExperienceRules;
    }

    private static boolean exists(String file) {
        File f = new File(file);
        return f.exists() && !f.isDirectory();
    }

    private static void readAllRules() {
        File directory = new File(path + File.separator + "incontrol");
        if (!directory.exists()) {
            directory.mkdir();
        }
        RulesManager.safeCall("spawn.json", () -> RulesManager.readRules(path, "spawn.json", SpawnRule::parse, rules));
        RulesManager.safeCall("summonaid.json", () -> RulesManager.readRules(path, "summonaid.json", SummonAidRule::parse, summonAidRules));
        RulesManager.safeCall("loot.json", () -> RulesManager.readRules(path, "loot.json", LootRule::parse, lootRules));
        RulesManager.safeCall("experience.json", () -> RulesManager.readRules(path, "experience.json", ExperienceRule::parse, experienceRules));
        RulesManager.safeCall("phases.json", () -> RulesManager.readRules(path, "phases.json", PhaseRule::parse, phaseRules));
        RulesManager.safeCall("effects.json", () -> RulesManager.readRules(path, "effects.json", EffectRule::parse, effectRules));
        RulesManager.safeCall("breakevents.json", () -> RulesManager.readRules(path, "breakevents.json", HarvestRule::parse, harvestRules));
        RulesManager.safeCall("placeevents.json", () -> RulesManager.readRules(path, "placeevents.json", PlaceRule::parse, placeRules));
        RulesManager.safeCall("rightclicks.json", () -> RulesManager.readRules(path, "rightclicks.json", RightClickRule::parse, rightclickRules));
        RulesManager.safeCall("leftclicks.json", () -> RulesManager.readRules(path, "leftclicks.json", LeftClickRule::parse, leftclickRules));
    }

    private static void safeCall(String name, Runnable code) {
        try {
            code.run();
        }
        catch (Exception e) {
            ErrorHandler.error("JSON error in '" + name + "': check log for details (" + e.getMessage() + ")");
            InControl.setup.getLogger().log(org.apache.logging.log4j.Level.ERROR, "Error parsing '" + name + "'", (Throwable)e);
        }
    }

    private static <T> void readRules(String path, String filename, BiFunction<JsonElement, Integer, T> parser, List<T> rules) {
        JsonElement element = RulesManager.getRootElement(path, filename);
        if (element == null) {
            return;
        }
        int i = 0;
        for (JsonElement entry : element.getAsJsonArray()) {
            T rule = parser.apply(entry, i);
            if (rule != null) {
                rules.add(rule);
            } else {
                InControl.setup.getLogger().log(org.apache.logging.log4j.Level.ERROR, "Rule " + i + " in " + filename + " is invalid, skipping!");
            }
            ++i;
        }
    }

    private static JsonElement getRootElement(String path, String filename) {
        return JSonTools.getRootElement(path, filename, InControl.setup.getLogger());
    }

    static {
        effectRules = new ArrayList<EffectRule>();
        filteredEffectRules = null;
        harvestRules = new ArrayList<HarvestRule>();
        filteredHarvestRules = null;
        placeRules = new ArrayList<PlaceRule>();
        filteredPlaceRules = null;
        rightclickRules = new ArrayList<RightClickRule>();
        filteredRightClickRules = null;
        leftclickRules = new ArrayList<LeftClickRule>();
        filteredLeftClickRules = null;
    }
}

