/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fastitemframes.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.fastitemframes.capability.ItemFrameColorCapability;
import fuzs.fastitemframes.client.renderer.blockentity.ItemFrameBlockRenderer;
import fuzs.fastitemframes.init.ModRegistry;
import fuzs.puzzleslib.api.client.core.v1.ClientAbstractions;
import java.util.OptionalInt;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemFrameRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ItemFrameRenderer.class})
abstract class ItemFrameRendererMixin<T extends ItemFrame>
extends EntityRenderer<T> {
    @Shadow
    @Final
    private BlockRenderDispatcher f_234645_;

    protected ItemFrameRendererMixin(EntityRendererProvider.Context context) {
        super(context);
    }

    @ModifyVariable(method={"render"}, at=@At(value="STORE"), ordinal=0)
    public boolean render(boolean isInvisible, T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        OptionalInt color;
        if (!isInvisible && (color = ((ItemFrameColorCapability)ModRegistry.ITEM_FRAME_COLOR_CAPABILITY.get(entity)).getColor()).isPresent()) {
            ItemStack itemStack = entity.m_31822_();
            ModelResourceLocation modelResourceLocation = this.m_174212_(entity, itemStack);
            ResourceLocation resourceLocation = ItemFrameBlockRenderer.ITEM_FRAME_BLOCK_MODELS.getOrDefault(modelResourceLocation, (ResourceLocation)modelResourceLocation);
            poseStack.m_85836_();
            poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
            float red = (float)FastColor.ARGB32.m_13665_((int)color.getAsInt()) / 255.0f;
            float green = (float)FastColor.ARGB32.m_13667_((int)color.getAsInt()) / 255.0f;
            float blue = (float)FastColor.ARGB32.m_13669_((int)color.getAsInt()) / 255.0f;
            this.f_234645_.m_110937_().m_111067_(poseStack.m_85850_(), buffer.m_6299_(Sheets.m_110789_()), null, ClientAbstractions.INSTANCE.getBakedModel(resourceLocation), red, green, blue, packedLight, OverlayTexture.f_118083_);
            poseStack.m_85849_();
            if (!itemStack.m_41619_()) {
                poseStack.m_252880_(0.0f, 0.0f, -0.0625f);
            }
            return true;
        }
        return isInvisible;
    }

    @Shadow
    private ModelResourceLocation m_174212_(T entity, ItemStack item) {
        throw new RuntimeException();
    }
}

