/*
 * Decompiled with CFR 0.152.
 */
package dev.fulmineo.guild.network;

import dev.fulmineo.guild.Guild;
import dev.fulmineo.guild.data.ClientDataManager;
import dev.fulmineo.guild.data.Quest;
import dev.fulmineo.guild.data.QuestProfessionRequirement;
import dev.fulmineo.guild.data.Range;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class ClientNetworkManager {
    public static void registerServerReceiver() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Guild.TRANSFER_CLIENT_DATA_ID, (client, handler, buf, responseSender) -> {
            ClientDataManager.professionsLabels.clear();
            ClientDataManager.professionRequirements.clear();
            class_2487 nbt = buf.method_10798();
            class_2487 professionsLabels = nbt.method_10562("Labels");
            for (String professionName : professionsLabels.method_10541()) {
                ClientDataManager.professionsLabels.put(professionName, professionsLabels.method_10558(professionName));
            }
            class_2487 professionsRequirements = nbt.method_10562("Requirements");
            for (String professionName : professionsRequirements.method_10541()) {
                class_2499 requirementsList = professionsRequirements.method_10554(professionName, 10);
                int length = requirementsList.size();
                QuestProfessionRequirement[] reqs = new QuestProfessionRequirement[length];
                for (int i = 0; i < length; ++i) {
                    class_2487 entry = (class_2487)requirementsList.method_10534(i);
                    QuestProfessionRequirement req = new QuestProfessionRequirement();
                    if (entry.method_10545("Profession")) {
                        req.profession = entry.method_10558("Profession");
                    }
                    if (entry.method_10545("Level")) {
                        class_2487 level = entry.method_10562("Level");
                        req.level = new Range();
                        if (level.method_10545("Min")) {
                            req.level.min = level.method_10550("Min");
                        }
                        if (level.method_10545("Max")) {
                            req.level.max = level.method_10550("Max");
                        }
                    }
                    reqs[i] = req;
                }
                ClientDataManager.professionRequirements.put(professionName, reqs);
            }
        });
    }

    public static void openGuildScreen() {
        ClientPlayNetworking.send((class_2960)Guild.OPEN_QUESTS_SCREEN_PACKET_ID, (class_2540)PacketByteBufs.empty());
    }

    public static void acceptQuest(String profession, int index) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(profession);
        buf.writeInt(index);
        ClientPlayNetworking.send((class_2960)Guild.ACCEPT_QUEST_PACKET_ID, (class_2540)buf);
    }

    public static void deleteAcceptedQuest(List<Quest> acceptedQuests, int index) {
        if (acceptedQuests.size() > index) {
            acceptedQuests.remove(index);
            class_2540 buf = PacketByteBufs.create();
            buf.writeInt(index);
            ClientPlayNetworking.send((class_2960)Guild.DELETE_ACCEPTED_QUEST_PACKET_ID, (class_2540)buf);
        }
    }

    public static void deleteAvailableQuest(Map<String, List<Quest>> availableQuest, String profession, int index) {
        List<Quest> quests = availableQuest.get(profession);
        if (quests.size() > index) {
            quests.remove(index);
            class_2540 buf = PacketByteBufs.create();
            buf.method_10814(profession);
            buf.writeInt(index);
            ClientPlayNetworking.send((class_2960)Guild.DELETE_AVAILABLE_QUEST_PACKET_ID, (class_2540)buf);
        }
    }

    public static void requestClientData() {
        ClientPlayNetworking.send((class_2960)Guild.REQUEST_CLIENT_DATA_ID, (class_2540)PacketByteBufs.create());
    }
}

