/*
 * Decompiled with CFR 0.152.
 */
package dev.fulmineo.guild.data;

import dev.fulmineo.guild.data.ClientDataManager;
import dev.fulmineo.guild.data.QuestHelper;
import dev.fulmineo.guild.data.QuestLevel;
import dev.fulmineo.guild.data.QuestPool;
import dev.fulmineo.guild.data.QuestPoolData;
import dev.fulmineo.guild.data.QuestProfessionRequirement;
import dev.fulmineo.guild.data.ServerDataManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class QuestProfession {
    public String name;
    public String icon;
    public String label;
    public int guildMasterLevel;
    public QuestProfessionRequirement[] requirements;
    public String levelsPool;
    public String[] taskPools;
    public String[] rewardPools;
    public List<QuestPoolData> tasks = new ArrayList<QuestPoolData>();
    public List<QuestPoolData> rewards = new ArrayList<QuestPoolData>();

    public void addTaskPool(QuestPool pool) {
        this.tasks.addAll(Arrays.asList(pool.data));
    }

    public void addRewardPool(QuestPool pool) {
        this.rewards.addAll(Arrays.asList(pool.data));
    }

    public boolean checkRequirements(Map<String, Integer> professionsExp) {
        if (this.requirements != null) {
            for (QuestProfessionRequirement req : this.requirements) {
                if (req.level == null && req.profession == null) continue;
                if (req.profession != null) {
                    Integer exp = professionsExp.get(req.profession);
                    if (exp == null) {
                        return false;
                    }
                    if (req.level == null) continue;
                    QuestProfession profession = ServerDataManager.professions.get(req.profession);
                    if (profession == null) {
                        return false;
                    }
                    List<QuestLevel> levels = ServerDataManager.levels.get(profession.levelsPool);
                    if (levels == null) {
                        return false;
                    }
                    int level = QuestHelper.getCurrentLevel(levels, exp) + 1;
                    if (req.level.contains(level)) continue;
                    return false;
                }
                for (Map.Entry<String, Integer> entry : professionsExp.entrySet()) {
                    int level;
                    List<QuestLevel> levels;
                    Integer exp;
                    String professionName = entry.getKey();
                    QuestProfession profession = ServerDataManager.professions.get(professionName);
                    if (profession == null || (exp = professionsExp.get(professionName)) == null || (levels = ServerDataManager.levels.get(profession.levelsPool)) == null || !req.level.contains(level = QuestHelper.getCurrentLevel(levels, exp) + 1)) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public void merge(QuestProfession professionToMerge) {
        if (this.name == null) {
            this.name = professionToMerge.name;
        }
        if (this.icon == null) {
            this.icon = professionToMerge.icon;
        }
        if (this.label == null) {
            this.label = professionToMerge.label;
        }
        if (this.guildMasterLevel == 0) {
            this.guildMasterLevel = professionToMerge.guildMasterLevel;
        }
        if (this.requirements == null) {
            this.requirements = professionToMerge.requirements;
        }
        if (this.levelsPool == null) {
            this.levelsPool = professionToMerge.levelsPool;
        }
        if (this.taskPools == null) {
            this.taskPools = professionToMerge.taskPools;
        }
        if (this.rewardPools == null) {
            this.rewardPools = professionToMerge.rewardPools;
        }
        ArrayList<String> taskPools = new ArrayList<String>(Arrays.asList(this.taskPools));
        ArrayList<String> rewardPools = new ArrayList<String>(Arrays.asList(this.rewardPools));
        for (String task : professionToMerge.taskPools) {
            if (taskPools.contains(task)) continue;
            taskPools.add(task);
        }
        for (String reward : professionToMerge.rewardPools) {
            if (rewardPools.contains(reward)) continue;
            rewardPools.add(reward);
        }
        this.taskPools = taskPools.toArray(new String[0]);
        this.rewardPools = rewardPools.toArray(new String[0]);
    }

    public static String getTranslationKey(String name) {
        return "profession." + name.replace(":", ".");
    }

    public static class_5250 getTranslatedText(String name) {
        String label = ClientDataManager.professionsLabels.get(name);
        return label != null ? class_2561.method_43470((String)label) : class_2561.method_43471((String)QuestProfession.getTranslationKey(name));
    }
}

