/*
 * Decompiled with CFR 0.152.
 */
package dev.fulmineo.guild.data;

import dev.fulmineo.guild.Guild;
import dev.fulmineo.guild.data.Range;
import dev.fulmineo.guild.data.WeightedItem;
import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class QuestPoolData
implements WeightedItem {
    public String type;
    public String name;
    public String icon;
    public Range level;
    public Range number;
    public class_2487 tag;
    public class_2487 iconTag;
    public int unitWorth;
    public int unitTime;
    public float unitExp;
    public float unitPlayerExp;
    public int weight;

    @Override
    public int getWeight() {
        return this.weight;
    }

    public boolean isAvailableFor(int level) {
        if (this.level == null) {
            return true;
        }
        return this.level.contains(level);
    }

    public int getQuantityInRange() {
        return this.number.getQuantityInRange();
    }

    public int getMinWorth() {
        return this.number.min * this.unitWorth;
    }

    public int getCountByWorth(int worth) {
        Integer max = this.getMax();
        return max != null ? Math.min(max, worth / this.unitWorth) : worth / this.unitWorth;
    }

    public Integer getMax() {
        if (this.number.max != null) {
            return this.number.max;
        }
        if (this.type == "item") {
            return ((class_1792)class_7923.field_41178.method_10223(new class_2960(this.name))).method_7882();
        }
        return null;
    }

    public String validate() {
        switch (this.type) {
            case "item": {
                if (class_7923.field_41178.method_10250(new class_2960(this.name))) {
                    return "";
                }
            }
            case "slay": 
            case "summon": 
            case "cure": {
                if (class_7923.field_41177.method_10250(new class_2960(this.name))) {
                    return "";
                }
            }
            case "currency": {
                if (Guild.economyDependency != null) {
                    return Guild.economyDependency.validateCurrency(this.name);
                }
                return this.name + " no economy installed";
            }
        }
        return this.name;
    }
}

