/*
 * Decompiled with CFR 0.152.
 */
package dev.fulmineo.guild.data;

import dev.fulmineo.guild.Guild;
import dev.fulmineo.guild.data.GuildServerPlayerEntity;
import dev.fulmineo.guild.data.Quest;
import dev.fulmineo.guild.data.QuestLevel;
import dev.fulmineo.guild.data.QuestProfession;
import dev.fulmineo.guild.data.ServerDataManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class QuestHelper {
    public static void updateQuestSlay(class_1657 player, class_1309 killedEntity) {
        List<Quest> guildQuests = ((GuildServerPlayerEntity)player).getAcceptedQuests();
        String entityIdentifier = class_1299.method_5890((class_1299)killedEntity.method_5864()).toString();
        for (Quest quest : guildQuests) {
            quest.updateSlay(entityIdentifier, killedEntity, player);
        }
    }

    public static void updateQuestCure(class_1657 player, class_1309 curedEntity) {
        List<Quest> guildQuests = ((GuildServerPlayerEntity)player).getAcceptedQuests();
        String entityIdentifier = class_1299.method_5890((class_1299)curedEntity.method_5864()).toString();
        for (Quest quest : guildQuests) {
            quest.updateCure(entityIdentifier, curedEntity, player);
        }
    }

    public static void updateQuestSummon(class_1657 player, class_1309 summonedEntity) {
        List<Quest> guildQuests = ((GuildServerPlayerEntity)player).getAcceptedQuests();
        String entityIdentifier = class_1299.method_5890((class_1299)summonedEntity.method_5864()).toString();
        for (Quest quest : guildQuests) {
            quest.updateSummon(entityIdentifier, summonedEntity, player);
        }
    }

    public static class_2487 writeNbt(class_2487 nbt, List<Quest> guildQuests) {
        class_2499 questData = new class_2499();
        for (Quest quest : guildQuests) {
            questData.add((Object)quest.writeNbt(new class_2487()));
        }
        nbt.method_10566("Quests", (class_2520)questData);
        return nbt;
    }

    public static List<Quest> fromNbt(class_2487 nbt) {
        class_2499 questData = nbt.method_10554("Quests", 10);
        ArrayList<Quest> guildQuests = new ArrayList<Quest>();
        for (class_2520 data : questData) {
            guildQuests.add(Quest.fromNbt((class_2487)data));
        }
        return guildQuests;
    }

    public static void refreshAvailableQuests(List<QuestProfession> professions, class_1657 player) {
        long time = player.method_37908().method_8510();
        GuildServerPlayerEntity guildPlayer = (GuildServerPlayerEntity)player;
        Map<String, List<Quest>> availableQuests = guildPlayer.getAvailableQuests();
        if (professions.size() > 0) {
            long lastGenTime = guildPlayer.getLastQuestGenTime();
            long lastGenTimeFrame = lastGenTime % (long)Guild.CONFIG.questGenerationTicks;
            long currentGenTimeFrame = time % (long)Guild.CONFIG.questGenerationTicks;
            int questsToGenerate = Math.min((int)((time - currentGenTimeFrame - (lastGenTime - lastGenTimeFrame)) / (long)Guild.CONFIG.questGenerationTicks), Guild.CONFIG.maxQuestsPerGeneration);
            for (List<Quest> list : availableQuests.values()) {
                Iterator<Quest> iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().nbt.method_10537("AvailableUntil") >= time) continue;
                    iterator.remove();
                }
            }
            ArrayList<QuestProfession> availableProfessions = new ArrayList<QuestProfession>();
            for (QuestProfession profession : professions) {
                List<Quest> professionsQuest = availableQuests.get(profession.name);
                if (professionsQuest != null && professionsQuest.size() >= Guild.CONFIG.getMaxQuestsPerProfession()) continue;
                availableProfessions.add(profession);
            }
            int n = QuestHelper.generateQuests(player, availableProfessions, questsToGenerate);
            if (n > 0) {
                guildPlayer.setLastQuestGenTime(time);
            }
        }
    }

    public static int generateQuests(class_1657 player, List<QuestProfession> availableProfessions, int questsToGenerate) {
        int i;
        class_1937 world = player.method_37908();
        GuildServerPlayerEntity guildPlayer = (GuildServerPlayerEntity)player;
        Map<String, List<Quest>> availableQuests = guildPlayer.getAvailableQuests();
        for (i = 0; i < questsToGenerate && availableProfessions.size() != 0; ++i) {
            int professionIndex = world.field_9229.method_43048(availableProfessions.size());
            QuestProfession profession = availableProfessions.get(professionIndex);
            List<Object> quests = availableQuests.containsKey(profession.name) ? availableQuests.get(profession.name) : new ArrayList<Quest>();
            quests.add(Quest.create(profession, player));
            availableQuests.put(profession.name, quests);
            if (quests.size() != Guild.CONFIG.getMaxQuestsPerProfession()) continue;
            availableProfessions.remove(professionIndex);
        }
        return i;
    }

    public static class_2487 writeMapNbt(class_2487 nbt, Map<String, List<Quest>> availableQuests) {
        class_2487 professionsData = new class_2487();
        for (Map.Entry<String, List<Quest>> professionQuests : availableQuests.entrySet()) {
            class_2499 questsData = new class_2499();
            for (Quest quest : professionQuests.getValue()) {
                questsData.add((Object)quest.writeNbt(new class_2487()));
            }
            professionsData.method_10566(professionQuests.getKey(), (class_2520)questsData);
        }
        nbt.method_10566("QuestMap", (class_2520)professionsData);
        return nbt;
    }

    public static Map<String, List<Quest>> fromMapNbt(class_2487 nbt) {
        HashMap<String, List<Quest>> availableQuests = new HashMap<String, List<Quest>>();
        class_2487 professionsData = nbt.method_10562("QuestMap");
        for (String professionName : professionsData.method_10541()) {
            ArrayList<Quest> quests = new ArrayList<Quest>();
            class_2499 questsData = professionsData.method_10554(professionName, 10);
            for (class_2520 questData : questsData) {
                quests.add(Quest.fromNbt((class_2487)questData));
            }
            availableQuests.put(professionName, quests);
        }
        return availableQuests;
    }

    public static int getCurrentLevel(List<QuestLevel> levels, int exp) {
        for (int i = levels.size() - 1; i >= 0; --i) {
            if (levels.get((int)i).exp > exp) continue;
            return i;
        }
        return levels.size() - 1;
    }

    public static class_2487 writeProfessionData(class_2487 nbt, GuildServerPlayerEntity guildPlayer, QuestProfession profession) {
        boolean levelMax;
        List<QuestLevel> levels = ServerDataManager.levels.get(profession.levelsPool);
        int exp = guildPlayer.getProfessionExp(profession.name);
        int level = QuestHelper.getCurrentLevel(levels, exp);
        nbt.method_10569("Level", level);
        boolean bl = levelMax = level == levels.size() - 1;
        if (levelMax) {
            nbt.method_10569("LevelPerc", 100);
        } else {
            QuestLevel currentLevel = levels.get(level);
            QuestLevel nextLevel = levels.get(level + 1);
            nbt.method_10569("LevelPerc", (int)((float)(exp - currentLevel.exp) / (float)(nextLevel.exp - currentLevel.exp) * 100.0f));
        }
        return nbt;
    }
}

