/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.plateau;

import corgitaco.corgilib.math.blendingfunction.BlendingFunction;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseThresholdProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructurePieceTypes;
import org.jetbrains.annotations.NotNull;

public class GourPlateauPiece
extends StructurePiece {
    private final BlockPos origin;
    private final int radius;
    private final int topY;

    protected GourPlateauPiece(BlockPos origin, int radius, int topY, BoundingBox boundingBox) {
        super(BWGStructurePieceTypes.GOUR_PLATEAU_PIECE.get(), 0, boundingBox);
        this.origin = origin;
        this.radius = radius;
        this.topY = topY;
    }

    public GourPlateauPiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(BWGStructurePieceTypes.GOUR_PLATEAU_PIECE.get(), tag);
        this.origin = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("origin"));
        this.radius = tag.m_128451_("radius");
        this.topY = tag.m_128451_("topY");
    }

    protected void m_183620_(@NotNull StructurePieceSerializationContext context, CompoundTag tag) {
        tag.m_128365_("origin", (Tag)NbtUtils.m_129224_((BlockPos)this.origin));
        tag.m_128405_("radius", this.radius);
        tag.m_128405_("topY", this.topY);
    }

    public void m_213694_(WorldGenLevel worldGenLevel, @NotNull StructureManager structureManager, @NotNull ChunkGenerator generator, @NotNull RandomSource random, @NotNull BoundingBox box, @NotNull ChunkPos chunkPos, @NotNull BlockPos pos) {
        int blockZ;
        int blockX;
        int z;
        int x;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        XoroshiroRandomSource randomSource = new XoroshiroRandomSource(worldGenLevel.m_7328_() + this.origin.m_121878_());
        ImprovedNoise noiseSampler = new ImprovedNoise((RandomSource)randomSource);
        SimplexNoise simplexNoise = new SimplexNoise((RandomSource)randomSource);
        double minRadius = (double)this.radius * 0.175;
        int plateauThickness = randomSource.m_216332_(0, 2);
        int plateauSurfacePull = randomSource.m_216332_(1, 3);
        int[] topYs = new int[256];
        int[] bottomYs = new int[256];
        Arrays.fill(topYs, Integer.MIN_VALUE);
        Arrays.fill(bottomYs, Integer.MAX_VALUE);
        NoiseThresholdProvider noiseBasedStateProvider = new NoiseThresholdProvider(worldGenLevel.m_7328_() + this.origin.m_121878_(), new NormalNoise.NoiseParameters(0, 1.0, new double[0]), 0.05f, -0.1f, 0.5f, Blocks.f_50122_.m_49966_(), List.of(Blocks.f_220843_.m_49966_()), List.of(Blocks.f_50546_.m_49966_()));
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                blockX = chunkPos.m_151382_(x);
                blockZ = chunkPos.m_151391_(z);
                int range = this.topY - this.origin.m_123342_();
                mutable.m_122178_(blockX, 0, blockZ);
                double noise = noiseSampler.m_164308_((double)blockX * 0.05, 0.0, (double)blockZ * 0.05) + 1.0;
                int minY = Math.min(worldGenLevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, blockX, blockZ) - 1, this.origin.m_123342_());
                int idx = x + z * 16;
                this.buildColumn(worldGenLevel, minRadius, minY, this.topY - minY, mutable, blockX, blockZ, noise, topYs, bottomYs, idx, (RandomSource)randomSource, (BlockStateProvider)noiseBasedStateProvider);
                this.thickenPlateau(worldGenLevel, minRadius, mutable, blockX, range, blockZ, noise, plateauThickness, topYs, bottomYs, idx, (RandomSource)randomSource, (BlockStateProvider)noiseBasedStateProvider);
                this.pullUpPlateau(worldGenLevel, minRadius, range, mutable, blockX, blockZ, noise, plateauThickness, plateauSurfacePull, topYs, bottomYs, idx, (RandomSource)randomSource, (BlockStateProvider)noiseBasedStateProvider);
                this.buildPlateauTerrain(worldGenLevel, minRadius, range, mutable, blockX, blockZ, noise, simplexNoise, plateauThickness, plateauSurfacePull, topYs, bottomYs, idx, (RandomSource)randomSource, (BlockStateProvider)noiseBasedStateProvider);
            }
        }
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                blockX = chunkPos.m_151382_(x);
                blockZ = chunkPos.m_151391_(z);
                int idx = x + z * 16;
                int topY = topYs[idx];
                if (topY == Integer.MIN_VALUE) continue;
                mutable.m_122178_(blockX, topY, blockZ);
                if (!worldGenLevel.m_8055_((BlockPos)mutable.m_122173_(Direction.DOWN)).m_60795_()) {
                    mutable.m_122173_(Direction.UP);
                    worldGenLevel.m_7731_((BlockPos)mutable, Blocks.f_50440_.m_49966_(), 2);
                }
                mutable.m_122173_(Direction.DOWN);
                if (worldGenLevel.m_8055_((BlockPos)mutable.m_122173_(Direction.DOWN)).m_60795_()) continue;
                mutable.m_122173_(Direction.UP);
                worldGenLevel.m_7731_((BlockPos)mutable, Blocks.f_50493_.m_49966_(), 2);
            }
        }
    }

    private void buildPlateauTerrain(WorldGenLevel worldGenLevel, double minRadius, int range, BlockPos.MutableBlockPos mutable, int blockX, int blockZ, double noise, SimplexNoise simplexNoise, int plateauThickness, int plateauSurfacePull, int[] topYs, int[] bottomYs, int idx, RandomSource randomSource, BlockStateProvider stateProvider) {
        double factor = Mth.m_14008_((double)((double)(range - 1 - plateauThickness - plateauSurfacePull) / (double)range), (double)0.0, (double)1.0);
        double radiusFactor = Mth.m_14085_((double)-0.5, (double)1.0, (double)factor);
        mutable.m_122178_(blockX, this.origin.m_123342_() + plateauThickness + range + plateauSurfacePull - 1, blockZ);
        double delta = noise * 0.5;
        double amplifiedDelta = Mth.m_14085_((double)0.2, (double)1.0, (double)BlendingFunction.EaseOutQuint.INSTANCE.apply(delta));
        int localRadius = (int)(BlendingFunction.EaseInCirc.INSTANCE.apply(radiusFactor, minRadius, (double)this.radius) * amplifiedDelta);
        BlockPos offsetOrigin = this.origin.m_7918_(0, plateauThickness + range + plateauSurfacePull, 0);
        if (offsetOrigin.m_123314_((Vec3i)mutable, (double)localRadius)) {
            double simplexNoiseValue = simplexNoise.m_75464_((double)blockX * 0.007, (double)blockZ * 0.007) + 1.0;
            double maxNoiseY = simplexNoiseValue * 2.0;
            double noiseFactor = Mth.m_14008_((double)(mutable.m_123331_((Vec3i)offsetOrigin) / (double)Mth.m_144944_((int)localRadius)), (double)0.0, (double)1.0);
            double apply = BlendingFunction.EaseOutCubic.INSTANCE.apply(1.0 - noiseFactor, 0.0, maxNoiseY);
            int noiseY = 0;
            while ((double)noiseY <= apply) {
                mutable.m_122173_(Direction.UP);
                worldGenLevel.m_7731_((BlockPos)mutable, stateProvider.m_213972_(randomSource, (BlockPos)mutable), 2);
                topYs[idx] = Math.max(mutable.m_123342_(), topYs[idx]);
                bottomYs[idx] = Math.max(mutable.m_123342_(), bottomYs[idx]);
                ++noiseY;
            }
        }
    }

    private void pullUpPlateau(WorldGenLevel worldGenLevel, double minRadius, int range, BlockPos.MutableBlockPos mutable, int blockX, int blockZ, double noise, int plateauThickness, int plateauSurfacePull, int[] topYs, int[] bottomYs, int idx, RandomSource randomSource, BlockStateProvider stateProvider) {
        for (int y = 0; y < plateauSurfacePull; ++y) {
            double factor = Mth.m_14008_((double)((double)(range - 2 - y) / (double)range), (double)0.0, (double)1.0);
            double radiusFactor = Mth.m_14085_((double)-0.5, (double)1.0, (double)factor);
            mutable.m_122178_(blockX, this.origin.m_123342_() + y + range + plateauThickness, blockZ);
            double delta = noise * 0.5;
            double amplifiedDelta = Mth.m_14085_((double)0.2, (double)1.0, (double)BlendingFunction.EaseOutQuint.INSTANCE.apply(delta));
            int localRadius = (int)(BlendingFunction.EaseInCirc.INSTANCE.apply(radiusFactor, minRadius, (double)this.radius) * amplifiedDelta);
            if (!this.origin.m_7918_(0, y + range + plateauThickness, 0).m_123314_((Vec3i)mutable, (double)localRadius)) continue;
            worldGenLevel.m_7731_((BlockPos)mutable, stateProvider.m_213972_(randomSource, (BlockPos)mutable), 2);
            topYs[idx] = Math.max(mutable.m_123342_(), topYs[idx]);
            bottomYs[idx] = Math.max(mutable.m_123342_(), bottomYs[idx]);
            mutable.m_142448_(this.origin.m_123342_());
        }
    }

    private void thickenPlateau(WorldGenLevel worldGenLevel, double minRadius, BlockPos.MutableBlockPos mutable, int blockX, int range, int blockZ, double noise, int plateauThickness, int[] topYs, int[] bottomYs, int idx, RandomSource randomSource, BlockStateProvider stateProvider) {
        double factor = Mth.m_14008_((double)((double)(range - 1) / (double)range), (double)0.0, (double)1.0);
        double radiusFactor = Mth.m_14085_((double)-0.5, (double)1.0, (double)factor);
        double delta = noise * 0.5;
        double amplifiedDelta = Mth.m_14085_((double)0.2, (double)1.0, (double)BlendingFunction.EaseOutQuint.INSTANCE.apply(delta));
        int localRadius = (int)(BlendingFunction.EaseInCirc.INSTANCE.apply(radiusFactor, minRadius, (double)this.radius) * amplifiedDelta);
        for (int y = 0; y < plateauThickness; ++y) {
            mutable.m_122178_(blockX, this.origin.m_123342_() + y + range, blockZ);
            if (!this.origin.m_7918_(0, y + range, 0).m_123314_((Vec3i)mutable, (double)localRadius)) continue;
            worldGenLevel.m_7731_((BlockPos)mutable, stateProvider.m_213972_(randomSource, (BlockPos)mutable), 2);
            topYs[idx] = Math.max(mutable.m_123342_(), topYs[idx]);
            bottomYs[idx] = Math.max(mutable.m_123342_(), bottomYs[idx]);
            mutable.m_142448_(this.origin.m_123342_());
        }
    }

    private void buildColumn(WorldGenLevel worldGenLevel, double minRadius, int minY, int range, BlockPos.MutableBlockPos mutable, int blockX, int blockZ, double noise, int[] topYs, int[] bottomYs, int idx, RandomSource randomSource, BlockStateProvider stateProvider) {
        for (int y = 0; y < range; ++y) {
            double factor = Mth.m_14008_((double)((double)y / (double)range), (double)0.0, (double)1.0);
            double radiusFactor = Mth.m_14085_((double)-0.5, (double)1.0, (double)factor);
            mutable.m_122178_(blockX, minY + y, blockZ);
            double delta = noise * 0.5;
            double amplifiedDelta = Mth.m_14085_((double)0.2, (double)1.0, (double)BlendingFunction.EaseOutQuint.INSTANCE.apply(delta));
            int localRadius = (int)(BlendingFunction.EaseInCirc.INSTANCE.apply(radiusFactor, minRadius, (double)this.radius) * amplifiedDelta);
            if (!this.origin.m_175288_(minY).m_7918_(0, y, 0).m_123314_((Vec3i)mutable, (double)localRadius)) continue;
            worldGenLevel.m_7731_((BlockPos)mutable, stateProvider.m_213972_(randomSource, (BlockPos)mutable), 2);
            topYs[idx] = Math.max(mutable.m_123342_(), topYs[idx]);
            bottomYs[idx] = Math.max(mutable.m_123342_(), bottomYs[idx]);
            mutable.m_142448_(minY);
        }
    }
}

