/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.damageindicator.overlays;

import com.jeremyseq.damageindicator.DamageIndicatorConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.joml.Quaternionf;

public class IndicatorOverlay {
    public static final int INDICATOR_TEXTURES_COUNT = 2;
    private static ResourceLocation INDICATOR_TEXTURE = null;
    private static final ResourceLocation BLOOD_OVERLAY = new ResourceLocation("damageindicator", "textures/overlays/blood_overlay.png");
    public static Vec3 damageSource = null;
    public static boolean showDirectional = false;
    public static float counter = 0.0f;
    private static boolean showBlood = false;
    private static float bloodAlpha = 0.0f;
    private static final float BLOOD_FADE_SPEED = 0.02f;
    public static final IGuiOverlay DAMAGE_INDICATOR = (gui, poseStack, partialTick, width, height) -> {
        if (!gui.getMinecraft().f_91066_.f_92062_ && gui.getMinecraft().f_91066_.m_92176_().m_90612_()) {
            int x = width / 2;
            int y = height / 2;
            float deltaFrameTime = gui.getMinecraft().m_91297_();
            if (showBlood && ((Boolean)DamageIndicatorConfig.ENABLE_BLOOD_OVERLAY.get()).booleanValue()) {
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BLOOD_OVERLAY);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)bloodAlpha);
                bloodAlpha -= 0.02f * deltaFrameTime;
                if (bloodAlpha <= 0.0f) {
                    showBlood = false;
                    bloodAlpha = 0.0f;
                }
                poseStack.m_280411_(BLOOD_OVERLAY, 0, 0, width, height, 0.0f, 0.0f, width, height, width, height);
            }
            if (showDirectional && ((Boolean)DamageIndicatorConfig.ENABLE_DIRECTIONAL_INDICATOR.get()).booleanValue()) {
                if ((counter += deltaFrameTime) >= (float)((Integer)DamageIndicatorConfig.INDICATE_TIME.get()).intValue()) {
                    showDirectional = false;
                }
                RenderSystem.setShader(GameRenderer::m_172817_);
                float r = (float)((Integer)DamageIndicatorConfig.DIRECTIONAL_INDICATOR_R.get()).intValue() / 255.0f;
                float g = (float)((Integer)DamageIndicatorConfig.DIRECTIONAL_INDICATOR_G.get()).intValue() / 255.0f;
                float b = (float)((Integer)DamageIndicatorConfig.DIRECTIONAL_INDICATOR_B.get()).intValue() / 255.0f;
                float a = (float)((Integer)DamageIndicatorConfig.DIRECTIONAL_INDICATOR_A.get()).intValue() / 255.0f;
                if (((Boolean)DamageIndicatorConfig.ENABLE_FADE_OUT.get()).booleanValue()) {
                    a = a * ((float)((Integer)DamageIndicatorConfig.INDICATE_TIME.get()).intValue() - counter) / (float)((Integer)DamageIndicatorConfig.INDICATE_TIME.get()).intValue();
                }
                RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
                assert (Minecraft.m_91087_().f_91074_ != null);
                double finalAngle = IndicatorOverlay.calculateFinalAngle(Minecraft.m_91087_().f_91074_.m_20156_(), Minecraft.m_91087_().f_91074_.m_20182_(), Minecraft.m_91087_().f_91074_.m_20182_().m_82549_(damageSource.m_82546_(Minecraft.m_91087_().f_91074_.m_20182_())));
                float radians = (float)Math.toRadians(finalAngle);
                float radians2 = (float)Math.toRadians(finalAngle - 90.0);
                int textureWidth = 100;
                int distanceFromCenter = (Integer)DamageIndicatorConfig.DIRECTIONAL_INDICATOR_DISTANCE.get();
                float indicatorX = (float)x + (float)((double)distanceFromCenter * Math.cos(radians2));
                float indicatorY = (float)y + (float)((double)distanceFromCenter * Math.sin(radians2));
                poseStack.m_280168_().m_252880_(indicatorX, indicatorY, 0.0f);
                Quaternionf quaternion = new Quaternionf(0.0, 0.0, Math.sin(radians / 2.0f), Math.cos(radians / 2.0f));
                poseStack.m_280168_().m_252781_(quaternion);
                poseStack.m_280168_().m_252880_(-indicatorX, -indicatorY, 0.0f);
                poseStack.m_280163_(INDICATOR_TEXTURE, (int)(indicatorX - (float)textureWidth / 2.0f), (int)(indicatorY - (float)textureWidth / 2.0f), 0.0f, 0.0f, textureWidth, textureWidth, textureWidth, textureWidth);
                poseStack.m_280168_().m_252880_(indicatorX, indicatorY, 0.0f);
                poseStack.m_280168_().m_252781_(quaternion.invert());
                poseStack.m_280168_().m_252880_(-indicatorX, -indicatorY, 0.0f);
            } else {
                counter = 0.0f;
            }
        }
    };

    public static void setup() {
        INDICATOR_TEXTURE = new ResourceLocation("damageindicator", "textures/overlays/directional_indicator_" + DamageIndicatorConfig.DIRECTIONAL_INDICATOR_TEXTURE.get() + ".png");
    }

    public static void triggerOverlay(Vec3 sourcePosition) {
        damageSource = sourcePosition;
        showDirectional = true;
        counter = 0.0f;
        showBlood = true;
        bloodAlpha = 1.0f;
    }

    private static double calculateFinalAngle(Vec3 playerForward, Vec3 playerPosition, Vec3 damagePosition) {
        double playerAngle = Math.atan2(playerForward.f_82479_, playerForward.f_82481_) * 180.0 / Math.PI;
        Vec2 enemyVec = new Vec2((float)damagePosition.f_82479_, (float)damagePosition.f_82481_).m_165910_(new Vec2((float)playerPosition.f_82479_, (float)playerPosition.f_82481_).m_165913_());
        double enemyAngle = Math.atan2(enemyVec.f_82470_, enemyVec.f_82471_) * 180.0 / Math.PI;
        double finalAngle = enemyAngle - playerAngle;
        return -finalAngle;
    }
}

