/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.damageindicator.events;

import com.jeremyseq.damageindicator.DamageIndicatorConfig;
import com.jeremyseq.damageindicator.damage_text.DamageTextHandler;
import com.jeremyseq.damageindicator.overlays.IndicatorOverlay;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class DamageHandler {
    private static float lastHealth = -1.0f;
    public static final HashMap<Integer, Float> lastHealthForOtherEntities = new HashMap();

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            LocalPlayer player = mc.f_91074_;
            if (((Boolean)DamageIndicatorConfig.ENABLE_DIRECTIONAL_INDICATOR.get()).booleanValue()) {
                float currentHealth = player.m_21223_();
                boolean tookDamage = lastHealth != -1.0f && currentHealth < lastHealth;
                lastHealth = currentHealth;
                if (player.m_21225_() != null && player.m_21225_().m_7270_() != null) {
                    Vec3 damageSource = player.m_21225_().m_7270_();
                    if (tookDamage) {
                        IndicatorOverlay.triggerOverlay(damageSource);
                    }
                }
            }
            if (((Boolean)DamageIndicatorConfig.ENABLE_DAMAGE_TEXT.get()).booleanValue()) {
                AABB aabb = new AABB(player.m_20185_() - 50.0, player.m_20186_() - 50.0, player.m_20189_() - 50.0, player.m_20185_() + 50.0, player.m_20186_() + 50.0, player.m_20189_() + 50.0);
                List nearbyEntities = player.m_9236_().m_45933_((Entity)player, aabb);
                HashSet<Integer> inRangeEntityIds = new HashSet<Integer>();
                for (Entity entity : nearbyEntities) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    inRangeEntityIds.add(livingEntity.m_19879_());
                    if (lastHealthForOtherEntities.containsKey(livingEntity.m_19879_()) && livingEntity.m_21223_() < lastHealthForOtherEntities.get(livingEntity.m_19879_()).floatValue() && entity.m_19879_() != Minecraft.m_91087_().f_91074_.m_19879_()) {
                        double x = entity.m_20185_();
                        double y = entity.m_20186_() + (double)entity.m_20192_();
                        double z = entity.m_20189_();
                        float damage = lastHealthForOtherEntities.get(livingEntity.m_19879_()).floatValue() - livingEntity.m_21223_();
                        DamageSource source = livingEntity.m_21225_();
                        DamageTextHandler.damageTexts.add(new DamageTextHandler.DamageText(x, y, z, damage, source));
                    }
                    lastHealthForOtherEntities.put(livingEntity.m_19879_(), Float.valueOf(livingEntity.m_21223_()));
                }
                lastHealthForOtherEntities.keySet().removeIf(id -> !inRangeEntityIds.contains(id));
            }
        }
    }
}

