/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.damageindicator.damage_text;

import com.jeremyseq.damageindicator.DamageIndicatorConfig;
import com.jeremyseq.damageindicator.events.DamageHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="damageindicator", value={Dist.CLIENT})
public class HealthBarRenderer {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderWorldStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            if (!((Boolean)DamageIndicatorConfig.ENABLE_HEALTH_BARS.get()).booleanValue()) {
                return;
            }
            PoseStack poseStack = event.getPoseStack();
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return;
            }
            MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
            if (((Boolean)DamageIndicatorConfig.ONLY_SHOW_TARGET_HEALTH_BAR.get()).booleanValue()) {
                HitResult hitResult = mc.f_91077_;
                if (hitResult instanceof EntityHitResult) {
                    EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                    int id = entityHitResult.m_82443_().m_19879_();
                    HealthBarRenderer.renderHealthBar(poseStack, id, bufferSource);
                }
            } else {
                for (int entityId : DamageHandler.lastHealthForOtherEntities.keySet()) {
                    HealthBarRenderer.renderHealthBar(poseStack, entityId, bufferSource);
                }
            }
        }
    }

    private static boolean hasLineOfSight(LivingEntity player, Level level, float x, float y, float z, double distance) {
        Vec3 vec3 = new Vec3((double)x, (double)y, (double)z);
        Vec3 vec31 = new Vec3(player.m_20185_(), player.m_20188_(), player.m_20189_());
        if (vec31.m_82554_(vec3) > distance) {
            return false;
        }
        return level.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, null)).m_6662_() == HitResult.Type.MISS;
    }

    private static void renderHealthBar(PoseStack poseStack, int entityId, MultiBufferSource.BufferSource bufferSource) {
        assert (Minecraft.m_91087_().f_91073_ != null);
        if (!DamageHandler.lastHealthForOtherEntities.containsKey(entityId)) {
            return;
        }
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(entityId);
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        if (!DamageHandler.lastHealthForOtherEntities.containsKey(entityId)) {
            return;
        }
        float y = (float)(entity2.m_20186_() + (double)entity2.m_20206_() + (double)0.4f);
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher renderManager = mc.m_91290_();
        Font fontRenderer = mc.f_91062_;
        assert (mc.f_91074_ != null);
        if (!HealthBarRenderer.hasLineOfSight((LivingEntity)mc.f_91074_, mc.f_91074_.m_9236_(), (float)entity2.m_20185_(), y, (float)entity2.m_20189_(), 20.0)) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(entity2.m_20185_() - renderManager.f_114358_.m_90583_().f_82479_, (double)y - renderManager.f_114358_.m_90583_().f_82480_, entity2.m_20189_() - renderManager.f_114358_.m_90583_().f_82481_);
        poseStack.m_252781_(mc.m_91290_().m_253208_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Font.DisplayMode displayMode = Font.DisplayMode.SEE_THROUGH;
        String damage = String.valueOf(Math.round(DamageHandler.lastHealthForOtherEntities.get(entityId).floatValue()));
        String maxHealth = String.valueOf((int)Math.ceil(entity2.m_21233_()));
        String text = damage + " / " + maxHealth;
        int color = new Color(255, 255, 255).getRGB();
        int textWidth = fontRenderer.m_92895_(text);
        Objects.requireNonNull(fontRenderer);
        int textHeight = 9;
        fontRenderer.m_271703_(text, (float)(-textWidth) / 2.0f, (float)(-textHeight) / 2.0f, color, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, displayMode, 0, 0xF000F0);
        poseStack.m_85849_();
    }
}

