/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.damageindicator.damage_text;

import com.jeremyseq.damageindicator.damage_text.DamageTextHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="damageindicator", value={Dist.CLIENT})
public class DamageTextRenderer {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderWorldStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            PoseStack poseStack = event.getPoseStack();
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return;
            }
            EntityRenderDispatcher renderManager = mc.m_91290_();
            Font fontRenderer = mc.f_91062_;
            long currentTime = System.currentTimeMillis();
            ArrayList<DamageTextHandler.DamageText> damageTexts = new ArrayList<DamageTextHandler.DamageText>(DamageTextHandler.getDamageTexts());
            damageTexts.removeIf(text -> currentTime - text.getTimestamp() > 1000L);
            MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
            for (DamageTextHandler.DamageText text2 : damageTexts) {
                if (text2 == null || !DamageTextRenderer.hasLineOfSight((LivingEntity)mc.f_91074_, mc.f_91074_.m_9236_(), (float)text2.getX(), (float)text2.getY(), (float)text2.getZ())) continue;
                long age = currentTime - text2.getTimestamp();
                float progress = (float)age / (float)text2.getDuration();
                float alpha = 1.0f - progress;
                float scale = 1.0f + 0.5f * (1.0f - progress);
                poseStack.m_85836_();
                poseStack.m_85837_(text2.getX() - renderManager.f_114358_.m_90583_().f_82479_, text2.getY() - renderManager.f_114358_.m_90583_().f_82480_, text2.getZ() - renderManager.f_114358_.m_90583_().f_82481_);
                poseStack.m_252781_(mc.m_91290_().m_253208_());
                poseStack.m_85841_(-0.025f * scale, -0.025f * scale, 0.025f * scale);
                poseStack.m_252880_(0.0f, -progress * 25.0f, 0.0f);
                Font.DisplayMode displayMode = Font.DisplayMode.SEE_THROUGH;
                String damage = String.format("%.0f", Float.valueOf(text2.getDamage()));
                int color = DamageTextRenderer.getDamageColor(text2.getDamage(), alpha).getRGB();
                int textWidth = fontRenderer.m_92895_(damage);
                Objects.requireNonNull(fontRenderer);
                int textHeight = 9;
                if (DamageTextRenderer.getDamageColor(text2.getDamage(), alpha).getAlpha() > 25) {
                    fontRenderer.m_271703_(damage, (float)(-textWidth) / 2.0f, (float)(-textHeight) / 2.0f, color, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, displayMode, 0, 0xF000F0);
                }
                poseStack.m_85849_();
            }
        }
    }

    private static boolean hasLineOfSight(LivingEntity player, Level level, float x, float y, float z) {
        Vec3 vec3 = new Vec3((double)x, (double)y, (double)z);
        Vec3 vec31 = new Vec3(player.m_20185_(), player.m_20188_(), player.m_20189_());
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        return level.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null)).m_6662_() == HitResult.Type.MISS;
    }

    private static Color getDamageColor(float damage, float alpha) {
        if (damage > 15.0f) {
            return new Color(0.0f, 0.0f, 0.0f, alpha);
        }
        if (damage > 10.0f) {
            return new Color(1.0f, 0.13333334f, 0.13333334f, alpha);
        }
        if (damage > 7.0f) {
            return new Color(1.0f, 0.50980395f, 0.0f, alpha);
        }
        return new Color(1.0f, 0.9411765f, 0.0f, alpha);
    }

    private static Color getDamageColor(DamageSource source, float alpha) {
        if (source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268565_)) {
            return new Color(1.0f, 0.27058825f, 0.0f, alpha);
        }
        if (source.m_276093_(DamageTypes.f_268515_) || source.m_276093_(DamageTypes.f_268530_)) {
            return new Color(0.5019608f, 0.0f, 0.5019608f, alpha);
        }
        if (source.m_276093_(DamageTypes.f_268722_)) {
            return new Color(0.0f, 1.0f, 1.0f, alpha);
        }
        if (source.m_276093_(DamageTypes.f_268493_)) {
            return new Color(0.29411766f, 0.0f, 0.50980395f, alpha);
        }
        if (source.m_276093_(DamageTypes.f_268464_) || source.m_276093_(DamageTypes.f_268566_)) {
            return new Color(0.69803923f, 0.13333334f, 0.13333334f, alpha);
        }
        return new Color(1.0f, 1.0f, 1.0f, alpha);
    }
}

