/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyseq.damageindicator;

import net.minecraftforge.common.ForgeConfigSpec;

public class DamageIndicatorConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_DIRECTIONAL_INDICATOR;
    public static final ForgeConfigSpec.ConfigValue<Integer> DIRECTIONAL_INDICATOR_TEXTURE;
    public static final ForgeConfigSpec.ConfigValue<Integer> DIRECTIONAL_INDICATOR_DISTANCE;
    public static final ForgeConfigSpec.ConfigValue<Integer> DIRECTIONAL_INDICATOR_R;
    public static final ForgeConfigSpec.ConfigValue<Integer> DIRECTIONAL_INDICATOR_G;
    public static final ForgeConfigSpec.ConfigValue<Integer> DIRECTIONAL_INDICATOR_B;
    public static final ForgeConfigSpec.ConfigValue<Integer> DIRECTIONAL_INDICATOR_A;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_FADE_OUT;
    public static final ForgeConfigSpec.ConfigValue<Integer> INDICATE_TIME;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_DAMAGE_TEXT;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_HEALTH_BARS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ONLY_SHOW_TARGET_HEALTH_BAR;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_BLOOD_OVERLAY;

    static {
        BUILDER.push("Directional Indicator").comment(" arrow that shows where incoming damage came from");
        ENABLE_DIRECTIONAL_INDICATOR = BUILDER.comment(" Enables the directional damage indicator").define("Enable Directional Indicator", true);
        DIRECTIONAL_INDICATOR_TEXTURE = BUILDER.comment(String.format(" %d-%d (inclusive)", 0, 1)).define("Directional Indicator Texture", (Object)0);
        DIRECTIONAL_INDICATOR_R = BUILDER.comment(" Red (0-255)").define("Directional Indicator Red", (Object)206);
        DIRECTIONAL_INDICATOR_G = BUILDER.comment(" Green (0-255)").define("Directional Indicator Green", (Object)0);
        DIRECTIONAL_INDICATOR_B = BUILDER.comment(" Blue (0-255)").define("Directional Indicator Blue", (Object)37);
        DIRECTIONAL_INDICATOR_A = BUILDER.comment(" Alpha (0-255)").define("Directional Indicator Alpha", (Object)255);
        DIRECTIONAL_INDICATOR_DISTANCE = BUILDER.comment(" Distance from the center of the screen that the directional damage indicator appears.").define("Directional Indicator Distance", (Object)0);
        ENABLE_FADE_OUT = BUILDER.comment(" Fade out the damage indicator over time").define("Enable Fade Out", true);
        INDICATE_TIME = BUILDER.comment(" Time for damage indicator to show (in ticks)").define("Indicate Time", (Object)25);
        BUILDER.pop();
        BUILDER.push("Damage Text").comment(" floating text that shows the amount of damage done to an entity");
        ENABLE_DAMAGE_TEXT = BUILDER.comment(" Enables damage text").define("Enable Damage Text", true);
        BUILDER.pop();
        BUILDER.push("Health Bar").comment(" a text health bar for entities");
        ENABLE_HEALTH_BARS = BUILDER.comment(" Enables health bar").define("Enable Health Bar", true);
        ONLY_SHOW_TARGET_HEALTH_BAR = BUILDER.comment(" Only show health bar for entities the player is directly looking at. If false, shows health bar for all nearby entities").define("Only Show Target Health Bar", true);
        BUILDER.pop();
        BUILDER.push("Blood Overlay").comment(" an overlay of red outlining your screen when you take damage");
        ENABLE_BLOOD_OVERLAY = BUILDER.comment(" Enables blood overlay").define("Enable Blood Overlay", false);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

