/*
 * Decompiled with CFR 0.152.
 */
package net.witherspawnanimation;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class ForgeConfigReader {
    public static Optional<String> readCurrentWorldServerConfig(String fileName) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return Optional.empty();
        }
        try {
            Path worldRoot = server.m_129843_(LevelResource.f_78182_);
            Path cfgPath = worldRoot.resolve("serverconfig").resolve(fileName);
            if (!Files.exists(cfgPath, new LinkOption[0])) {
                return Optional.empty();
            }
            String contents = Files.readString(cfgPath, StandardCharsets.UTF_8);
            return Optional.of(contents);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }
}

