/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.test.data;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.data.agreement.component.CompoundTagCompareBehavior;
import io.github.mortuusars.wares.data.agreement.component.RequestedItem;
import io.github.mortuusars.wares.test.framework.ITestClass;
import io.github.mortuusars.wares.test.framework.Test;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;

public class RequestedItemTests
implements ITestClass {
    @Override
    public List<Test> collect() {
        return List.of(new Test("RequestedItemEqualsProperly", player -> {
            RequestedItem requestedItem1 = new RequestedItem(Items.f_42616_, 2);
            RequestedItem requestedItem2 = new RequestedItem(Items.f_42616_, 2);
            this.assertThat(requestedItem1.equals(requestedItem2) && requestedItem2.equals(requestedItem1), String.format("'%s' and '%s' is not equal.", requestedItem1, requestedItem2));
        }), new Test("RequestedItemMatchesItemStack", player -> {
            RequestedItem requestedItem = new RequestedItem(Items.f_42616_, 2);
            ItemStack stack = new ItemStack((ItemLike)Items.f_42616_, 2);
            this.assertThat(requestedItem.matches(stack), String.format("'%s' does not match '%s'.", requestedItem, stack));
        }), new Test("RequestedItemMatchesItemStackWithTag", player -> {
            CompoundTag requestTag = new CompoundTag();
            requestTag.m_128359_("Test", "Test");
            RequestedItem requestedItem = new RequestedItem((Either<TagKey<Item>, Item>)Either.right((Object)Items.f_42616_), 2, requestTag);
            ItemStack stack = new ItemStack((ItemLike)Items.f_42616_, 2);
            CompoundTag stackTag = new CompoundTag();
            stackTag.m_128359_("Test", "Test");
            stack.m_41751_(stackTag);
            this.assertThat(requestedItem.matches(stack), String.format("'%s' does not match '%s'.", requestedItem, stack));
        }), new Test("RequestedItemDecodesItemFromJsonProperly", player -> {
            String json = "{`id`:`minecraft:emerald`,`count`:2,`tag`:{`Test`:`Test`}}".replace('`', '\"');
            JsonObject obj = GsonHelper.m_13864_((String)json);
            RequestedItem decoded = RequestedItem.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj).resultOrPartial(arg_0 -> ((Logger)Wares.LOGGER).error(arg_0)).map(Pair::getFirst).orElse(RequestedItem.EMPTY);
            ItemStack stack = new ItemStack((ItemLike)Items.f_42616_, 2);
            CompoundTag stackTag = new CompoundTag();
            stackTag.m_128359_("Test", "Test");
            stack.m_41751_(stackTag);
            this.assertThat(decoded.matches(stack), String.format("'%s' does not match '%s'.", decoded, stack));
        }), new Test("RequestedItemDecodesTagFromJsonProperly", player -> {
            String json = "{`id`:`#minecraft:logs`,`count`:2,`tag`:{`Test`:`Test`}}".replace('`', '\"');
            JsonObject obj = GsonHelper.m_13864_((String)json);
            RequestedItem decoded = RequestedItem.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj).resultOrPartial(arg_0 -> ((Logger)Wares.LOGGER).error(arg_0)).map(Pair::getFirst).orElse(RequestedItem.EMPTY);
            this.assertThat(decoded.getTagOrItem().left().isPresent(), String.valueOf(decoded) + " is not a tag.");
            ItemStack stack = new ItemStack((ItemLike)Items.f_41837_, 2);
            CompoundTag stackTag = new CompoundTag();
            stackTag.m_128359_("Test", "Test");
            stack.m_41751_(stackTag);
            this.assertThat(decoded.matches(stack), String.format("'%s' does not match '%s'.", decoded, stack));
        }), new Test("RequestedItemDecodesIgnoreTagMatching", player -> {
            String json = "{`id`:`minecraft:iron_pickaxe`,`count`:2,`tag`:{`Damage`:5},`TagMatching`:`ignore`}".replace('`', '\"');
            JsonObject obj = GsonHelper.m_13864_((String)json);
            RequestedItem decoded = RequestedItem.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj).resultOrPartial(arg_0 -> ((Logger)Wares.LOGGER).error(arg_0)).map(Pair::getFirst).orElse(RequestedItem.EMPTY);
            this.assertThat(decoded.getTagCompareBehavior() == CompoundTagCompareBehavior.IGNORE, "TagCompareBehaviour not decoded properly");
        }), new Test("RequestedItemDecodesWeakTagMatching", player -> {
            String json = "{`id`:`minecraft:iron_pickaxe`,`count`:2,`tag`:{`Damage`:5},`TagMatching`:`weak`}".replace('`', '\"');
            JsonObject obj = GsonHelper.m_13864_((String)json);
            RequestedItem decoded = RequestedItem.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj).resultOrPartial(arg_0 -> ((Logger)Wares.LOGGER).error(arg_0)).map(Pair::getFirst).orElse(RequestedItem.EMPTY);
            this.assertThat(decoded.getTagCompareBehavior() == CompoundTagCompareBehavior.WEAK, "TagCompareBehaviour not decoded properly");
        }), new Test("RequestedItemDecodesStrongTagMatching", player -> {
            String json = "{`id`:`minecraft:iron_pickaxe`,`count`:2,`tag`:{`Damage`:5},`TagMatching`:`strong`}".replace('`', '\"');
            JsonObject obj = GsonHelper.m_13864_((String)json);
            RequestedItem decoded = RequestedItem.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj).resultOrPartial(arg_0 -> ((Logger)Wares.LOGGER).error(arg_0)).map(Pair::getFirst).orElse(RequestedItem.EMPTY);
            this.assertThat(decoded.getTagCompareBehavior() == CompoundTagCompareBehavior.STRONG, "TagCompareBehaviour not decoded properly");
        }), new Test("RequestedItemWithIgnoreTagMatches", player -> {
            CompoundTag requestedTag = new CompoundTag();
            requestedTag.m_128359_("Test", "Test");
            RequestedItem requested = new RequestedItem((Either<TagKey<Item>, Item>)Either.right((Object)Items.f_42385_), 1, requestedTag, CompoundTagCompareBehavior.IGNORE);
            this.assertThat(requested.matches(new ItemStack((ItemLike)Items.f_42385_)), String.format("'%s' does not match '%s'.", requested, new ItemStack((ItemLike)Items.f_42385_)));
            ItemStack stack = new ItemStack((ItemLike)Items.f_42385_);
            CompoundTag stackTag = new CompoundTag();
            stackTag.m_128359_("Test", "Test");
            stack.m_41751_(stackTag);
            this.assertThat(requested.matches(stack), String.format("'%s' does not match '%s'.", requested, stack));
        }), new Test("RequestedItemWithIgnoreTagMatchesWithoutTagSpecified", player -> {
            RequestedItem requested = new RequestedItem((Either<TagKey<Item>, Item>)Either.right((Object)Items.f_42385_), 1, null, CompoundTagCompareBehavior.IGNORE);
            this.assertThat(requested.matches(new ItemStack((ItemLike)Items.f_42385_)), String.format("'%s' does not match '%s'.", requested, new ItemStack((ItemLike)Items.f_42385_)));
            ItemStack stack = new ItemStack((ItemLike)Items.f_42385_);
            CompoundTag stackTag = new CompoundTag();
            stackTag.m_128359_("Test", "Test");
            stack.m_41751_(stackTag);
            this.assertThat(requested.matches(stack), String.format("'%s' does not match '%s'.", requested, stack));
        }), new Test("RequestedItemWithWeakTagMatches", player -> {
            CompoundTag requestedTag = new CompoundTag();
            requestedTag.m_128405_("Damage", 5);
            RequestedItem requested = new RequestedItem((Either<TagKey<Item>, Item>)Either.right((Object)Items.f_42385_), 1, requestedTag, CompoundTagCompareBehavior.WEAK);
            ItemStack stack = new ItemStack((ItemLike)Items.f_42385_);
            CompoundTag stackTag = new CompoundTag();
            stackTag.m_128405_("Damage", 5);
            stackTag.m_128359_("Test", "Test");
            stack.m_41751_(stackTag);
            this.assertThat(requested.matches(stack), String.format("'%s' does not match '%s'.", requested, stack));
            ItemStack stack1 = new ItemStack((ItemLike)Items.f_42385_);
            CompoundTag stackTag1 = new CompoundTag();
            stackTag1.m_128405_("Damage", 4);
            stackTag1.m_128359_("Test", "Test");
            stack1.m_41751_(stackTag1);
            this.assertThat(!requested.matches(stack1), String.format("'%s' matches when shouldn't '%s'.", requested, stack1));
            this.assertThat(!requested.matches(new ItemStack((ItemLike)Items.f_42385_)), String.format("'%s' matches when shouldn't '%s'.", requested, stack1));
            requestedTag = new CompoundTag();
            requestedTag.m_128405_("Damage", 5);
            CompoundTag additional = new CompoundTag();
            additional.m_128359_("String", "SomeString");
            ListTag tags = new ListTag();
            tags.add((Object)StringTag.m_129297_((String)"2"));
            additional.m_128365_("List", (Tag)tags);
            requestedTag.m_128365_("AdditionalTag", (Tag)additional);
            requested = new RequestedItem((Either<TagKey<Item>, Item>)Either.right((Object)Items.f_42385_), 1, requestedTag, CompoundTagCompareBehavior.WEAK);
            ItemStack stack2 = new ItemStack((ItemLike)Items.f_42385_);
            CompoundTag stackTag2 = new CompoundTag();
            stackTag2.m_128405_("Damage", 5);
            CompoundTag stackTag2Add = new CompoundTag();
            stackTag2Add.m_128359_("String", "SomeString");
            ListTag tags2 = new ListTag();
            tags2.add((Object)StringTag.m_129297_((String)"1"));
            tags2.add((Object)StringTag.m_129297_((String)"2"));
            stackTag2Add.m_128365_("List", (Tag)tags2);
            stackTag2.m_128365_("AdditionalTag", (Tag)stackTag2Add);
            stack2.m_41751_(stackTag2);
            this.assertThat(requested.matches(stack2), String.format("'%s' does not match '%s'.", requested, stack2));
        }), new Test("RequestedItemWithStrongTagMatches", player -> {
            CompoundTag requestedTag = new CompoundTag();
            requestedTag.m_128405_("Damage", 5);
            RequestedItem requested = new RequestedItem((Either<TagKey<Item>, Item>)Either.right((Object)Items.f_42385_), 1, requestedTag, CompoundTagCompareBehavior.STRONG);
            ItemStack stack = new ItemStack((ItemLike)Items.f_42385_);
            CompoundTag stackTag = new CompoundTag();
            stackTag.m_128405_("Damage", 5);
            stack.m_41751_(stackTag);
            this.assertThat(requested.matches(stack), String.format("'%s' does not match '%s'.", requested, stack));
            ItemStack stack1 = new ItemStack((ItemLike)Items.f_42385_);
            CompoundTag stackTag1 = new CompoundTag();
            stackTag1.m_128405_("Damage", 5);
            stackTag1.m_128359_("Test", "Test");
            stack1.m_41751_(stackTag1);
            this.assertThat(!requested.matches(stack1), String.format("'%s' matches when shouldn't '%s'.", requested, stack1));
        }));
    }
}

