/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.item;

import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.client.gui.agreement.SealedAgreementScreen;
import io.github.mortuusars.wares.config.Config;
import io.github.mortuusars.wares.data.agreement.DeliveryAgreement;
import io.github.mortuusars.wares.data.agreement.SealedDeliveryAgreement;
import io.github.mortuusars.wares.util.ClientHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SealedDeliveryAgreementItem
extends Item {
    public static final String DAMAGED_TAG = "AgreementDamaged";
    public static final String UNOPENABLE_TAG = "AgreementUnopenable";

    public SealedDeliveryAgreementItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        if (stack.m_41783_() == null || stack.m_41783_().m_128456_() || stack.m_41783_().m_128441_(DAMAGED_TAG) || stack.m_41783_().m_128441_(UNOPENABLE_TAG)) {
            return;
        }
        SealedDeliveryAgreement.fromItemStack(stack).ifPresent(a -> tooltipComponents.add((Component)Component.m_237115_((String)"item.wares.sealed_agreement.view.tooltip").m_130948_(Style.f_131099_.m_178520_(14071177))));
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        Object id = this.m_5671_(stack);
        if (stack.m_41782_() && stack.m_41783_().m_128441_(DAMAGED_TAG)) {
            id = (String)id + "_damaged";
        }
        return Component.m_237115_((String)id);
    }

    public boolean m_142305_(@NotNull ItemStack agreementStack, @NotNull ItemStack otherStack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess slotAccess) {
        if (!otherStack.m_41619_() || action == ClickAction.PRIMARY) {
            return false;
        }
        return this.inspect(agreementStack, player);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_36341_()) {
            this.inspect(stack, player);
        } else if (stack.m_41783_() == null || stack.m_41783_().m_128456_() || stack.m_41783_().m_128441_(DAMAGED_TAG) || stack.m_41783_().m_128441_(UNOPENABLE_TAG)) {
            if (level.f_46443_) {
                player.m_5661_((Component)Component.m_237115_((String)"item.wares.sealed_delivery_agreement.damaged.message").m_130940_(ChatFormatting.RED), true);
            }
            Wares.LOGGER.error(String.valueOf(stack) + " does not have agreement data or data is not correct. Make sure item stack has agreement nbt and it is correct.");
            player.m_5496_((SoundEvent)Wares.SoundEvents.PAPER_CRACKLE.get(), 0.8f, 0.65f);
        } else {
            player.m_6672_(hand);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public boolean inspect(ItemStack sealedAgreementStack, Player player) {
        Optional<SealedDeliveryAgreement> sealed = SealedDeliveryAgreement.fromItemStack(sealedAgreementStack);
        if (sealed.isEmpty()) {
            return false;
        }
        if (player.m_9236_().f_46443_) {
            new SealedAgreementScreen(sealed.get().seal(), sealed.get().sealTooltip(), sealed.get().backsideMessage()).showAsOverlay();
        }
        return true;
    }

    @NotNull
    public SoundEvent m_6061_() {
        return (SoundEvent)Wares.SoundEvents.PAPER_CRACKLE.get();
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return 25;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.EAT;
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        if (!(livingEntity instanceof Player)) {
            return stack;
        }
        Player player = (Player)livingEntity;
        Optional<SealedDeliveryAgreement> descriptionOptional = SealedDeliveryAgreement.fromItemStack(stack);
        if (descriptionOptional.isEmpty()) {
            Wares.LOGGER.error("Cannot read AgreementDescription from stack nbt.");
            stack.m_41784_().m_128379_(DAMAGED_TAG, true);
            if (level.f_46443_) {
                player.m_5661_((Component)Component.m_237115_((String)"item.wares.sealed_delivery_agreement.damaged.message"), true);
            }
            return stack;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            try {
                DeliveryAgreement agreement = descriptionOptional.get().realize(serverLevel);
                ItemStack agreementStack = new ItemStack((ItemLike)Wares.Items.DELIVERY_AGREEMENT.get());
                if (((Boolean)Config.KEEP_SEALED_STACK_NBT_WHEN_OPENED.get()).booleanValue()) {
                    CompoundTag oldTag = stack.m_41783_().m_6426_();
                    agreementStack.m_41751_(oldTag);
                }
                if (agreement.toItemStack(agreementStack)) {
                    player.m_36220_(Wares.Stats.SEALED_LETTERS_OPENED);
                    level.m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, (SoundEvent)Wares.SoundEvents.PAPER_TEAR.get(), SoundSource.PLAYERS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.95f);
                    return agreementStack;
                }
                throw new IllegalStateException("Saving Agreement to ItemStack failed.");
            }
            catch (Exception e) {
                Wares.LOGGER.error(e.toString());
                player.m_5661_((Component)Component.m_237115_((String)"item.wares.sealed_delivery_agreement.unopenable.message"), true);
                stack.m_41784_().m_128379_(UNOPENABLE_TAG, true);
            }
        }
        if (level.f_46443_) {
            ClientHelper.releaseUseKey();
        }
        return stack;
    }
}

